/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.net.URL;
import java.util.List;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.StartTagType;
import org.junit.Assert;
import org.junit.Test;

public class ScriptTest {
    private static final String sourceUrlString = "file:test/data/ScriptTest.html";

    @Test
    public void testFullSequentialParse() throws Exception {
        Source source = new Source(new URL(sourceUrlString));
        source.fullSequentialParse();
        List<Element> scriptElements = source.getAllElements("script");
        Assert.assertEquals((long)4L, (long)scriptElements.size());
        List<StartTag> scriptContentStartTags = scriptElements.get(0).getContent().getAllStartTags();
        Assert.assertEquals((long)0L, (long)scriptContentStartTags.size());
        scriptContentStartTags = scriptElements.get(1).getContent().getAllStartTags();
        Assert.assertEquals((long)0L, (long)scriptContentStartTags.size());
        scriptContentStartTags = scriptElements.get(2).getContent().getAllStartTags();
        Assert.assertEquals((long)0L, (long)scriptContentStartTags.size());
        scriptContentStartTags = scriptElements.get(3).getContent().getAllStartTags();
        Assert.assertEquals((long)2L, (long)scriptContentStartTags.size());
        StartTag scriptContentStartTag = scriptContentStartTags.get(0);
        Assert.assertEquals((Object)"p", (Object)scriptContentStartTag.getName());
        scriptContentStartTag = scriptContentStartTags.get(1);
        Assert.assertEquals((Object)"p", (Object)scriptContentStartTag.getName());
    }

    @Test
    public void testParseOnDemand() throws Exception {
        Source source = new Source(new URL(sourceUrlString));
        List<Element> scriptElements = source.getAllElements("script");
        Assert.assertEquals((long)4L, (long)scriptElements.size());
        List<StartTag> scriptContentStartTags = scriptElements.get(0).getContent().getAllStartTags();
        Assert.assertEquals((long)1L, (long)scriptContentStartTags.size());
        StartTag scriptContentStartTag = scriptContentStartTags.get(0);
        Assert.assertEquals((Object)"p", (Object)scriptContentStartTag.getName());
        scriptContentStartTags = scriptElements.get(1).getContent().getAllStartTags();
        Assert.assertEquals((long)1L, (long)scriptContentStartTags.size());
        scriptContentStartTag = scriptContentStartTags.get(0);
        Assert.assertEquals((Object)StartTagType.CDATA_SECTION, (Object)scriptContentStartTag.getTagType());
        scriptContentStartTags = scriptElements.get(2).getContent().getAllStartTags();
        Assert.assertEquals((long)2L, (long)scriptContentStartTags.size());
        scriptContentStartTag = scriptContentStartTags.get(0);
        Assert.assertEquals((Object)StartTagType.COMMENT, (Object)scriptContentStartTag.getTagType());
        scriptContentStartTag = scriptContentStartTags.get(1);
        Assert.assertEquals((Object)"p", (Object)scriptContentStartTag.getName());
        scriptContentStartTags = scriptElements.get(3).getContent().getAllStartTags();
        Assert.assertEquals((long)2L, (long)scriptContentStartTags.size());
        scriptContentStartTag = scriptContentStartTags.get(0);
        Assert.assertEquals((Object)StartTagType.COMMENT, (Object)scriptContentStartTag.getTagType());
        scriptContentStartTag = scriptContentStartTags.get(1);
        Assert.assertEquals((Object)"p", (Object)scriptContentStartTag.getName());
        Assert.assertEquals((Object)"<p>This paragraph is recognised in both modes.</p>", (Object)scriptContentStartTag.getElement().toString());
    }
}

