/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.CharacterReference;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.FormControl;
import net.htmlparser.jericho.FormFields;
import net.htmlparser.jericho.HTMLElements;
import net.htmlparser.jericho.NodeIterator;
import net.htmlparser.jericho.Renderer;
import net.htmlparser.jericho.RowColumnVector;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.Tag;
import net.htmlparser.jericho.TagType;
import net.htmlparser.jericho.TextExtractor;
import net.htmlparser.jericho.URIAttributes;

public class Segment
implements Comparable<Segment>,
CharSequence {
    final int begin;
    final int end;
    final Source source;
    private static final char[] WHITESPACE = new char[]{' ', '\n', '\r', '\t', '\f', '\u200b'};

    public Segment(Source source, int begin, int end) {
        if (begin == -1 || end == -1 || begin > end) {
            throw new IllegalArgumentException();
        }
        this.begin = begin;
        this.end = end;
        if (source == null) {
            throw new IllegalArgumentException("source argument must not be null");
        }
        this.source = source;
    }

    Segment(int length) {
        this.begin = 0;
        this.end = length;
        this.source = (Source)this;
    }

    Segment() {
        this(0, 0);
    }

    Segment(int begin, int end) {
        this.begin = begin;
        this.end = end;
        this.source = null;
    }

    public final Source getSource() {
        if (this.source.isStreamed()) {
            throw new UnsupportedOperationException("Source object is not available when using StreamedSource");
        }
        return this.source;
    }

    public final int getBegin() {
        return this.begin;
    }

    public final int getEnd() {
        return this.end;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Segment)) {
            return false;
        }
        Segment segment = (Segment)object;
        return segment.begin == this.begin && segment.end == this.end && segment.source == this.source;
    }

    public int hashCode() {
        return this.begin + this.end;
    }

    @Override
    public int length() {
        return this.end - this.begin;
    }

    public final boolean encloses(Segment segment) {
        return this.begin <= segment.begin && this.end >= segment.end;
    }

    public final boolean encloses(int pos) {
        return this.begin <= pos && pos < this.end;
    }

    @Override
    public String toString() {
        return this.source.subSequence(this.begin, this.end).toString();
    }

    public Renderer getRenderer() {
        return new Renderer(this);
    }

    public TextExtractor getTextExtractor() {
        return new TextExtractor(this);
    }

    public Iterator<Segment> getNodeIterator() {
        return new NodeIterator(this);
    }

    public List<Tag> getAllTags() {
        return this.getAllTags(null);
    }

    public List<Tag> getAllTags(TagType tagType) {
        Tag tag = this.checkTagEnclosure(Tag.getNextTag(this.source, this.begin, tagType));
        if (tag == null) {
            return Collections.emptyList();
        }
        ArrayList<Tag> list = new ArrayList<Tag>();
        do {
            list.add(tag);
        } while ((tag = this.checkTagEnclosure(tag.getNextTag(tagType))) != null);
        return list;
    }

    public List<StartTag> getAllStartTags() {
        StartTag startTag = this.checkEnclosure(StartTag.getNext(this.source, this.begin));
        if (startTag == null) {
            return Collections.emptyList();
        }
        ArrayList<StartTag> list = new ArrayList<StartTag>();
        do {
            list.add(startTag);
        } while ((startTag = this.checkEnclosure(startTag.getNextStartTag())) != null);
        return list;
    }

    public List<StartTag> getAllStartTags(StartTagType startTagType) {
        if (startTagType == null) {
            return this.getAllStartTags();
        }
        StartTag startTag = (StartTag)this.checkTagEnclosure(Tag.getNextTag(this.source, this.begin, startTagType));
        if (startTag == null) {
            return Collections.emptyList();
        }
        ArrayList<StartTag> list = new ArrayList<StartTag>();
        do {
            list.add(startTag);
        } while ((startTag = (StartTag)this.checkTagEnclosure(startTag.getNextTag(startTagType))) != null);
        return list;
    }

    public List<StartTag> getAllStartTags(String name) {
        if (name == null) {
            return this.getAllStartTags();
        }
        boolean isXMLTagName = Tag.isXMLName(name);
        StartTag startTag = this.checkEnclosure(StartTag.getNext(this.source, this.begin, name = name.toLowerCase(), StartTagType.NORMAL, isXMLTagName));
        if (startTag == null) {
            return Collections.emptyList();
        }
        ArrayList<StartTag> list = new ArrayList<StartTag>();
        do {
            list.add(startTag);
        } while ((startTag = this.checkEnclosure(StartTag.getNext(this.source, startTag.begin + 1, name, StartTagType.NORMAL, isXMLTagName))) != null);
        return list;
    }

    public List<StartTag> getAllStartTags(String attributeName, String value, boolean valueCaseSensitive) {
        StartTag startTag = this.checkEnclosure(this.source.getNextStartTag(this.begin, attributeName, value, valueCaseSensitive));
        if (startTag == null) {
            return Collections.emptyList();
        }
        ArrayList<StartTag> list = new ArrayList<StartTag>();
        do {
            list.add(startTag);
        } while ((startTag = this.checkEnclosure(this.source.getNextStartTag(startTag.begin + 1, attributeName, value, valueCaseSensitive))) != null);
        return list;
    }

    public List<StartTag> getAllStartTags(String attributeName, Pattern valueRegexPattern) {
        StartTag startTag = this.checkEnclosure(this.source.getNextStartTag(this.begin, attributeName, valueRegexPattern));
        if (startTag == null) {
            return Collections.emptyList();
        }
        ArrayList<StartTag> list = new ArrayList<StartTag>();
        do {
            list.add(startTag);
        } while ((startTag = this.checkEnclosure(this.source.getNextStartTag(startTag.begin + 1, attributeName, valueRegexPattern))) != null);
        return list;
    }

    public List<StartTag> getAllStartTagsByClass(String className) {
        return this.getAllStartTags("class", Segment.getClassPattern(className));
    }

    public List<Element> getChildElements() {
        StartTag childStartTag;
        if (this.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Element> childElements = new ArrayList<Element>();
        int pos = this.begin;
        while ((childStartTag = this.source.getNextStartTag(pos)) != null && childStartTag.begin < this.end) {
            if (childStartTag.getTagType().isServerTag()) {
                pos = childStartTag.end;
                continue;
            }
            Element childElement = childStartTag.getElement();
            childElements.add(childElement);
            childElement.getChildElements();
            pos = childElement.end;
        }
        return childElements;
    }

    public List<Element> getAllElements() {
        return this.getAllElements(this.getAllStartTags());
    }

    public List<Element> getAllElements(String name) {
        return this.getAllElements(this.getAllStartTags(name));
    }

    public List<Element> getAllElements(StartTagType startTagType) {
        if (startTagType == null) {
            throw new IllegalArgumentException("startTagType argument must not be null");
        }
        return this.getAllElements(this.getAllStartTags(startTagType));
    }

    public List<Element> getAllElements(String attributeName, String value, boolean valueCaseSensitive) {
        return this.getAllElements(this.getAllStartTags(attributeName, value, valueCaseSensitive));
    }

    public List<Element> getAllElements(String attributeName, Pattern valueRegexPattern) {
        return this.getAllElements(this.getAllStartTags(attributeName, valueRegexPattern));
    }

    public List<Element> getAllElementsByClass(String className) {
        return this.getAllElements(this.getAllStartTagsByClass(className));
    }

    public List<CharacterReference> getAllCharacterReferences() {
        CharacterReference characterReference = this.getNextCharacterReference(this.begin);
        if (characterReference == null) {
            return Collections.emptyList();
        }
        ArrayList<CharacterReference> list = new ArrayList<CharacterReference>();
        do {
            list.add(characterReference);
        } while ((characterReference = this.getNextCharacterReference(characterReference.end)) != null);
        return list;
    }

    public List<Attribute> getURIAttributes() {
        return URIAttributes.getList(this);
    }

    public List<Segment> getStyleURISegments() {
        return URIAttributes.getStyleURISegments(this);
    }

    public final StartTag getFirstStartTag() {
        return this.checkEnclosure(this.source.getNextStartTag(this.begin));
    }

    public final StartTag getFirstStartTag(StartTagType startTagType) {
        return this.checkEnclosure(this.source.getNextStartTag(this.begin, startTagType));
    }

    public final StartTag getFirstStartTag(String name) {
        return this.checkEnclosure(this.source.getNextStartTag(this.begin, name));
    }

    public final StartTag getFirstStartTag(String attributeName, String value, boolean valueCaseSensitive) {
        return this.checkEnclosure(this.source.getNextStartTag(this.begin, attributeName, value, valueCaseSensitive));
    }

    public final StartTag getFirstStartTag(String attributeName, Pattern valueRegexPattern) {
        return this.checkEnclosure(this.source.getNextStartTag(this.begin, attributeName, valueRegexPattern));
    }

    public final StartTag getFirstStartTagByClass(String className) {
        return this.checkEnclosure(this.source.getNextStartTagByClass(this.begin, className));
    }

    public final Element getFirstElement() {
        StartTag startTag = this.checkEnclosure(StartTag.getNext(this.source, this.begin));
        while (startTag != null) {
            Element element = startTag.getElement();
            if (element.end <= this.end) {
                return element;
            }
            startTag = this.checkEnclosure(startTag.getNextStartTag());
        }
        return null;
    }

    public final Element getFirstElement(String name) {
        if (name == null) {
            return this.getFirstElement();
        }
        boolean isXMLTagName = Tag.isXMLName(name);
        name = name.toLowerCase();
        StartTag startTag = this.checkEnclosure(StartTag.getNext(this.source, this.begin, name, StartTagType.NORMAL, isXMLTagName));
        while (startTag != null) {
            Element element = startTag.getElement();
            if (element.end <= this.end) {
                return element;
            }
            startTag = this.checkEnclosure(StartTag.getNext(this.source, startTag.begin + 1, name, StartTagType.NORMAL, isXMLTagName));
        }
        return null;
    }

    public final Element getFirstElement(String attributeName, String value, boolean valueCaseSensitive) {
        StartTag startTag = this.checkEnclosure(this.source.getNextStartTag(this.begin, attributeName, value, valueCaseSensitive));
        while (startTag != null) {
            Element element = startTag.getElement();
            if (element.end <= this.end) {
                return element;
            }
            startTag = this.checkEnclosure(this.source.getNextStartTag(startTag.begin + 1, attributeName, value, valueCaseSensitive));
        }
        return null;
    }

    public final Element getFirstElement(String attributeName, Pattern valueRegexPattern) {
        StartTag startTag = this.checkEnclosure(this.source.getNextStartTag(this.begin, attributeName, valueRegexPattern));
        while (startTag != null) {
            Element element = startTag.getElement();
            if (element.end <= this.end) {
                return element;
            }
            startTag = this.checkEnclosure(this.source.getNextStartTag(startTag.begin + 1, attributeName, valueRegexPattern));
        }
        return null;
    }

    public final Element getFirstElementByClass(String className) {
        StartTag startTag = this.checkEnclosure(this.source.getNextStartTagByClass(this.begin, className));
        while (startTag != null) {
            Element element = startTag.getElement();
            if (element.end <= this.end) {
                return element;
            }
            startTag = this.checkEnclosure(this.source.getNextStartTagByClass(startTag.begin + 1, className));
        }
        return null;
    }

    public List<FormControl> getFormControls() {
        return FormControl.getAll(this);
    }

    public FormFields getFormFields() {
        return new FormFields(this.getFormControls());
    }

    public Attributes parseAttributes() {
        return this.source.parseAttributes(this.begin, this.end);
    }

    public void ignoreWhenParsing() {
        this.source.ignoreWhenParsing(this.begin, this.end);
    }

    @Override
    public int compareTo(Segment segment) {
        if (this == segment) {
            return 0;
        }
        if (this.begin < segment.begin) {
            return -1;
        }
        if (this.begin > segment.begin) {
            return 1;
        }
        if (this.end < segment.end) {
            return -1;
        }
        if (this.end > segment.end) {
            return 1;
        }
        return 0;
    }

    public final boolean isWhiteSpace() {
        int i = this.begin;
        while (i < this.end) {
            if (!Segment.isWhiteSpace(this.source.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getMaxDepthIndicator() {
        int maxDepth = 0;
        int depth = 0;
        for (Tag tag : this.getAllTags()) {
            if (tag instanceof StartTag) {
                StartTag startTag = (StartTag)tag;
                if (startTag.getStartTagType().getCorrespondingEndTagType() == null || HTMLElements.getEndTagForbiddenElementNames().contains(startTag.getName()) || startTag.isEmptyElementTag() || ++depth <= maxDepth) continue;
                ++maxDepth;
                continue;
            }
            --depth;
        }
        return maxDepth;
    }

    public static final boolean isWhiteSpace(char ch) {
        char[] cArray = WHITESPACE;
        int n = WHITESPACE.length;
        int n2 = 0;
        while (n2 < n) {
            char whiteSpaceChar = cArray[n2];
            if (ch == whiteSpaceChar) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public RowColumnVector getRowColumnVector() {
        return this.source.getRowColumnVector(this.begin);
    }

    public String getDebugInfo() {
        StringBuilder sb = new StringBuilder(50);
        sb.append('(');
        this.source.getRowColumnVector(this.begin).appendTo(sb);
        sb.append('-');
        this.source.getRowColumnVector(this.end).appendTo(sb);
        sb.append(')');
        return sb.toString();
    }

    @Override
    public char charAt(int index) {
        return this.source.charAt(this.begin + index);
    }

    @Override
    public CharSequence subSequence(int beginIndex, int endIndex) {
        return this.source.subSequence(this.begin + beginIndex, this.begin + endIndex);
    }

    static final StringBuilder appendCollapseWhiteSpace(StringBuilder sb, CharSequence text) {
        int textLength = text.length();
        int i = 0;
        boolean lastWasWhiteSpace = false;
        while (true) {
            if (i >= textLength) {
                return sb;
            }
            if (!Segment.isWhiteSpace(text.charAt(i))) break;
            ++i;
        }
        do {
            char ch;
            if (Segment.isWhiteSpace(ch = text.charAt(i++))) {
                lastWasWhiteSpace = true;
                continue;
            }
            if (lastWasWhiteSpace) {
                sb.append(' ');
                lastWasWhiteSpace = false;
            }
            sb.append(ch);
        } while (i < textLength);
        return sb;
    }

    static final Pattern getClassPattern(String className) {
        return Pattern.compile(".*(\\s|^)" + className + "(\\s|$).*", 32);
    }

    private List<Element> getAllElements(List<StartTag> startTags) {
        if (startTags.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Element> elements = new ArrayList<Element>(startTags.size());
        for (StartTag startTag : startTags) {
            Element element = startTag.getElement();
            if (element.end > this.end) continue;
            elements.add(element);
        }
        return elements;
    }

    private StartTag checkEnclosure(StartTag startTag) {
        if (startTag == null || startTag.end > this.end) {
            return null;
        }
        return startTag;
    }

    private Tag checkTagEnclosure(Tag tag) {
        if (tag == null || tag.end > this.end) {
            return null;
        }
        return tag;
    }

    private CharacterReference getNextCharacterReference(int pos) {
        CharacterReference characterReference = this.source.getNextCharacterReference(pos);
        if (characterReference == null || characterReference.end > this.end) {
            return null;
        }
        return characterReference;
    }
}

