/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.net.URL;
import java.util.List;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTagType;
import org.junit.Assert;
import org.junit.Test;

public class SegmentTest {
    private static final String sourceUrlString = "file:test/data/SegmentTest.html";

    @Test
    public void test() throws Exception {
        Source source = new Source(new URL(sourceUrlString));
        Assert.assertEquals((Object)"<HTML>", (Object)source.getFirstStartTag().toString());
        Assert.assertEquals((Object)"SegmentTest", (Object)source.getFirstElement("title").getContent().toString());
        Assert.assertEquals((Object)"document keywords", (Object)source.getFirstStartTag("name", "keywords", false).getAttributeValue("content"));
        Assert.assertEquals((Object)"<!--<p>commented p</p>-->", (Object)source.getFirstStartTag(StartTagType.COMMENT).toString());
        Element outerDiv = source.getElementById("OuterDiv");
        List<Element> elements = outerDiv.getAllElements();
        Assert.assertEquals((long)4L, (long)elements.size());
        Assert.assertEquals((Object)StartTagType.COMMENT, (Object)elements.get(2).getStartTag().getTagType());
        Assert.assertEquals((long)1L, (long)outerDiv.getAllElements(StartTagType.COMMENT).size());
        Assert.assertEquals((long)2L, (long)outerDiv.getAllElements("p").size());
        Segment testSegment = new Segment(source, outerDiv.getBegin(), source.getElementById("p2").getStartTag().getEnd() + 1);
        Assert.assertEquals((long)4L, (long)testSegment.getAllStartTags().size());
        Assert.assertEquals((long)2L, (long)testSegment.getAllElements().size());
        Assert.assertNull((Object)source.getFirstStartTag(StartTagType.COMMENT).getFirstStartTag("p"));
        Assert.assertNull((Object)testSegment.getFirstElement("id", "p2", true));
        Assert.assertEquals((long)0L, (long)source.getAllElementsByClass("de").size());
        List<Element> defElements = source.getAllElementsByClass("def");
        Assert.assertEquals((long)4L, (long)defElements.size());
        Assert.assertEquals((Object)"p4", (Object)defElements.get(0).getContent().toString());
        Assert.assertEquals((Object)"p5", (Object)defElements.get(1).getContent().toString());
        Assert.assertEquals((Object)"p6", (Object)defElements.get(2).getContent().toString());
        Assert.assertEquals((Object)"p7", (Object)defElements.get(3).getContent().toString());
    }
}

