/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import net.htmlparser.jericho.CharStreamSource;
import net.htmlparser.jericho.CharStreamSourceUtil;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.EndTag;
import net.htmlparser.jericho.HTMLElements;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.Tag;

public final class SourceFormatter
implements CharStreamSource {
    private final Segment segment;
    private String indentString = "\t";
    private boolean tidyTags = false;
    private boolean collapseWhiteSpace = false;
    private boolean removeLineBreaks = false;
    private boolean indentAllElements = false;
    private String newLine = null;

    public SourceFormatter(Segment segment) {
        this.segment = segment;
    }

    @Override
    public void writeTo(Writer writer) throws IOException {
        this.appendTo(writer);
        writer.flush();
    }

    @Override
    public void appendTo(Appendable appendable) throws IOException {
        new Processor(this.segment, this.getIndentString(), this.getTidyTags(), this.getCollapseWhiteSpace(), this.getRemoveLineBreaks(), this.getIndentAllElements(), this.getIndentAllElements(), this.getNewLine()).appendTo(appendable);
    }

    @Override
    public long getEstimatedMaximumOutputLength() {
        return this.segment.length() * 2;
    }

    @Override
    public String toString() {
        return CharStreamSourceUtil.toString(this);
    }

    public SourceFormatter setIndentString(String indentString) {
        if (indentString == null) {
            throw new IllegalArgumentException("indentString property must not be null");
        }
        this.indentString = indentString;
        return this;
    }

    public String getIndentString() {
        return this.indentString;
    }

    public SourceFormatter setTidyTags(boolean tidyTags) {
        this.tidyTags = tidyTags;
        return this;
    }

    public boolean getTidyTags() {
        return this.tidyTags;
    }

    public SourceFormatter setCollapseWhiteSpace(boolean collapseWhiteSpace) {
        this.collapseWhiteSpace = collapseWhiteSpace;
        return this;
    }

    public boolean getCollapseWhiteSpace() {
        return this.collapseWhiteSpace;
    }

    SourceFormatter setRemoveLineBreaks(boolean removeLineBreaks) {
        this.removeLineBreaks = removeLineBreaks;
        return this;
    }

    boolean getRemoveLineBreaks() {
        return this.removeLineBreaks;
    }

    public SourceFormatter setIndentAllElements(boolean indentAllElements) {
        this.indentAllElements = indentAllElements;
        return this;
    }

    public boolean getIndentAllElements() {
        return this.indentAllElements;
    }

    public SourceFormatter setNewLine(String newLine) {
        this.newLine = newLine;
        return this;
    }

    public String getNewLine() {
        if (this.newLine == null) {
            this.newLine = this.segment.source.getBestGuessNewLine();
        }
        return this.newLine;
    }

    private static final class Processor {
        private final Segment segment;
        private final CharSequence sourceText;
        private final String indentString;
        private final boolean tidyTags;
        private final boolean collapseWhiteSpace;
        private final boolean removeLineBreaks;
        private final boolean indentAllElements;
        private final boolean indentScriptElements;
        private final String newLine;
        private Appendable appendable;
        private Tag nextTag;
        private int index;

        public Processor(Segment segment, String indentString, boolean tidyTags, boolean collapseWhiteSpace, boolean removeLineBreaks, boolean indentAllElements, boolean indentScriptElements, String newLine) {
            this.segment = segment;
            this.sourceText = segment.source.toString();
            this.indentString = indentString;
            this.tidyTags = tidyTags;
            this.collapseWhiteSpace = collapseWhiteSpace || removeLineBreaks;
            this.removeLineBreaks = removeLineBreaks;
            this.indentAllElements = indentAllElements;
            this.indentScriptElements = indentScriptElements;
            this.newLine = newLine;
        }

        public void appendTo(Appendable appendable) throws IOException {
            this.appendable = appendable;
            if (this.segment instanceof Source) {
                ((Source)this.segment).fullSequentialParse();
            }
            this.nextTag = this.segment.source.getNextTag(this.segment.begin);
            this.index = this.segment.begin;
            this.appendContent(this.segment.end, this.segment.getChildElements(), 0);
        }

        private void appendContent(int end, List<Element> childElements, int depth) throws IOException {
            assert (this.index <= end);
            for (Element element : childElements) {
                int elementBegin = element.begin;
                if (elementBegin >= end) break;
                if (this.indentAllElements) {
                    this.appendText(elementBegin, depth);
                    this.appendElement(element, depth, end, false, false);
                    continue;
                }
                if (this.inlinable(element)) continue;
                this.appendText(elementBegin, depth);
                String elementName = element.getName();
                if (elementName == "pre" || elementName == "textarea") {
                    this.appendElement(element, depth, end, true, true);
                    continue;
                }
                if (elementName == "script") {
                    this.appendElement(element, depth, end, true, false);
                    continue;
                }
                this.appendElement(element, depth, end, false, !this.removeLineBreaks && this.containsOnlyInlineLevelChildElements(element));
            }
            this.appendText(end, depth);
            assert (this.index == end);
        }

        private boolean inlinable(Element element) {
            StartTagType startTagType = element.getStartTag().getStartTagType();
            if (startTagType != StartTagType.NORMAL) {
                return true;
            }
            String elementName = element.getName();
            if (elementName == "script") {
                return !this.indentScriptElements;
            }
            if (this.removeLineBreaks && !HTMLElements.getElementNames().contains(elementName)) {
                return true;
            }
            if (!HTMLElements.getInlineLevelElementNames().contains(elementName)) {
                return false;
            }
            if (elementName == "textarea") {
                return false;
            }
            if (this.removeLineBreaks) {
                return true;
            }
            return this.containsOnlyInlineLevelChildElements(element);
        }

        /*
         * Unable to fully structure code
         */
        private void appendText(int end, int depth) throws IOException {
            if (!Processor.$assertionsDisabled && this.index > end) {
                throw new AssertionError();
            }
            if (this.index != end) ** GOTO lbl7
            return;
lbl-1000:
            // 1 sources

            {
                if (++this.index != end) continue;
                return;
lbl7:
                // 2 sources

                ** while (Segment.isWhiteSpace((char)this.sourceText.charAt((int)this.index)))
            }
lbl8:
            // 1 sources

            this.appendIndent(depth);
            if (this.collapseWhiteSpace) {
                this.appendTextCollapseWhiteSpace(end, depth);
            } else {
                this.appendTextInline(end, depth, false);
            }
            this.appendFormattingNewLine();
            if (!Processor.$assertionsDisabled && this.index != end) {
                throw new AssertionError();
            }
        }

        private void appendElement(Element element, int depth, int end, boolean preformatted, boolean renderContentInline) throws IOException {
            int contentEnd;
            assert (this.index == element.begin);
            assert (this.index < end);
            StartTag startTag = element.getStartTag();
            EndTag endTag = element.getEndTag();
            this.appendIndent(depth);
            this.appendTag(startTag, depth, end);
            if (this.index == end) {
                this.appendFormattingNewLine();
                assert (this.index == Math.min(element.end, end)) : this.index;
                return;
            }
            if (!renderContentInline) {
                this.appendFormattingNewLine();
            }
            if (end < (contentEnd = element.getContentEnd())) {
                contentEnd = end;
            }
            if (this.index < contentEnd) {
                if (preformatted) {
                    if (renderContentInline) {
                        this.appendContentPreformatted(contentEnd, depth);
                    } else {
                        this.appendIndentedScriptContent(contentEnd, depth + 1);
                    }
                } else if (renderContentInline) {
                    if (this.collapseWhiteSpace) {
                        this.appendTextCollapseWhiteSpace(contentEnd, depth);
                    } else if (!this.appendTextInline(contentEnd, depth, true)) {
                        this.appendFormattingNewLine();
                        renderContentInline = false;
                    }
                } else {
                    this.appendContent(contentEnd, element.getChildElements(), depth + 1);
                }
            }
            if (endTag != null && end > endTag.begin) {
                if (!renderContentInline) {
                    this.appendIndent(depth);
                }
                assert (this.index == endTag.begin);
                this.appendTag(endTag, depth, end);
                this.appendFormattingNewLine();
            } else if (renderContentInline) {
                this.appendFormattingNewLine();
            }
            assert (this.index == Math.min(element.end, end)) : this.index;
        }

        private void updateNextTag() {
            while (this.nextTag != null) {
                if (this.nextTag.begin >= this.index) {
                    return;
                }
                this.nextTag = this.nextTag.getNextTag();
            }
        }

        private void appendIndentedScriptContent(int end, int depth) throws IOException {
            assert (this.index < end);
            if (this.removeLineBreaks) {
                this.appendTextRemoveIndentation(end);
                assert (this.index == end);
                return;
            }
            int startOfLinePos = this.getStartOfLinePos(end, false);
            if (this.index == end) {
                return;
            }
            if (startOfLinePos == -1) {
                this.appendIndent(depth);
                this.appendLineKeepWhiteSpace(end, depth);
                this.appendEssentialNewLine();
                if (this.index == end) {
                    return;
                }
                startOfLinePos = this.getStartOfLinePos(end, true);
                if (this.index == end) {
                    return;
                }
            }
            this.appendTextPreserveIndentation(end, depth, this.index - startOfLinePos);
            this.appendEssentialNewLine();
            assert (this.index == end);
        }

        private boolean appendTextPreserveIndentation(int end, int depth) throws IOException {
            assert (this.index < end);
            if (this.removeLineBreaks) {
                return this.appendTextRemoveIndentation(end);
            }
            this.appendLineKeepWhiteSpace(end, depth);
            if (this.index == end) {
                return true;
            }
            int startOfLinePos = this.getStartOfLinePos(end, true);
            if (this.index == end) {
                return true;
            }
            this.appendEssentialNewLine();
            this.appendTextPreserveIndentation(end, depth + 1, this.index - startOfLinePos);
            assert (this.index == end);
            return false;
        }

        private void appendTextPreserveIndentation(int end, int depth, int originalIndentLength) throws IOException {
            assert (this.index < end);
            this.appendIndent(depth);
            this.appendLineKeepWhiteSpace(end, depth);
            while (this.index != end) {
                int x = 0;
                while (x < originalIndentLength) {
                    char ch = this.sourceText.charAt(this.index);
                    if (ch != ' ' && ch != '\t') break;
                    if (++this.index == end) {
                        return;
                    }
                    ++x;
                }
                this.appendEssentialNewLine();
                this.appendIndent(depth);
                this.appendLineKeepWhiteSpace(end, depth);
            }
            assert (this.index == end);
        }

        /*
         * Unable to fully structure code
         */
        private boolean appendTextRemoveIndentation(int end) throws IOException {
            if (!Processor.$assertionsDisabled && this.index >= end) {
                throw new AssertionError();
            }
            this.appendLineKeepWhiteSpace(end, 0);
            if (this.index != end) ** GOTO lbl11
            return true;
lbl-1000:
            // 2 sources

            {
                if ((ch = this.sourceText.charAt(this.index)) == ' ' || ch == '\t') {
                    if (++this.index != end) continue;
                    return false;
                }
                this.appendEssentialNewLine();
                this.appendLineKeepWhiteSpace(end, 0);
lbl11:
                // 2 sources

                if (this.index == end) break;
                ** while (true)
            }
            if (!Processor.$assertionsDisabled && this.index != end) {
                throw new AssertionError();
            }
            return false;
        }

        private int getStartOfLinePos(int end, boolean atStartOfLine) {
            int startOfLinePos;
            int n = startOfLinePos = atStartOfLine ? this.index : -1;
            do {
                char ch;
                if ((ch = this.sourceText.charAt(this.index)) == '\n' || ch == '\r') {
                    startOfLinePos = this.index + 1;
                    continue;
                }
                if (ch != ' ' && ch != '\t') break;
            } while (++this.index != end);
            return startOfLinePos;
        }

        private void appendSpecifiedTextInline(CharSequence text, int depth) throws IOException {
            int textLength = text.length();
            int i = this.appendSpecifiedLine(text, 0);
            if (i < textLength) {
                int subsequentLineDepth = depth + 1;
                while (true) {
                    if (Segment.isWhiteSpace(text.charAt(i))) {
                        if (++i < textLength) continue;
                        return;
                    }
                    this.appendEssentialNewLine();
                    this.appendIndent(subsequentLineDepth);
                    if ((i = this.appendSpecifiedLine(text, i)) >= textLength) break;
                }
            }
        }

        private int appendSpecifiedLine(CharSequence text, int i) throws IOException {
            int textLength = text.length();
            do {
                int nexti;
                char ch;
                if ((ch = text.charAt(i)) == '\r' && (nexti = i + 1) < textLength && text.charAt(nexti) == '\n') {
                    return i + 2;
                }
                if (ch == '\n') {
                    return i + 1;
                }
                this.appendable.append(ch);
            } while (++i < textLength);
            return i;
        }

        private boolean appendTextInline(int end, int depth, boolean increaseIndentAfterFirstLineBreak) throws IOException {
            assert (this.index < end);
            this.appendLineKeepWhiteSpace(end, depth);
            if (this.index == end) {
                return true;
            }
            int subsequentLineDepth = increaseIndentAfterFirstLineBreak ? depth + 1 : depth;
            while (true) {
                if (Segment.isWhiteSpace(this.sourceText.charAt(this.index))) {
                    if (++this.index != end) continue;
                    return false;
                }
                this.appendEssentialNewLine();
                this.appendIndent(subsequentLineDepth);
                this.appendLineKeepWhiteSpace(end, subsequentLineDepth);
                if (this.index >= end) break;
            }
            assert (this.index == end);
            return false;
        }

        private void appendLineKeepWhiteSpace(int end, int depth) throws IOException {
            assert (this.index < end);
            this.updateNextTag();
            while (true) {
                int nextindex;
                if (this.nextTag != null && this.index == this.nextTag.begin) {
                    this.appendTag(this.nextTag, depth, end);
                    if (this.index != end) continue;
                    return;
                }
                char ch = this.sourceText.charAt(this.index);
                if (ch == '\r' && (nextindex = this.index + 1) < end && this.sourceText.charAt(nextindex) == '\n') {
                    this.index += 2;
                    assert (this.index <= end);
                    return;
                }
                if (ch == '\n') {
                    ++this.index;
                    assert (this.index <= end);
                    return;
                }
                this.appendable.append(ch);
                if (++this.index == end) break;
            }
        }

        /*
         * Unable to fully structure code
         */
        private void appendTextCollapseWhiteSpace(int end, int depth) throws IOException {
            if (!Processor.$assertionsDisabled && this.index >= end) {
                throw new AssertionError();
            }
            lastWasWhiteSpace = false;
            this.updateNextTag();
            ** GOTO lbl24
            {
                if (lastWasWhiteSpace) {
                    this.appendable.append(' ');
                    lastWasWhiteSpace = false;
                }
                this.appendTag(this.nextTag, depth, end);
                if (this.index == end) {
                    return;
                }
                do {
                    if (this.nextTag != null && this.index == this.nextTag.begin) continue block0;
                    if (Segment.isWhiteSpace(ch = this.sourceText.charAt(this.index++))) {
                        lastWasWhiteSpace = true;
                        continue;
                    }
                    if (lastWasWhiteSpace) {
                        this.appendable.append(' ');
                        lastWasWhiteSpace = false;
                    }
                    this.appendable.append(ch);
lbl24:
                    // 3 sources

                } while (this.index < end);
            }
            if (lastWasWhiteSpace) {
                this.appendable.append(' ');
            }
            if (!Processor.$assertionsDisabled && this.index != end) {
                throw new AssertionError();
            }
        }

        private void appendContentPreformatted(int end, int depth) throws IOException {
            assert (this.index < end);
            this.updateNextTag();
            while (true) {
                if (this.nextTag != null && this.index == this.nextTag.begin) {
                    this.appendTag(this.nextTag, depth, end);
                    if (this.index != end) continue;
                    return;
                }
                this.appendable.append(this.sourceText.charAt(this.index));
                if (++this.index >= end) break;
            }
            assert (this.index == end);
        }

        private void appendTag(Tag tag, int depth, int end) throws IOException {
            int tagEnd;
            assert (this.index == tag.begin);
            assert (this.index < end);
            this.nextTag = tag.getNextTag();
            int n = tagEnd = tag.end < end ? tag.end : end;
            assert (this.index < tagEnd);
            if (tag.getTagType() == StartTagType.COMMENT || tag.getTagType() == StartTagType.CDATA_SECTION || tag.getTagType().isServerTag()) {
                this.appendTextPreserveIndentation(tagEnd, depth);
            } else if (this.tidyTags) {
                String tidyTag = tag.tidy();
                if (tag instanceof StartTag && ((StartTag)tag).getAttributes() != null) {
                    this.appendable.append(tidyTag);
                } else {
                    this.appendSpecifiedTextInline(tidyTag, depth);
                }
                this.index = tagEnd;
            } else {
                this.appendTextInline(tagEnd, depth, true);
            }
            if (end <= tag.end || !(tag instanceof StartTag)) {
                assert (this.index <= end);
                return;
            }
            if (tag.name == "script" && !this.indentScriptElements || tag.getTagType().isServerTag()) {
                Element element = tag.getElement();
                EndTag endTag = element.getEndTag();
                if (endTag == null) {
                    assert (this.index <= end);
                    return;
                }
                int contentEnd = end < endTag.begin ? end : endTag.begin;
                boolean singleLineContent = true;
                if (this.index != contentEnd) {
                    boolean elementContainsMarkup = false;
                    singleLineContent = this.appendTextPreserveIndentation(contentEnd, depth);
                }
                if (endTag.begin >= end) {
                    assert (this.index <= end);
                    return;
                }
                if (!singleLineContent) {
                    this.appendEssentialNewLine();
                    this.appendIndent(depth);
                }
                assert (this.index == endTag.begin);
                this.appendTag(endTag, depth, end);
            }
            assert (this.index <= end);
        }

        private void appendIndent(int depth) throws IOException {
            if (!this.removeLineBreaks) {
                int x = 0;
                while (x < depth) {
                    this.appendable.append(this.indentString);
                    ++x;
                }
            }
        }

        private void appendFormattingNewLine() throws IOException {
            if (!this.removeLineBreaks) {
                this.appendable.append(this.newLine);
            }
        }

        private void appendEssentialNewLine() throws IOException {
            this.appendable.append(this.newLine);
        }

        private boolean containsOnlyInlineLevelChildElements(Element element) {
            List<Element> childElements = element.getChildElements();
            if (childElements.isEmpty()) {
                return true;
            }
            for (Element childElement : childElements) {
                String elementName = childElement.getName();
                if (elementName == "script" || !HTMLElements.getInlineLevelElementNames().contains(elementName)) {
                    return false;
                }
                if (this.containsOnlyInlineLevelChildElements(childElement)) continue;
                return false;
            }
            return true;
        }
    }
}

