/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.BufferOverflowException;
import java.nio.CharBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.htmlparser.jericho.CharacterReference;
import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.EncodingDetector;
import net.htmlparser.jericho.Logger;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.StreamedParseText;
import net.htmlparser.jericho.StreamedText;
import net.htmlparser.jericho.Tag;
import net.htmlparser.jericho.TagType;

public final class StreamedSource
implements Iterable<Segment>,
Closeable {
    private final StreamedText streamedText;
    private final StreamedParseText streamedParseText;
    private final Source source;
    private final Closeable closeable;
    private final boolean automaticClose;
    private boolean coalescing = false;
    private boolean handleTags = true;
    private Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings = Config.CurrentCompatibilityMode.getUnterminatedCharacterReferenceSettings(false);
    private boolean isInitialised = false;
    private Segment currentSegment = null;
    private Segment nextParsedSegment = START_SEGMENT;
    private boolean isXML;
    private static final boolean assumeNoNestedTags = false;
    private static final Segment START_SEGMENT = new Segment(-1, -1);

    private StreamedSource(Reader reader, boolean automaticClose, String encoding, String encodingSpecificationInfo, String preliminaryEncodingInfo) throws IOException {
        this.closeable = reader;
        this.automaticClose = automaticClose;
        this.streamedText = new StreamedText(reader);
        this.streamedParseText = new StreamedParseText(this.streamedText);
        this.source = new Source(this.streamedText, this.streamedParseText, encoding, encodingSpecificationInfo, preliminaryEncodingInfo);
    }

    private StreamedSource(EncodingDetector encodingDetector, boolean automaticClose) throws IOException {
        this(encodingDetector.openReader(), automaticClose, encodingDetector.getEncoding(), encodingDetector.getEncodingSpecificationInfo(), String.valueOf(encodingDetector.getPreliminaryEncoding()) + ": " + encodingDetector.getPreliminaryEncodingSpecificationInfo());
    }

    public StreamedSource(Reader reader) throws IOException {
        this(reader, false, reader instanceof InputStreamReader ? ((InputStreamReader)reader).getEncoding() : null, reader instanceof InputStreamReader ? "InputStreamReader.getEncoding() of constructor argument" : null, null);
    }

    public StreamedSource(InputStream inputStream) throws IOException {
        this(new EncodingDetector(inputStream), false);
    }

    public StreamedSource(URL url) throws IOException {
        this(new EncodingDetector(url.openConnection()), true);
    }

    public StreamedSource(URLConnection urlConnection) throws IOException {
        this(new EncodingDetector(urlConnection), true);
    }

    public StreamedSource(CharSequence text) {
        this.closeable = null;
        this.automaticClose = false;
        this.streamedText = new StreamedText(text);
        this.streamedParseText = new StreamedParseText(this.streamedText);
        this.source = new Source(text, this.streamedParseText, null, "Document specified encoding can not be determined automatically from a streamed source", null);
    }

    public StreamedSource setBuffer(char[] buffer) {
        if (this.isInitialised) {
            throw new IllegalStateException("setBuffer() can only be called before iterator() is called");
        }
        this.streamedText.setBuffer(buffer);
        return this;
    }

    public StreamedSource setCoalescing(boolean coalescing) {
        if (this.isInitialised) {
            throw new IllegalStateException("setPlainTextWriter() can only be called before iterator() is called");
        }
        this.coalescing = coalescing;
        return this;
    }

    @Override
    public void close() throws IOException {
        if (this.closeable != null) {
            this.closeable.close();
        }
    }

    public String getEncoding() {
        return this.source.getEncoding();
    }

    public String getEncodingSpecificationInfo() {
        return this.source.getEncodingSpecificationInfo();
    }

    public String getPreliminaryEncodingInfo() {
        return this.source.getPreliminaryEncodingInfo();
    }

    @Override
    public Iterator<Segment> iterator() {
        if (this.isInitialised) {
            throw new IllegalStateException("iterator() can only be called once");
        }
        this.isInitialised = true;
        return new StreamedSourceIterator();
    }

    public Segment getCurrentSegment() {
        return this.currentSegment;
    }

    public CharBuffer getCurrentSegmentCharBuffer() {
        return this.streamedText.getCharBuffer(this.currentSegment.getBegin(), this.currentSegment.end);
    }

    public boolean isXML() {
        if (!this.isInitialised) {
            throw new IllegalStateException("isXML() method only available after iterator() has been called");
        }
        return this.isXML;
    }

    public void setLogger(Logger logger) {
        this.source.setLogger(logger);
    }

    public Logger getLogger() {
        return this.source.getLogger();
    }

    public int getBufferSize() {
        return this.streamedText.getBuffer().length;
    }

    public String toString() {
        return super.toString();
    }

    protected void finalize() {
        this.automaticClose();
    }

    StreamedSource setHandleTags(boolean handleTags) {
        this.handleTags = handleTags;
        return this;
    }

    StreamedSource setUnterminatedCharacterReferenceSettings(Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings) {
        this.unterminatedCharacterReferenceSettings = unterminatedCharacterReferenceSettings;
        return this;
    }

    StreamedSource setSearchBegin(int begin) {
        if (this.isInitialised) {
            throw new IllegalStateException("setSearchBegin() can only be called before iterator() is called");
        }
        int segmentEnd = begin - 1;
        this.nextParsedSegment = new Segment(segmentEnd, segmentEnd);
        return this;
    }

    private void automaticClose() {
        if (this.automaticClose) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static boolean isXML(Segment firstNonTextSegment) {
        if (firstNonTextSegment == null || !(firstNonTextSegment instanceof Tag)) {
            return false;
        }
        Tag tag = (Tag)firstNonTextSegment;
        if (tag.getTagType() == StartTagType.XML_DECLARATION) {
            return true;
        }
        return tag.source.getParseText().indexOf("xhtml", tag.begin, tag.end) != -1;
    }

    private class StreamedSourceIterator
    implements Iterator<Segment> {
        private final boolean coalescing;
        private final boolean handleTags;
        private Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings;
        private Segment nextSegment;
        private int plainTextSegmentBegin = 0;
        private final char[] charByRef = new char[1];

        public StreamedSourceIterator() {
            this.coalescing = StreamedSource.this.coalescing;
            this.handleTags = StreamedSource.this.handleTags;
            this.unterminatedCharacterReferenceSettings = StreamedSource.this.unterminatedCharacterReferenceSettings;
            this.loadNextParsedSegment();
            StreamedSource.this.isXML = StreamedSource.isXML(StreamedSource.this.nextParsedSegment);
        }

        @Override
        public boolean hasNext() {
            if (this.nextSegment == Tag.NOT_CACHED) {
                this.loadNextParsedSegment();
            }
            return this.nextSegment != null;
        }

        @Override
        public Segment next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Segment result = this.nextSegment;
            this.nextSegment = result == StreamedSource.this.nextParsedSegment ? Tag.NOT_CACHED : StreamedSource.this.nextParsedSegment;
            StreamedSource.this.streamedText.setMinRequiredBufferBegin(result.end);
            StreamedSource.this.currentSegment = result;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private final void loadNextParsedSegment() {
            StreamedSource.this.nextParsedSegment = this.findNextParsedSegment();
            int plainTextSegmentEnd = StreamedSource.this.nextParsedSegment != null ? ((StreamedSource)StreamedSource.this).nextParsedSegment.begin : StreamedSource.this.streamedText.length();
            Segment segment = this.nextSegment = this.plainTextSegmentBegin < plainTextSegmentEnd ? new Segment(StreamedSource.this.source, this.plainTextSegmentBegin, plainTextSegmentEnd) : StreamedSource.this.nextParsedSegment;
            if (StreamedSource.this.nextParsedSegment != null && this.plainTextSegmentBegin < ((StreamedSource)StreamedSource.this).nextParsedSegment.end) {
                this.plainTextSegmentBegin = ((StreamedSource)StreamedSource.this).nextParsedSegment.end;
            }
        }

        private final Segment findNextParsedSegment() {
            try {
                int i = StreamedSource.this.nextParsedSegment instanceof StartTag && ((StartTag)StreamedSource.this.nextParsedSegment).getTagType() == StartTagType.SERVER_COMMON_COMMENT ? StreamedSource.this.nextParsedSegment.getEnd() : StreamedSource.this.nextParsedSegment.getBegin() + 1;
                int searchEnd = this.coalescing ? StreamedSource.this.streamedText.getEnd() : StreamedSource.this.streamedText.getBufferOverflowPosition();
                while (i < searchEnd) {
                    Tag tag;
                    char ch = StreamedSource.this.streamedText.charAt(i);
                    if (ch == '&') {
                        CharacterReference characterReference;
                        if (i >= ((StreamedSource)StreamedSource.this).source.fullSequentialParseData[0] && (characterReference = CharacterReference.construct(StreamedSource.this.source, i, this.unterminatedCharacterReferenceSettings)) != null) {
                            return characterReference;
                        }
                    } else if (this.handleTags && ch == '<' && (tag = TagType.getTagAt(StreamedSource.this.source, i, false, false)) != null && !tag.isUnregistered()) {
                        TagType tagType = tag.getTagType();
                        if (tag.end > ((StreamedSource)StreamedSource.this).source.fullSequentialParseData[0] && tagType != StartTagType.DOCTYPE_DECLARATION) {
                            ((StreamedSource)StreamedSource.this).source.fullSequentialParseData[0] = tagType == StartTagType.NORMAL && tag.name == "script" && !((StartTag)tag).isEmptyElementTag() ? Integer.MAX_VALUE : tag.end;
                        }
                        return tag;
                    }
                    ++i;
                }
                if (i < StreamedSource.this.streamedText.getEnd()) {
                    return new Segment(StreamedSource.this.source, this.plainTextSegmentBegin, i);
                }
            }
            catch (BufferOverflowException ex) {
                StreamedSource.this.automaticClose();
                throw ex;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            StreamedSource.this.automaticClose();
            return null;
        }
    }
}

