/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.StringReader;
import java.nio.BufferOverflowException;
import java.nio.CharBuffer;
import net.htmlparser.jericho.StreamedText;
import org.junit.Assert;
import org.junit.Test;

public class StreamedTextTest {
    private static final String text = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

    @Test
    public void testFixedBuffer() {
        StringReader reader = new StringReader(text);
        char[] buffer = new char[10];
        StreamedText streamedText = new StreamedText(reader, buffer);
        try {
            streamedText.length();
            Assert.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException ex) {
            Assert.assertEquals((Object)"Length of streamed text cannot be determined until end of file has been reached", (Object)ex.getMessage());
        }
        Assert.assertEquals((Object)"", (Object)streamedText.getCurrentBufferContent());
        Assert.assertEquals((long)67L, (long)streamedText.charAt(2));
        Assert.assertEquals((Object)"ABCDEFGHIJ", (Object)streamedText.getCurrentBufferContent());
        Assert.assertEquals((long)66L, (long)streamedText.charAt(1));
        Assert.assertEquals((long)65L, (long)streamedText.charAt(0));
        Assert.assertEquals((long)74L, (long)streamedText.charAt(9));
        try {
            streamedText.charAt(10);
            Assert.fail((String)"Should throw BufferOverflowException");
        }
        catch (BufferOverflowException ex) {
            // empty catch block
        }
        streamedText.setMinRequiredBufferBegin(8);
        streamedText.setMinRequiredBufferBegin(5);
        Assert.assertEquals((long)65L, (long)streamedText.charAt(0));
        Assert.assertEquals((long)74L, (long)streamedText.charAt(9));
        Assert.assertEquals((Object)"ABCDEFGHIJ", (Object)streamedText.getCurrentBufferContent());
        Assert.assertEquals((long)75L, (long)streamedText.charAt(10));
        Assert.assertEquals((Object)"FGHIJKLMNO", (Object)streamedText.getCurrentBufferContent());
        Assert.assertEquals((long)70L, (long)streamedText.charAt(5));
        try {
            streamedText.charAt(4);
            Assert.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException ex) {
            Assert.assertEquals((Object)"StreamedText position 4 has been discarded", (Object)ex.getMessage());
        }
        Assert.assertEquals((long)79L, (long)streamedText.charAt(14));
        try {
            streamedText.charAt(15);
            Assert.fail((String)"Should throw BufferOverflowException");
        }
        catch (BufferOverflowException ex) {
            // empty catch block
        }
        Assert.assertEquals((Object)"IJKL", (Object)streamedText.subSequence(8, 12).toString());
        CharBuffer charBuffer = streamedText.getCharBuffer(8, 12);
        char[] charBufferArray = charBuffer.array();
        Assert.assertEquals((Object)"IJKL", (Object)new String(charBufferArray, charBuffer.position(), charBuffer.length()));
        Assert.assertEquals((Object)"FGHIJKLMNO", (Object)streamedText.substring(5, 15));
        try {
            streamedText.setMinRequiredBufferBegin(3);
            Assert.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"Cannot set minimum required buffer begin to already discarded position 3", (Object)ex.getMessage());
        }
        streamedText.setMinRequiredBufferBegin(20);
        Assert.assertEquals((Object)"FGHIJKLMNO", (Object)streamedText.getCurrentBufferContent());
        Assert.assertEquals((long)79L, (long)streamedText.charAt(14));
        try {
            streamedText.charAt(16);
            Assert.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException ex) {
            Assert.assertEquals((Object)"StreamedText position 16 has been discarded", (Object)ex.getMessage());
        }
        Assert.assertEquals((Object)"", (Object)streamedText.getCurrentBufferContent());
        Assert.assertEquals((long)85L, (long)streamedText.charAt(20));
        Assert.assertEquals((Object)"UVWXYZ0123", (Object)streamedText.getCurrentBufferContent());
        streamedText.setMinRequiredBufferBegin(30);
        try {
            streamedText.length();
            Assert.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((long)52L, (long)streamedText.charAt(30));
        Assert.assertEquals((Object)"456789", (Object)streamedText.getCurrentBufferContent());
        Assert.assertEquals((long)57L, (long)streamedText.charAt(35));
        try {
            streamedText.length();
            Assert.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            streamedText.charAt(36);
            Assert.fail((String)"Should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertEquals((long)36L, (long)streamedText.length());
    }

    @Test
    public void testExpandableBuffer() {
        StringReader reader = new StringReader(text);
        int originalInitialExpandableBufferSize = StreamedText.INITIAL_EXPANDABLE_BUFFER_SIZE;
        StreamedText.INITIAL_EXPANDABLE_BUFFER_SIZE = 2;
        StreamedText streamedText = new StreamedText(reader);
        StreamedText.INITIAL_EXPANDABLE_BUFFER_SIZE = originalInitialExpandableBufferSize;
        Assert.assertEquals((long)2L, (long)streamedText.getBuffer().length);
        Assert.assertEquals((long)66L, (long)streamedText.charAt(1));
        Assert.assertEquals((long)2L, (long)streamedText.getBuffer().length);
        Assert.assertEquals((Object)"AB", (Object)streamedText.getCurrentBufferContent());
        Assert.assertEquals((long)69L, (long)streamedText.charAt(4));
        Assert.assertEquals((long)5L, (long)streamedText.getBuffer().length);
        Assert.assertEquals((Object)"ABCDE", (Object)streamedText.getCurrentBufferContent());
        Assert.assertEquals((long)66L, (long)streamedText.charAt(1));
        Assert.assertEquals((long)65L, (long)streamedText.charAt(0));
        Assert.assertEquals((long)70L, (long)streamedText.charAt(5));
        Assert.assertEquals((long)10L, (long)streamedText.getBuffer().length);
        Assert.assertEquals((Object)"ABCDEFGHIJ", (Object)streamedText.getCurrentBufferContent());
        streamedText.setMinRequiredBufferBegin(8);
        Assert.assertEquals((long)65L, (long)streamedText.charAt(0));
        Assert.assertEquals((long)77L, (long)streamedText.charAt(12));
        Assert.assertEquals((Object)"IJKLMNOPQR", (Object)streamedText.getCurrentBufferContent());
        streamedText.setMinRequiredBufferBegin(20);
        Assert.assertEquals((long)10L, (long)streamedText.getBuffer().length);
        Assert.assertEquals((long)53L, (long)streamedText.charAt(31));
        Assert.assertEquals((long)20L, (long)streamedText.getBuffer().length);
        Assert.assertEquals((Object)"UVWXYZ0123456789", (Object)streamedText.getCurrentBufferContent());
        Assert.assertEquals((long)57L, (long)streamedText.charAt(35));
        try {
            streamedText.length();
            Assert.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            streamedText.charAt(36);
            Assert.fail((String)"Should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertEquals((long)36L, (long)streamedText.length());
    }

    @Test
    public void testEndOfFileFountWhileSkipping() {
        StringReader reader = new StringReader(text);
        char[] buffer = new char[10];
        StreamedText streamedText = new StreamedText(reader, buffer);
        streamedText.setMinRequiredBufferBegin(40);
        try {
            streamedText.length();
            Assert.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            streamedText.charAt(40);
            Assert.fail((String)"Should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertEquals((long)36L, (long)streamedText.length());
    }

    @Test
    public void testCharBuffer() {
        char[] charArray = text.toCharArray();
        CharBuffer charBuffer = CharBuffer.wrap(charArray, 0, 26);
        StreamedText streamedText = new StreamedText(charBuffer);
        Assert.assertEquals((long)26L, (long)streamedText.length());
        Assert.assertEquals((long)36L, (long)streamedText.getBuffer().length);
        Assert.assertEquals((Object)"ABCDEFGHIJKLMNOPQRSTUVWXYZ", (Object)streamedText.getCurrentBufferContent());
        Assert.assertEquals((long)65L, (long)streamedText.charAt(0));
        Assert.assertEquals((long)90L, (long)streamedText.charAt(25));
        streamedText.setMinRequiredBufferBegin(20);
        Assert.assertEquals((long)65L, (long)streamedText.charAt(0));
        try {
            streamedText.charAt(26);
            Assert.fail((String)"Should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }
}

