/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.EndTagType;
import net.htmlparser.jericho.ParseText;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.TagType;

final class TagTypeRegister {
    private TagTypeRegister parent = null;
    private char ch = '\u0000';
    private TagTypeRegister[] children = null;
    private TagType[] tagTypes = null;
    private static final char NULL_CHAR = '\u0000';
    private static final TagType[] DEFAULT_TAG_TYPES = new TagType[]{StartTagType.UNREGISTERED, StartTagType.NORMAL, StartTagType.COMMENT, StartTagType.MARKUP_DECLARATION, StartTagType.DOCTYPE_DECLARATION, StartTagType.CDATA_SECTION, StartTagType.XML_PROCESSING_INSTRUCTION, StartTagType.XML_DECLARATION, StartTagType.SERVER_COMMON, StartTagType.SERVER_COMMON_ESCAPED, StartTagType.SERVER_COMMON_COMMENT, EndTagType.UNREGISTERED, EndTagType.NORMAL};
    private static TagTypeRegister root = new TagTypeRegister();

    static {
        TagTypeRegister.add(DEFAULT_TAG_TYPES);
    }

    private TagTypeRegister() {
    }

    private static synchronized void add(TagType[] tagTypes) {
        int i = 0;
        while (i < tagTypes.length) {
            TagTypeRegister.add(tagTypes[i]);
            ++i;
        }
    }

    public static synchronized void add(TagType tagType) {
        TagTypeRegister cursor = root;
        String startDelimiter = tagType.getStartDelimiter();
        int i = 0;
        while (i < startDelimiter.length()) {
            char ch = startDelimiter.charAt(i);
            TagTypeRegister child = cursor.getChild(ch);
            if (child == null) {
                child = new TagTypeRegister();
                child.parent = cursor;
                child.ch = ch;
                cursor.addChild(child);
            }
            cursor = child;
            ++i;
        }
        cursor.addTagType(tagType);
    }

    public static synchronized void remove(TagType tagType) {
        TagTypeRegister cursor = root;
        String startDelimiter = tagType.getStartDelimiter();
        int i = 0;
        while (i < startDelimiter.length()) {
            char ch = startDelimiter.charAt(i);
            TagTypeRegister child = cursor.getChild(ch);
            if (child == null) {
                return;
            }
            cursor = child;
            ++i;
        }
        cursor.removeTagType(tagType);
        while (cursor != root && cursor.tagTypes == null && cursor.children == null) {
            cursor.parent.removeChild(cursor);
            cursor = cursor.parent;
        }
    }

    public static List<TagType> getList() {
        ArrayList<TagType> list = new ArrayList<TagType>();
        root.addTagTypesToList(list);
        return list;
    }

    private void addTagTypesToList(List<TagType> list) {
        if (this.tagTypes != null) {
            int i = this.tagTypes.length - 1;
            while (i >= 0) {
                list.add(this.tagTypes[i]);
                --i;
            }
        }
        if (this.children != null) {
            TagTypeRegister[] tagTypeRegisterArray = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                TagTypeRegister tagTypeRegister = tagTypeRegisterArray[n2];
                tagTypeRegister.addTagTypesToList(list);
                ++n2;
            }
        }
    }

    public static final String getDebugInfo() {
        return root.appendDebugInfo(new StringBuilder(), 0).toString();
    }

    public String toString() {
        return this.appendDebugInfo(new StringBuilder(), 0).toString();
    }

    private StringBuilder appendDebugInfo(StringBuilder sb, int level) {
        int n;
        int i = 0;
        while (i < level) {
            sb.append(" ");
            ++i;
        }
        if (this.ch != '\u0000') {
            sb.append(this.ch).append(' ');
        }
        if (this.tagTypes != null) {
            sb.append('(');
            TagType[] tagTypeArray = this.tagTypes;
            n = this.tagTypes.length;
            int n2 = 0;
            while (n2 < n) {
                TagType tagType = tagTypeArray[n2];
                sb.append(tagType.getDescription()).append(", ");
                ++n2;
            }
            sb.setLength(sb.length() - 2);
            sb.append(')');
        }
        sb.append(Config.NewLine);
        if (this.children != null) {
            int childLevel = level + 1;
            TagTypeRegister[] tagTypeRegisterArray = this.children;
            int n3 = this.children.length;
            n = 0;
            while (n < n3) {
                TagTypeRegister tagTypeRegister = tagTypeRegisterArray[n];
                tagTypeRegister.appendDebugInfo(sb, childLevel);
                ++n;
            }
        }
        return sb;
    }

    private TagTypeRegister getChild(char ch) {
        if (this.children == null) {
            return null;
        }
        if (this.children.length == 1) {
            return this.children[0].ch == ch ? this.children[0] : null;
        }
        int low = 0;
        int high = this.children.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            char midChar = this.children[mid].ch;
            if (midChar < ch) {
                low = mid + 1;
                continue;
            }
            if (midChar > ch) {
                high = mid - 1;
                continue;
            }
            return this.children[mid];
        }
        return null;
    }

    private void addChild(TagTypeRegister child) {
        if (this.children == null) {
            this.children = new TagTypeRegister[]{child};
        } else {
            TagTypeRegister[] newChildren = new TagTypeRegister[this.children.length + 1];
            int i = 0;
            while (i < this.children.length && this.children[i].ch <= child.ch) {
                newChildren[i] = this.children[i];
                ++i;
            }
            newChildren[i++] = child;
            while (i < newChildren.length) {
                newChildren[i] = this.children[i - 1];
                ++i;
            }
            this.children = newChildren;
        }
    }

    private void removeChild(TagTypeRegister child) {
        if (this.children.length == 1) {
            this.children = null;
            return;
        }
        TagTypeRegister[] newChildren = new TagTypeRegister[this.children.length - 1];
        int offset = 0;
        int i = 0;
        while (i < this.children.length) {
            if (this.children[i] == child) {
                offset = -1;
            } else {
                newChildren[i + offset] = this.children[i];
            }
            ++i;
        }
        this.children = newChildren;
    }

    private int indexOfTagType(TagType tagType) {
        if (this.tagTypes == null) {
            return -1;
        }
        int i = 0;
        while (i < this.tagTypes.length) {
            if (this.tagTypes[i] == tagType) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void addTagType(TagType tagType) {
        int indexOfTagType = this.indexOfTagType(tagType);
        if (indexOfTagType == -1) {
            if (this.tagTypes == null) {
                this.tagTypes = new TagType[]{tagType};
            } else {
                TagType[] newTagTypes = new TagType[this.tagTypes.length + 1];
                newTagTypes[0] = tagType;
                int i = 0;
                while (i < this.tagTypes.length) {
                    newTagTypes[i + 1] = this.tagTypes[i];
                    ++i;
                }
                this.tagTypes = newTagTypes;
            }
        } else {
            int i = indexOfTagType;
            while (i > 0) {
                this.tagTypes[i] = this.tagTypes[i - 1];
                --i;
            }
            this.tagTypes[0] = tagType;
        }
    }

    private void removeTagType(TagType tagType) {
        int indexOfTagType = this.indexOfTagType(tagType);
        if (indexOfTagType == -1) {
            return;
        }
        if (this.tagTypes.length == 1) {
            this.tagTypes = null;
            return;
        }
        TagType[] newTagTypes = new TagType[this.tagTypes.length - 1];
        int i = 0;
        while (i < indexOfTagType) {
            newTagTypes[i] = this.tagTypes[i];
            ++i;
        }
        i = indexOfTagType;
        while (i < newTagTypes.length) {
            newTagTypes[i] = this.tagTypes[i + 1];
            ++i;
        }
        this.tagTypes = newTagTypes;
    }

    static final class ProspectiveTagTypeIterator
    implements Iterator<TagType> {
        private TagTypeRegister cursor;
        private int tagTypeIndex = 0;

        public ProspectiveTagTypeIterator(Source source, int pos) {
            ParseText parseText = source.getParseText();
            this.cursor = root;
            int posIndex = 0;
            try {
                TagTypeRegister child;
                while ((child = this.cursor.getChild(parseText.charAt(pos + posIndex++))) != null) {
                    this.cursor = child;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            while (this.cursor.tagTypes == null) {
                this.cursor = this.cursor.parent;
                if (this.cursor == null) break;
            }
        }

        @Override
        public boolean hasNext() {
            return this.cursor != null;
        }

        @Override
        public TagType next() {
            TagType[] tagTypes = this.cursor.tagTypes;
            TagType nextTagType = tagTypes[this.tagTypeIndex];
            if (++this.tagTypeIndex == tagTypes.length) {
                this.tagTypeIndex = 0;
                do {
                    this.cursor = this.cursor.parent;
                } while (this.cursor != null && this.cursor.tagTypes == null);
            }
            return nextTagType;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

