/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import net.htmlparser.jericho.Config;

public final class Util {
    private static final int BUFFER_SIZE = 2048;
    private static final String CSVNewLine = System.getProperty("line.separator");

    private Util() {
    }

    public static String getString(Reader reader) throws IOException {
        if (reader == null) {
            return "";
        }
        try {
            int charsRead;
            char[] copyBuffer = new char[2048];
            StringBuilder sb = new StringBuilder();
            while ((charsRead = reader.read(copyBuffer, 0, 2048)) != -1) {
                sb.append(copyBuffer, 0, charsRead);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static void outputCSVLine(Writer writer, String[] values) throws IOException {
        int i = 0;
        while (i < values.length) {
            String value = values[i];
            if (value != null) {
                if (value == Config.ColumnValueTrue || value == Config.ColumnValueFalse) {
                    writer.write(value);
                } else {
                    writer.write(34);
                    Util.outputValueEscapeQuotes(writer, value);
                    writer.write(34);
                }
            }
            if (++i == values.length) continue;
            writer.write(44);
        }
        writer.write(CSVNewLine);
    }

    private static void outputValueEscapeQuotes(Writer writer, String text) throws IOException {
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            writer.write(ch);
            if (ch == '\"') {
                writer.write(ch);
            }
            ++i;
        }
    }

    static char[] getConcatenatedCharArray(String string1, String string2) {
        char[] charArray = new char[string1.length() + string2.length()];
        string1.getChars(0, string1.length(), charArray, 0);
        string2.getChars(0, string2.length(), charArray, string1.length());
        return charArray;
    }
}

