# Copyright (C) 1998-2014 by the Free Software Foundation, Inc.
#
# This file is part of mmci.
#
# mmci is free software: you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation, either version 3 of the License, or (at your option)
# any later version.
#
# mmci is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
# more details.
#
# You should have received a copy of the GNU General Public License along with
# mmci.  If not, see <http://www.gnu.org/licenses/>.

import os
import argparse
from mmci.base.command import Command
from mmci.setup import PROJ_PATH


def command_parser():
    """ Parses the sys.args using argparse module.
    Commands that are currently implemented are: create, pull, test and try_
    :return: argparse.Namespace object
    """
    p = argparse.ArgumentParser()
    p.add_argument('--create', help='''creates new project settings (optional)''')
    p.add_argument('--pull', help='''pulls a given project,
                                           use 'all' to pull all''')
    p.add_argument('--test', help='''tests a given project,
                                           use 'all' to test all''')
    p.add_argument('--try_', help='''try the patch on buildbot''')
    options = p.parse_args()
    if (options.create or options.pull or options.test or
        options.try_ ) is not None:
        return options
    else:
        p.error('Invalid command, use --help for list of options')


def main():
    options = command_parser()

    if options.create:
        project_path = "%s/%s" % (os.getcwd(), options.create)
        os.system('mkdir %s' % project_path)
        os.system('mkdir %s/config' % project_path)
        os.system('mkdir %s/logs' % project_path)
        original_config = '%s/config/ci.cfg' % PROJ_PATH
        os.system('cp %s %s/config' %(original_config, project_path))

    if options.pull:
        project_path = "%s/%s" % (os.getcwd(), options.pull)
        pull = Command()
        pull.pull(project_path = project_path)

    if options.test:
        project_path = "%s/%s" % (os.getcwd(), options.test)
        test = Command()
        test.test(project_path = project_path)

    if options.try_:
        project_path = "%s/%s" % (os.getcwd(), options.try_)
        try_ = Command()
        try_.try_(project_path = project_path)


if __name__ == '__main__':
    main()
