import settings
import logging

__metaclass__ = type
__all__ = ['ParseError',
           'NetworkError',
           'ArgumentError',
           'PullFailure',
           'TestFailure',
           'Logger']


class ParseError(Exception):

    def __init__(self, message):
        self.message = message
        self.log()

    def __str__(self):
        return "Parse Error : %s" % self.message

    def log(self):
        return Logger("error").log(self)


class NetworkError(Exception):

    def __init__(self, message):
        self.message = message
        self.log()

    def __str__(self):
        return "Network Error : %s" % self.message

    def log(self):
        return Logger("error").log(self)


class ArgumentError(Exception):

    def __init__(self, message):
        self.message = message
        self.log()

    def __str__(self):
        return "Argument Error : %s" % self.message

    def log(self):
        return Logger("error").log(self)


class PullFailure(Exception):

    def __init__(self, message):
        self.message = message
        self.log()

    def __str__(self):
        return "Pull Failure : %s" % self.message

    def log(self):
        return Logger("error").log(self)


class TestFailure(Exception):

    def __init__(self, message):
        self.message = message
        self.log()

    def __str__(self):
        return "Test Failure : %s" % self.message

    def log(self):
        return Logger("error").log(self)


class TryFailure(Exception):

    def __init__(self, message):
        self.message = message
        self.log()

    def __str__(self):
        return "Try Failure : %s" % self.message

    def log(self):
        return Logger("error").log(self)



class Logger():

    def __init__(self, level):
        LEVELS = {'debug': logging.DEBUG,
                  'info': logging.INFO,
                  'warning': logging.WARNING,
                  'error': logging.ERROR}
        self.level = LEVELS.get(level)

    def log(self, message):
        logging.basicConfig(filename=settings.LOGFILE, level=self.level,
                            format='%(asctime)s %(levelname)s %(message)s',
                            datefmt="%Y-%m-%d %H:%M:%S")
        if self.level is 10:
            logging.debug(message)
        elif self.level is 20:
            logging.info(message)
        elif self.level is 30:
            logging.warning(message)
        elif self.level is 40:
            logging.error(message)

