# Copyright (C) 1998-2014 by the Free Software Foundation, Inc.
#
# This file is part of mmci.
#
# mmci is free software: you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation, either version 3 of the License, or (at your option)
# any later version.
#
# mmci is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
# more details.
#
# You should have received a copy of the GNU General Public License along with
# mmci.  If not, see <http://www.gnu.org/licenses/>.

from setuptools import setup, find_packages


setup(
    name = "mmci",
    version = '0.1.alpha.2',
    description = "Tool which may be used to check continous integration of GNU Mailman projects",
    license = 'GPLv3',
    url = "https://launchpad.net/~varun/mailman/mmci",
    classifiers = [
        "Programming Language :: Python",
        ],
    keywords = ['testing'],
    packages = find_packages('src'),
    package_dir = {'': 'src'},
    include_package_data = True,
    entry_points = {
        'console_scripts': ['mmci = mmci.runner:main']
                    },
    install_requires = ['mailman',
                        'mailmanclient',
                        'postorius',
                        'hyperkitty',
                        'kittystore',],
)
