# Copyright (C) 1998-2014 by the Free Software Foundation, Inc.
#
# This file is part of mmci.
#
# mmci is free software: you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation, either version 3 of the License, or (at your option)
# any later version.
#
# mmci is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
# more details.
#
# You should have received a copy of the GNU General Public License along with
# mmci.  If not, see <http://www.gnu.org/licenses/>.

import os
import subprocess
import abc
import nose2
import exceptions
from ConfigParser import ConfigParser
from mmci.base.config import Config
from mmci.base.errors import CommandFailure
from mmci.setup import PROJ_PATH


__metaclass__ = type
__all__ = ['Command']


class Command(object):
    """ Initializes the command"""

    @staticmethod
    def load_config(project_path):
        """ Load a configuration file
        :param project_path: The path of the project from which command is called
        :type project_path: str
        :return: Returns the ConfigParser object after reading the config file
        :rtype: ConfigParser object
        
        """
        config_path = "%s/config/ci.cfg" % project_path
        config = ConfigParser()
        config.read(config_path)
        return config

    @staticmethod
    def parse_config(project_path, config):
        """ Parse a configuration file and returns the dictionary of projects
        :param project_path: The path of project from which command is called
        :type project_path: str
        :param config: The ConfigParser object after reading the configuration file
        :type config: ConfigParser object
        :return: Dictionary of projects having further dictionaries for version control, source, path, remote(in git) and branch(in git)
        :rtype: dict
        """
        projects = config.options('projects')
        projects_dict = {}
        parent_path = os.path.abspath(os.path.join(project_path, os.pardir))
        for project in projects:
            projects_dict['%s' % project] = {'vcs' : config.get(project, 'vcs'),
                                             'path' : '%s/%s' % (parent_path, config.get(project, 'path')),
                                             'src' : '%s/%s' %(parent_path, config.get(project, 'src'))}
        return projects_dict
         

    def pull(self, project_path):
        """ Pulls the projects defined in config/ci.cfg of the created project
        :param project_path: The path of project from which command is called
        :type project_path: str
        :return: None
        """
        config = self.load_config(project_path)
        projects_dict = self.parse_config(project_path, config)
        for project, values in projects_dict.items():
            os.chdir(values['path'])
            if values['vcs'] == 'git':
                remote = config.get(project, 'remote')
                branch = config.get(project, 'branch')
                os.system('%s pull %s %s' % (values['vcs'], remote, branch))
            else:
                os.system('%s pull' % values['vcs'])
        
    def test(self, project_path):
        """ Tests all the projects listed in config/ci.cfg of the created project
        :param project_path: The path of project from which command is called
        :type project_path: str
        :return: None
        """
        config = self.load_config(project_path)
        projects_dict = self.parse_config(project_path, config)
        for project, values in projects_dict.items():
            os.chdir(values['src'])
            print project
            try:
                nose2.discover(argv=['-v'])
            except:
                pass
 
