# Copyright (C) 1998-2014 by the Free Software Foundation, Inc.
#
# This file is part of mmci.
#
# mmci is free software: you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation, either version 3 of the License, or (at your option)
# any later version.
#
# mmci is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
# more details.
#
# You should have received a copy of the GNU General Public License along with
# mmci.  If not, see <http://www.gnu.org/licenses/>.

import os
import argparse
from mmci import version
from mmci.base.command import Command
from mmci.base.logger import Log
from mmci.base.errors import ProjectNotFound, ConfigNotFound


def command_parser():
    """ Parses the sys.args using argparse module.
    Commands that are currently implemented are: create, pull, test and try_
    :return: argparse.Namespace object
    """
    p = argparse.ArgumentParser()
    p.add_argument('--create', help="creates new project settings")
    p.add_argument('--pull', help="pulls a given project")
    p.add_argument('--test', help="tests a given project")
    p.add_argument('--try_', help="try the patch on buildbot")
    p.add_argument('--version', action="store_true", help="returns the version")
    options = p.parse_args()
    if (options.create is None and
        options.pull is None and
        options.test is None and
        options.try_ is None and
        options.version is False):
        p.error('Invalid command, use --help for list of options')
    else:
        if options.pull or options.test or options.try_:
            path = options.pull or options.test or options.try_
            parent_path = os.getcwd()
            if not os.path.isdir(path):
                raise ProjectNotFound("mmci project not found at %s/%s" % (parent_path, path))
            if not os.path.isfile('%s/config/mmci.cfg' % path):
                raise ConfigNotFound("mmci project configuration not found at %s/%s/config/mmci.cfg" % (parent_path, path))
        return options


def main():
    options = command_parser()
    mmci_module = __import__('mmci')

    if options.create:
        project_path = "%s/%s" % (os.getcwd(), options.create)
        os.system('mkdir %s' % project_path)
        os.system('mkdir %s/config' % project_path)
        os.system('mkdir %s/logs' % project_path)
        os.system('mkdir %s/patches' % project_path)
        original_config = '%s/config/mmci.cfg' % mmci_module.__path__[0]
        os.system('cp %s %s/config' %(original_config, project_path))

    elif options.pull:
        project_path = "%s/%s" % (os.getcwd(), options.pull)
        pull = Command()
        pull.pull(project_path = project_path)

    elif options.test:
        project_path = "%s/%s" % (os.getcwd(), options.test)
        test = Command()
        test.test(project_path = project_path)

    elif options.try_:
        project_path = "%s/%s" % (os.getcwd(), options.try_)
        try_ = Command()
        try_.try_(project_path = project_path)
    elif options.version:
        print(version.VERSION)


if __name__ == '__main__':
    main()
