# Copyright (C) 1998-2014 by the Free Software Foundation, Inc.
#
# This file is part of mmci.
#
# mmci is free software: you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation, either version 3 of the License, or (at your option)
# any later version.
#
# mmci is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
# more details.
#
# You should have received a copy of the GNU General Public License along with
# mmci.  If not, see <http://www.gnu.org/licenses/>.

import os
from ConfigParser import ConfigParser
from twisted.internet import reactor, protocol

__metaclass__ = type
__all__ = ['Server',
           'TryPatch']


class Server(protocol.Protocol):

    def connectionMade(self):
        print("Connection Established")
        print("Connected to %s " % self.transport.getPeer())

    def connectionLost(self, reason):
        print("Connection Lost")

    def dataReceived(self, data):
        print("Received file %s" % settings.SERVER_PATCH_NAME)
        f = open(settings.SERVER_PATCH_NAME, 'w')
        f.write(data)
        f.close()
        try_ = TryPatch()
        try_.try_project('mailman')


class TryPatch():

    def __init__(self):
        pass

    def try_project(self,project):
        message = "Testing project %s on server " % project
        print(message)
        log = Logger("info")
        log.log(message)
        try:
            path = settings.PROJECTS[project]['path']
        except KeyError as e:
            raise TryFailure(e)
        os.chdir(path)
        os.system("patch -p0 < %s" % settings.SERVER_PATCH_NAME)
        test = Test()
        test.test_project(project)
        os.system("rm %s" % settings.SERVER_PATCH_NAME)
        return True
 


def main():
    factory = protocol.ServerFactory()
    factory.protocol = Server
    reactor.listenTCP(settings.SERVER_PORT,factory)
    reactor.run()


if __name__ == '__main__':
    main()
