# Copyright (C) 1998-2014 by the Free Software Foundation, Inc.
#
# This file is part of mmci.
#
# mmci is free software: you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation, either version 3 of the License, or (at your option)
# any later version.
#
# mmci is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
# more details.
#
# You should have received a copy of the GNU General Public License along with
# mmci.  If not, see <http://www.gnu.org/licenses/>.

import re
from setuptools import setup, find_packages


with open('src/mmci/version.py') as fp:
    for line in fp: 
        mo = re.match("VERSION = '(?P<version>[^']+?)'", line)
        if mo: 
            __version__ = mo.group('version')
            break
    else:
        print('No version number found')
        sys.exit(1)

setup(
    name = "mmci",
    version = __version__,
    description = "Tool which may be used to check continous integration of GNU Mailman projects",
    license = 'GPLv3',
    url = "https://launchpad.net/~varun/mailman/mmci",
    classifiers = [
        "Programming Language :: Python",
        ],
    keywords = ['testing'],
    packages = find_packages('src'),
    package_dir = {'': 'src'},
    include_package_data = True,
    entry_points = {
        'console_scripts': ['mmciclient = mmci.client.runner:main',
                            'mmciserver = mmci.server.runner:main']
                    },
    install_requires = ['twisted',
                        'nose2',
                        'mailman',
                        'mailmanclient',
                        'postorius',
                        'hyperkitty',
                        'kittystore',],
)
