# Copyright (C) 1998-2014 by the Free Software Foundation, Inc.
#
# This file is part of mmci.
#
# mmci is free software: you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation, either version 3 of the License, or (at your option)
# any later version.
#
# mmci is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
# more details.
#
# You should have received a copy of the GNU General Public License along with
# mmci.  If not, see <http://www.gnu.org/licenses/>.

from twisted.internet import reactor, protocol

__metaclass__ = type
__all__ = ['Client',
           'Factory']


class Client(protocol.Protocol):
    
    def connectionMade(self):
        self.sendFile()
        self.transport.loseConnection()

    def sendFile(self):
        print("Sending File %s" % settings.CLIENT_PATCH_NAME) 
        f = open(settings.CLIENT_PATCH_NAME,"rb")
        self.transport.write(f.read())
        f.close()


class Factory(protocol.ClientFactory):

    protocol = Client

    def clientConnectionFailed(self, connector, reason):
        print("Connection failed")
        reactor.stop()

    def clientConnectionLost(self, connector, reason):
        print("Connection Lost")
        reactor.stop()
