# Copyright (C) 1998-2014 by the Free Software Foundation, Inc.
#
# This file is part of mmci.
#
# mmci is free software: you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation, either version 3 of the License, or (at your option)
# any later version.
#
# mmci is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
# more details.
#
# You should have received a copy of the GNU General Public License along with
# mmci.  If not, see <http://www.gnu.org/licenses/>.

import abc
from mmci.client.base.logger import Log

__metaclass__ = type
__all__ = ['CommandFailure',
           'ProjectNotFound',
           'ConfigNotFound',
           'ConfigError',
           'ConnectionError',]


class CommandFailure(Exception):

    def __init__(self, message):
        self.message = message

    def __str__(self):
        return "Command Failure : %s" % self.message

class ProjectNotFound(Exception):

    def __init__(self, message):
        self.message = message

    def __str__(self):
        return "Project Not Found : %s" % self.message

class ConfigNotFound(Exception):

    def __init__(self, message):
        self.message = message

    def __str__(self):
        return "Config Not Found : %s" % self.message

class ConfigError(Exception):

    def __init__(self, message):
        self.message = message

    def __str__(self):
        return "Error in Reading Configuration : %s" % self.message

class ConnectionError(Exception):

    def __init__(self, message):
        self.message = message

    def __str__(self):
        return "Error in Connection : %s" % self.message
