# Copyright (C) 1998-2014 by the Free Software Foundation, Inc.
#
# This file is part of mmci.
#
# mmci is free software: you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation, either version 3 of the License, or (at your option)
# any later version.
#
# mmci is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
# more details.
#
# You should have received a copy of the GNU General Public License along with
# mmci.  If not, see <http://www.gnu.org/licenses/>.

import abc
import logging
from ConfigParser import ConfigParser

__metaclass__ = type
__all__ = ['Log']


class Log(object):

    def __init__(self, message, client_path, level):
        level_dict = {10:'DEBUG', 20:'INFO', 30:'WARNING', 40:'ERROR'}
        print('%s : %s' % (level_dict[level], message))
        self.message = message
        config_path = "%s/config/mmci.cfg" % client_path
        config = ConfigParser()
        config.read(config_path)
        logging_level = int(config.get('others', 'logging_level'))
        logging.basicConfig(filename='%s/logs/mmci.log' % client_path, level=logging_level,
                            format='%(asctime)s %(levelname)s %(message)s',
                            datefmt="%Y-%m-%d %H:%M:%S")
        if level is 10:
            logging.debug(message)
        elif level is 20:
            logging.info(message)
        elif level is 30:
            logging.warning(message)
        elif level is 40:
            logging.error(message)

    def __str__(self):
        return self.message
