import unittest
import os
import argparse
import subprocess
from mmci.base.command import Command
from mmci.base.errors import ProjectNotFound, ConfigNotFound


class TestInterface(unittest.TestCase):

    def test_project_not_found(self):
        self.assertRaises(ProjectNotFound, subprocess.check_output('mmci --pull abc', shell=True))
#        self.assertEqual(os.system('mmci --pull aa'), 0)

#    def test_config_not_found(self):
#        self.assertEqual(os.system('mmci --pull aaaa'), 0)
        

"""

class PullCI(unittest.TestCase):

    def setUp(self):
        self.parser = argparse.ArgumentParser()

#    def test_interface(self):
#        self.assertRaises(ParseError, os.system,'./ci-tool -p foo')
#        self.assertEqual(os.system('mmci --create foo'), 0)
#        self.assertEqual(os.system('mmci --pull fake/foo'), 0)
#        self.assertEqual(os.system('mmci --test fake/foo'), 0)
#        self.assertEqual(os.system('mmci --version'), 0)

    def test_failure_on_undefined_project(self):
        pull = Command()
        self.assertRaises(ConfigNotFound, pull.pull, 'undefined_project')

    def test_pull_mailman(self):
        pull = Pull()
        self.assertEqual(pull.pull_project('mailman'), True)

    def test_pull_mailman_client(self):
        pull = Pull()
        self.assertEqual(pull.pull_project('mailman.client'), True)

    def test_pull_postorius(self):
        pull = Pull()
        self.assertEqual(pull.pull_project('postorius'), True)

    def test_pull_postorius_standalone(self):
        pull = Pull()
        self.assertEqual(pull.pull_project('postorius_standalone'), True)

    def test_pull_hyperkitty(self):
        pull = Pull()
        self.assertEqual(pull.pull_project('hyperkitty'), True)

    def test_pull_hyperkitty_standalone(self):
        pull = Pull()
        self.assertEqual(pull.pull_project('hyperkitty_standalone'), True)


class TestCI(unittest.TestCase):

    def test_interface(self):
        self.assertEqual(os.system('./ci-tool -t mailman'), 0)
        self.assertEqual(os.system('./ci-tool -t mailman.client'), 0)
        self.assertEqual(os.system('./ci-tool -t postorius'), 0)
        self.assertEqual(os.system('./ci-tool -t hyperkitty'), 0)

    def test_failure_on_undefined_project(self):
        test = Test()
        self.assertRaises(TestFailure, test.test_project, 'undefined_project')

    def test_test_mailman(self):
        test = Test()
        self.assertEqual(test.test_project('mailman'), True)

    def test_test_mailman_client(self):
        test = Test()
        self.assertEqual(test.test_project('mailman.client'), True)

    def test_test_postorius(self):
        test = Test()
        self.assertEqual(test.test_project('postorius'), True)

    def test_test_postorius_standalone(self):
        test = Test()
        self.assertEqual(test.test_project('postorius_standalone'), True)

    def test_test_hyperkitty(self):
        test = Test()
        self.assertEqual(test.test_project('hyperkitty'), True)

    def test_test_hyperkitty_standalone(self):
        test = Test()
        self.assertEqual(test.test_project('hyperkitty_standalone'), True)


class TryCI(unittest.TestCase):

    def test_try_mailman(self):
        pass

    def test_try_mailman_client(self):
        pass

    def test_try_postorius(self):
        pass

    def test_try_postorius_standalone(self):
        pass

    def test_try_hyperkitty(self):
        pass

    def test_try_hyperkitty_standalone(self):
        pass

"""
if __name__ == '__main__':
    unittest.main()
