import unittest
from selenium import webdriver
from selenium.common.exceptions import NoSuchElementException


class TestOne(unittest.TestCase):

    def setUp(self):
        self.driver = webdriver.PhantomJS()
        self.base_url = "http://postorius.sharmalabs.com"

    def test_url(self):
        self.driver.get(self.base_url)
        self.driver.find_element_by_class_name("mm_loginName").find_element_by_tag_name("a").click()
        self.assertIn("%s/postorius/accounts/login/"%self.base_url, self.driver.current_url)

    def test_login(self):
        self.driver.get("%s/postorius/accounts/login/"%self.base_url)
        self.driver.find_element_by_id('id_username').send_keys("varun")
        self.driver.find_element_by_id('id_password').send_keys("pass")
        self.driver.find_element_by_class_name("mm_login").find_element_by_tag_name("button").click()
        self.assertIn("%s/postorius/lists/"%self.base_url, self.driver.current_url)
        self.assertEqual(self.driver.find_element_by_class_name("mm_header").find_element_by_class_name("icon-off").is_displayed(),True)

    def test_logout(self):
        self.test_login()
        self.driver.find_element_by_class_name("mm_header").find_element_by_class_name("icon-off").click()
        self.driver.get("%s/postorius/accounts/profile/"%self.base_url)
        self.assertIn("%s/postorius/accounts/login/?next=/postorius/accounts/profile/"%self.base_url, self.driver.current_url)
#        self.assertRaises(NoSuchElementException,self.driver.find_element_by_class_name("mm_header").find_element_by_class_name("icon-off"))

    def test_access_before_login(self):
        self.driver.get("%s/postorius/accounts/profile/"%self.base_url)
        self.assertIn("%s/postorius/accounts/login/?next=/postorius/accounts/profile/"%self.base_url, self.driver.current_url)
        
    def test_access_while_login(self):
        self.test_login()
        self.driver.get("%s/postorius/accounts/profile/"%self.base_url)
        self.assertIn("%s/postorius/accounts/profile/"%self.base_url, self.driver.current_url)

    def test_access_after_logout(self):
        self.test_logout()
        self.test_access_before_login()

    def tearDown(self):
        self.driver.quit

if __name__ == '__main__':
    unittest.main()
