# -*- coding: utf-8 -*-
from functools import partial

from collections import namedtuple


__all__ = ["countries"]


Country = namedtuple('Country', 'name, alpha2, alpha3, numeric, mcc')

def _records():
    return [
        Country(u"Afghanistan", "AF", "AFG", "004", "412"),
        Country(u"Åland Islands", "AX", "ALA", "248", None),
        Country(u"Albania", "AL", "ALB", "008", "276"),
        Country(u"Algeria", "DZ", "DZA", "012", "603"),
        Country(u"American Samoa", "AS", "ASM", "016", "544"),
        Country(u"Andorra", "AD", "AND", "020", "213"),
        Country(u"Angola", "AO", "AGO", "024", "631"),
        Country(u"Anguilla", "AI", "AIA", "660", "365"),
        Country(u"Antarctica", "AQ", "ATA", "010", None),
        Country(u"Antigua and Barbuda", "AG", "ATG", "028", "344"),
        Country(u"Argentina", "AR", "ARG", "032", "722"),
        Country(u"Armenia", "AM", "ARM", "051", "283"),
        Country(u"Aruba", "AW", "ABW", "533", "363"),
        Country(u"Australia", "AU", "AUS", "036", "505"),
        Country(u"Austria", "AT", "AUT", "040", "232"),
        Country(u"Azerbaijan", "AZ", "AZE", "031", "400"),
        Country(u"Bahamas", "BS", "BHS", "044", "364"),
        Country(u"Bahrain", "BH", "BHR", "048", "426"),
        Country(u"Bangladesh", "BD", "BGD", "050", "470"),
        Country(u"Barbados", "BB", "BRB", "052", "342"),
        Country(u"Belarus", "BY", "BLR", "112", "257"),
        Country(u"Belgium", "BE", "BEL", "056", "206"),
        Country(u"Belize", "BZ", "BLZ", "084", "702"),
        Country(u"Benin", "BJ", "BEN", "204", "616"),
        Country(u"Bermuda", "BM", "BMU", "060", ("350", "338", "310")),
        Country(u"Bhutan", "BT", "BTN", "064", "402"),
        Country(u"Bolivia, Plurinational State of", "BO", "BOL", "068", "736"),
        Country(u"Bonaire, Sint Eustatius and Saba", "BQ", "BES", "535", None),
        Country(u"Bosnia and Herzegovina", "BA", "BIH", "070", "218"),
        Country(u"Botswana", "BW", "BWA", "072", "652"),
        Country(u"Bouvet Island", "BV", "BVT", "074", None),
        Country(u"Brazil", "BR", "BRA", "076", "724"),
        Country(u"British Indian Ocean Territory", "IO", "IOT", "086", None),
        Country(u"Brunei Darussalam", "BN", "BRN", "096", "528"),
        Country(u"Bulgaria", "BG", "BGR", "100", "284"),
        Country(u"Burkina Faso", "BF", "BFA", "854", "613"),
        Country(u"Burundi", "BI", "BDI", "108", "642"),
        Country(u"Cambodia", "KH", "KHM", "116", "456"),
        Country(u"Cameroon", "CM", "CMR", "120", "624"),
        Country(u"Canada", "CA", "CAN", "124", "302"),
        Country(u"Cape Verde", "CV", "CPV", "132", "625"),
        Country(u"Cayman Islands", "KY", "CYM", "136", "346"),
        Country(u"Central African Republic", "CF", "CAF", "140", "623"),
        Country(u"Chad", "TD", "TCD", "148", "622"),
        Country(u"Chile", "CL", "CHL", "152", "730"),
        Country(u"China", "CN", "CHN", "156", "460"),
        Country(u"Christmas Island", "CX", "CXR", "162", None),
        Country(u"Cocos (Keeling) Islands", "CC", "CCK", "166", None),
        Country(u"Colombia", "CO", "COL", "170", "732"),
        Country(u"Comoros", "KM", "COM", "174", "654"),
        Country(u"Congo", "CG", "COG", "178", "629"),
        Country(u"Congo, Democratic Republic of the", "CD", "COD", "180", "630"),
        Country(u"Cook Islands", "CK", "COK", "184", "548"),
        Country(u"Costa Rica", "CR", "CRI", "188", "712"),
        Country(u"Côte d'Ivoire", "CI", "CIV", "384", "612"),
        Country(u"Croatia", "HR", "HRV", "191", "219"),
        Country(u"Cuba", "CU", "CUB", "192", "368"),
        Country(u"Curaçao", "CW", "CUW", "531", None),
        Country(u"Cyprus", "CY", "CYP", "196", "280"),
        Country(u"Czech Republic", "CZ", "CZE", "203", "230"),
        Country(u"Denmark", "DK", "DNK", "208", "238"),
        Country(u"Djibouti", "DJ", "DJI", "262", "638"),
        Country(u"Dominica", "DM", "DMA", "212", "366"),
        Country(u"Dominican Republic", "DO", "DOM", "214", "370"),
        Country(u"Ecuador", "EC", "ECU", "218", "740"),
        Country(u"Egypt", "EG", "EGY", "818", "602"),
        Country(u"El Salvador", "SV", "SLV", "222", "706"),
        Country(u"Equatorial Guinea", "GQ", "GNQ", "226", "627"),
        Country(u"Eritrea", "ER", "ERI", "232", "657"),
        Country(u"Estonia", "EE", "EST", "233", "248"),
        Country(u"Ethiopia", "ET", "ETH", "231", "636"),
        Country(u"Falkland Islands (Malvinas)", "FK", "FLK", "238", None),
        Country(u"Faroe Islands", "FO", "FRO", "234", "288"),
        Country(u"Fiji", "FJ", "FJI", "242", "542"),
        Country(u"Finland", "FI", "FIN", "246", "244"),
        Country(u"France", "FR", "FRA", "250", "208"),
        Country(u"French Guiana", "GF", "GUF", "254", None),
        Country(u"French Polynesia", "PF", "PYF", "258", "547"),
        Country(u"French Southern Territories", "TF", "ATF", "260", None),
        Country(u"Gabon", "GA", "GAB", "266", "628"),
        Country(u"Gambia", "GM", "GMB", "270", "607"),
        Country(u"Georgia", "GE", "GEO", "268", "282"),
        Country(u"Germany", "DE", "DEU", "276", "262"),
        Country(u"Ghana", "GH", "GHA", "288", "620"),
        Country(u"Gibraltar", "GI", "GIB", "292", "266"),
        Country(u"Greece", "GR", "GRC", "300", "202"),
        Country(u"Greenland", "GL", "GRL", "304", "290"),
        Country(u"Grenada", "GD", "GRD", "308", "352"),
        Country(u"Guadeloupe", "GP", "GLP", "312", "340"),
        Country(u"Guam", "GU", "GUM", "316", ("310", "311")),
        Country(u"Guatemala", "GT", "GTM", "320", "704"),
        Country(u"Guernsey", "GG", "GGY", "831", "234"),
        Country(u"Guinea", "GN", "GIN", "324", "611"),
        Country(u"Guinea-Bissau", "GW", "GNB", "624", "632"),
        Country(u"Guyana", "GY", "GUY", "328", "738"),
        Country(u"Haiti", "HT", "HTI", "332", "372"),
        Country(u"Heard Island and McDonald Islands", "HM", "HMD", "334", "708"),
        Country(u"Holy See (Vatican City State)", "VA", "VAT", "336", "225"),
        Country(u"Honduras", "HN", "HND", "340", None),
        Country(u"Hong Kong", "HK", "HKG", "344", "454"),
        Country(u"Hungary", "HU", "HUN", "348", "216"),
        Country(u"Iceland", "IS", "ISL", "352", "274"),
        Country(u"India", "IN", "IND", "356", ("404", "405")),
        Country(u"Indonesia", "ID", "IDN", "360", "510"),
        Country(u"Iran, Islamic Republic of", "IR", "IRN", "364", "432"),
        Country(u"Iraq", "IQ", "IRQ", "368", "418"),
        Country(u"Ireland", "IE", "IRL", "372", "272"),
        Country(u"Isle of Man", "IM", "IMN", "833", "234"),
        Country(u"Israel", "IL", "ISR", "376", "425"),
        Country(u"Italy", "IT", "ITA", "380", "222"),
        Country(u"Jamaica", "JM", "JAM", "388", "338"),
        Country(u"Japan", "JP", "JPN", "392", "440"),
        Country(u"Jersey", "JE", "JEY", "832", "234"),
        Country(u"Jordan", "JO", "JOR", "400", "416"),
        Country(u"Kazakhstan", "KZ", "KAZ", "398", "401"),
        Country(u"Kenya", "KE", "KEN", "404", "639"),
        Country(u"Kiribati", "KI", "KIR", "296", "545"),
        Country(u"Korea, Democratic People's Republic of", "KP", "PRK", "408", None),
        Country(u"Korea, Republic of", "KR", "KOR", "410", "450"),
        Country(u"Kuwait", "KW", "KWT", "414", "419"),
        Country(u"Kyrgyzstan", "KG", "KGZ", "417", "437"),
        Country(u"Lao People's Democratic Republic", "LA", "LAO", "418", "457"),
        Country(u"Latvia", "LV", "LVA", "428", "247"),
        Country(u"Lebanon", "LB", "LBN", "422", "415"),
        Country(u"Lesotho", "LS", "LSO", "426", "651"),
        Country(u"Liberia", "LR", "LBR", "430", "618"),
        Country(u"Libya", "LY", "LBY", "434", "606"),
        Country(u"Liechtenstein", "LI", "LIE", "438", "295"),
        Country(u"Lithuania", "LT", "LTU", "440", "246"),
        Country(u"Luxembourg", "LU", "LUX", "442", "270"),
        Country(u"Macao", "MO", "MAC", "446", "455"),
        Country(u"Macedonia, the former Yugoslav Republic of", "MK", "MKD", "807", "294"),
        Country(u"Madagascar", "MG", "MDG", "450", "646"),
        Country(u"Malawi", "MW", "MWI", "454", "650"),
        Country(u"Malaysia", "MY", "MYS", "458", "502"),
        Country(u"Maldives", "MV", "MDV", "462", "472"),
        Country(u"Mali", "ML", "MLI", "466", "610"),
        Country(u"Malta", "MT", "MLT", "470", "278"),
        Country(u"Marshall Islands", "MH", "MHL", "584", "551"),
        Country(u"Martinique", "MQ", "MTQ", "474", "340"),
        Country(u"Mauritania", "MR", "MRT", "478", "609"),
        Country(u"Mauritius", "MU", "MUS", "480", "617"),
        Country(u"Mayotte", "YT", "MYT", "175", None),
        Country(u"Mexico", "MX", "MEX", "484", "334"),
        Country(u"Micronesia, Federated States of", "FM", "FSM", "583", "550"),
        Country(u"Moldova, Republic of", "MD", "MDA", "498", "259"),
        Country(u"Monaco", "MC", "MCO", "492", "212"),
        Country(u"Mongolia", "MN", "MNG", "496", "428"),
        Country(u"Montenegro", "ME", "MNE", "499", "297"),
        Country(u"Montserrat", "MS", "MSR", "500", "354"),
        Country(u"Morocco", "MA", "MAR", "504", "604"),
        Country(u"Mozambique", "MZ", "MOZ", "508", "643"),
        Country(u"Myanmar", "MM", "MMR", "104", "414"),
        Country(u"Namibia", "NA", "NAM", "516", "649"),
        Country(u"Nauru", "NR", "NRU", "520", "536"),
        Country(u"Nepal", "NP", "NPL", "524", "429"),
        Country(u"Netherlands", "NL", "NLD", "528", "204"),
        Country(u"New Caledonia", "NC", "NCL", "540", "546"),
        Country(u"New Zealand", "NZ", "NZL", "554", "530"),
        Country(u"Nicaragua", "NI", "NIC", "558", "710"),
        Country(u"Niger", "NE", "NER", "562", "614"),
        Country(u"Nigeria", "NG", "NGA", "566", "621"),
        Country(u"Niue", "NU", "NIU", "570", "555"),
        Country(u"Norfolk Island", "NF", "NFK", "574", "505"),
        Country(u"Northern Mariana Islands", "MP", "MNP", "580", None),
        Country(u"Norway", "NO", "NOR", "578", "242"),
        Country(u"Oman", "OM", "OMN", "512", "422"),
        Country(u"Pakistan", "PK", "PAK", "586", "410"),
        Country(u"Palau", "PW", "PLW", "585", "552"),
        Country(u"Palestine, State of", "PS", "PSE", "275", "425"),
        Country(u"Panama", "PA", "PAN", "591", "714"),
        Country(u"Papua New Guinea", "PG", "PNG", "598", "537"),
        Country(u"Paraguay", "PY", "PRY", "600", "744"),
        Country(u"Peru", "PE", "PER", "604", "716"),
        Country(u"Philippines", "PH", "PHL", "608", "515"),
        Country(u"Pitcairn", "PN", "PCN", "612", None),
        Country(u"Poland", "PL", "POL", "616", "260"),
        Country(u"Portugal", "PT", "PRT", "620", "268"),
        Country(u"Puerto Rico", "PR", "PRI", "630", "330"),
        Country(u"Qatar", "QA", "QAT", "634", "427"),
        Country(u"Réunion", "RE", "REU", "638", "647"),
        Country(u"Romania", "RO", "ROU", "642", "226"),
        Country(u"Russian Federation", "RU", "RUS", "643", "250"),
        Country(u"Rwanda", "RW", "RWA", "646", "635"),
        Country(u"Saint Barthélemy", "BL", "BLM", "652", None),
        Country(u"Saint Helena, Ascension and Tristan da Cunha",
                "SH", "SHN", "654", None),
        Country(u"Saint Kitts and Nevis", "KN", "KNA", "659", "356"),
        Country(u"Saint Lucia", "LC", "LCA", "662", "358"),
        Country(u"Saint Martin (French part)", "MF", "MAF", "663", None),
        Country(u"Saint Pierre and Miquelon", "PM", "SPM", "666", "308"),
        Country(u"Saint Vincent and the Grenadines", "VC", "VCT", "670", "360"),
        Country(u"Samoa", "WS", "WSM", "882", "549"),
        Country(u"San Marino", "SM", "SMR", "674", "292"),
        Country(u"Sao Tome and Principe", "ST", "STP", "678", "626"),
        Country(u"Saudi Arabia", "SA", "SAU", "682", "420"),
        Country(u"Senegal", "SN", "SEN", "686", "608"),
        Country(u"Serbia", "RS", "SRB", "688", "220"),
        Country(u"Seychelles", "SC", "SYC", "690", "633"),
        Country(u"Sierra Leone", "SL", "SLE", "694", "619"),
        Country(u"Singapore", "SG", "SGP", "702", "525"),
        Country(u"Sint Maarten (Dutch part)", "SX", "SXM", "534", None),
        Country(u"Slovakia", "SK", "SVK", "703", "231"),
        Country(u"Slovenia", "SI", "SVN", "705", "293"),
        Country(u"Solomon Islands", "SB", "SLB", "090", "540"),
        Country(u"Somalia", "SO", "SOM", "706", "637"),
        Country(u"South Africa", "ZA", "ZAF", "710", "655"),
        Country(u"South Georgia and the South Sandwich Islands",
                "GS", "SGS", "239", None),
        Country(u"South Sudan", "SS", "SSD", "728", "659"),
        Country(u"Spain", "ES", "ESP", "724", "214"),
        Country(u"Sri Lanka", "LK", "LKA", "144", "13"),
        Country(u"Sudan", "SD", "SDN", "729", "634"),
        Country(u"Suriname", "SR", "SUR", "740", "746"),
        Country(u"Svalbard and Jan Mayen", "SJ", "SJM", "744", None),
        Country(u"Swaziland", "SZ", "SWZ", "748", "653"),
        Country(u"Sweden", "SE", "SWE", "752", "240"),
        Country(u"Switzerland", "CH", "CHE", "756", "228"),
        Country(u"Syrian Arab Republic", "SY", "SYR", "760", "417"),
        Country(u"Taiwan, Province of China", "TW", "TWN", "158", "466"),
        Country(u"Tajikistan", "TJ", "TJK", "762", "436"),
        Country(u"Tanzania, United Republic of", "TZ", "TZA", "834", "640"),
        Country(u"Thailand", "TH", "THA", "764", "520"),
        Country(u"Timor-Leste", "TL", "TLS", "626", None),
        Country(u"Togo", "TG", "TGO", "768", "615"),
        Country(u"Tokelau", "TK", "TKL", "772", None),
        Country(u"Tonga", "TO", "TON", "776", "539"),
        Country(u"Trinidad and Tobago", "TT", "TTO", "780", "374"),
        Country(u"Tunisia", "TN", "TUN", "788", "605"),
        Country(u"Turkey", "TR", "TUR", "792", "286"),
        Country(u"Turkmenistan", "TM", "TKM", "795", "438"),
        Country(u"Turks and Caicos Islands", "TC", "TCA", "796", ("338", "376")),
        Country(u"Tuvalu", "TV", "TUV", "798", "553"),
        Country(u"Uganda", "UG", "UGA", "800", "641"),
        Country(u"Ukraine", "UA", "UKR", "804", "255"),
        Country(u"United Arab Emirates", "AE", "ARE", "784", "424"),
        Country(u"United Kingdom", "GB", "GBR", "826", ("234", "235")),
        Country(u"United States", "US", "USA", "840", ("310", "311", "313", "316")),
        Country(u"United States Minor Outlying Islands", "UM", "UMI", "581", None),
        Country(u"Uruguay", "UY", "URY", "858", "748"),
        Country(u"Uzbekistan", "UZ", "UZB", "860", "434"),
        Country(u"Vanuatu", "VU", "VUT", "548", "541"),
        Country(u"Venezuela, Bolivarian Republic of", "VE", "VEN", "862", "734"),
        Country(u"Viet Nam", "VN", "VNM", "704", "452"),
        Country(u"Virgin Islands, British", "VG", "VGB", "092", None),
        Country(u"Virgin Islands, U.S.", "VI", "VIR", "850", None),
        Country(u"Wallis and Futuna", "WF", "WLF", "876", None),
        Country(u"Western Sahara", "EH", "ESH", "732", None),
        Country(u"Yemen", "YE", "YEM", "887", "412"),
        Country(u"Zambia", "ZM", "ZMB", "894", "645"),
        Country(u"Zimbabwe", "ZW", "ZWE", "716", "648")
    ]


def _build_index(idx, records):
    return dict((r[idx].upper(), r) for r in records)


def _build_index_tuple(idx, records):
    # There can be multiple MCC codes per country
    result = {}
    for r in records:
        if isinstance(r[idx], tuple):
            for k in r[idx]:
                if k:
                    result[k.upper()] = r
        elif r[idx]:
            result[r[idx].upper()] = r
    return result


def _get(var, method, idx, code):
    global _cache
    if 'records' not in _cache:
        _cache['records'] = _records()
    if var not in _cache:
        _cache[var] = method(idx, _cache['records'])
    return _cache[var][code]


_cache = {}
name = partial(_get, 'name', _build_index, 0)
alpha2 = partial(_get, 'alpha2', _build_index, 1)
alpha3 = partial(_get, 'alpha3', _build_index, 2)
numeric = partial(_get, 'numeric', _build_index, 3)
mcc = partial(_get, 'mcc', _build_index_tuple, 4)
