# -*- coding: utf-8 -*-
from functools import partial

from collections import defaultdict, namedtuple

__all__ = ["countries"]


Country = namedtuple('Country', 'name, alpha2, alpha3, numeric, mcc')
Operator = namedtuple('Operator', 'mcc, mnc, brand, operator')


def _countries():
    return [
        Country(u"Afghanistan", "AF", "AFG", "004", "412"),
        Country(u"Åland Islands", "AX", "ALA", "248", None),
        Country(u"Albania", "AL", "ALB", "008", "276"),
        Country(u"Algeria", "DZ", "DZA", "012", "603"),
        Country(u"American Samoa", "AS", "ASM", "016", "544"),
        Country(u"Andorra", "AD", "AND", "020", "213"),
        Country(u"Angola", "AO", "AGO", "024", "631"),
        Country(u"Anguilla", "AI", "AIA", "660", "365"),
        Country(u"Antarctica", "AQ", "ATA", "010", None),
        Country(u"Antigua and Barbuda", "AG", "ATG", "028", "344"),
        Country(u"Argentina", "AR", "ARG", "032", "722"),
        Country(u"Armenia", "AM", "ARM", "051", "283"),
        Country(u"Aruba", "AW", "ABW", "533", "363"),
        Country(u"Australia", "AU", "AUS", "036", "505"),
        Country(u"Austria", "AT", "AUT", "040", "232"),
        Country(u"Azerbaijan", "AZ", "AZE", "031", "400"),
        Country(u"Bahamas", "BS", "BHS", "044", "364"),
        Country(u"Bahrain", "BH", "BHR", "048", "426"),
        Country(u"Bangladesh", "BD", "BGD", "050", "470"),
        Country(u"Barbados", "BB", "BRB", "052", "342"),
        Country(u"Belarus", "BY", "BLR", "112", "257"),
        Country(u"Belgium", "BE", "BEL", "056", "206"),
        Country(u"Belize", "BZ", "BLZ", "084", "702"),
        Country(u"Benin", "BJ", "BEN", "204", "616"),
        Country(u"Bermuda", "BM", "BMU", "060", ("350", "338", "310")),
        Country(u"Bhutan", "BT", "BTN", "064", "402"),
        Country(u"Bolivia, Plurinational State of", "BO", "BOL", "068", "736"),
        Country(u"Bonaire, Sint Eustatius and Saba", "BQ", "BES", "535", None),
        Country(u"Bosnia and Herzegovina", "BA", "BIH", "070", "218"),
        Country(u"Botswana", "BW", "BWA", "072", "652"),
        Country(u"Bouvet Island", "BV", "BVT", "074", None),
        Country(u"Brazil", "BR", "BRA", "076", "724"),
        Country(u"British Indian Ocean Territory", "IO", "IOT", "086", None),
        Country(u"Brunei Darussalam", "BN", "BRN", "096", "528"),
        Country(u"Bulgaria", "BG", "BGR", "100", "284"),
        Country(u"Burkina Faso", "BF", "BFA", "854", "613"),
        Country(u"Burundi", "BI", "BDI", "108", "642"),
        Country(u"Cambodia", "KH", "KHM", "116", "456"),
        Country(u"Cameroon", "CM", "CMR", "120", "624"),
        Country(u"Canada", "CA", "CAN", "124", "302"),
        Country(u"Cape Verde", "CV", "CPV", "132", "625"),
        Country(u"Cayman Islands", "KY", "CYM", "136", "346"),
        Country(u"Central African Republic", "CF", "CAF", "140", "623"),
        Country(u"Chad", "TD", "TCD", "148", "622"),
        Country(u"Chile", "CL", "CHL", "152", "730"),
        Country(u"China", "CN", "CHN", "156", "460"),
        Country(u"Christmas Island", "CX", "CXR", "162", None),
        Country(u"Cocos (Keeling) Islands", "CC", "CCK", "166", None),
        Country(u"Colombia", "CO", "COL", "170", "732"),
        Country(u"Comoros", "KM", "COM", "174", "654"),
        Country(u"Congo", "CG", "COG", "178", "629"),
        Country(u"Congo, Democratic Republic of the", "CD", "COD", "180", "630"),
        Country(u"Cook Islands", "CK", "COK", "184", "548"),
        Country(u"Costa Rica", "CR", "CRI", "188", "712"),
        Country(u"Côte d'Ivoire", "CI", "CIV", "384", "612"),
        Country(u"Croatia", "HR", "HRV", "191", "219"),
        Country(u"Cuba", "CU", "CUB", "192", "368"),
        Country(u"Curaçao", "CW", "CUW", "531", None),
        Country(u"Cyprus", "CY", "CYP", "196", "280"),
        Country(u"Czech Republic", "CZ", "CZE", "203", "230"),
        Country(u"Denmark", "DK", "DNK", "208", "238"),
        Country(u"Djibouti", "DJ", "DJI", "262", "638"),
        Country(u"Dominica", "DM", "DMA", "212", "366"),
        Country(u"Dominican Republic", "DO", "DOM", "214", "370"),
        Country(u"Ecuador", "EC", "ECU", "218", "740"),
        Country(u"Egypt", "EG", "EGY", "818", "602"),
        Country(u"El Salvador", "SV", "SLV", "222", "706"),
        Country(u"Equatorial Guinea", "GQ", "GNQ", "226", "627"),
        Country(u"Eritrea", "ER", "ERI", "232", "657"),
        Country(u"Estonia", "EE", "EST", "233", "248"),
        Country(u"Ethiopia", "ET", "ETH", "231", "636"),
        Country(u"Falkland Islands (Malvinas)", "FK", "FLK", "238", None),
        Country(u"Faroe Islands", "FO", "FRO", "234", "288"),
        Country(u"Fiji", "FJ", "FJI", "242", "542"),
        Country(u"Finland", "FI", "FIN", "246", "244"),
        Country(u"France", "FR", "FRA", "250", "208"),
        Country(u"French Guiana", "GF", "GUF", "254", None),
        Country(u"French Polynesia", "PF", "PYF", "258", "547"),
        Country(u"French Southern Territories", "TF", "ATF", "260", None),
        Country(u"Gabon", "GA", "GAB", "266", "628"),
        Country(u"Gambia", "GM", "GMB", "270", "607"),
        Country(u"Georgia", "GE", "GEO", "268", "282"),
        Country(u"Germany", "DE", "DEU", "276", "262"),
        Country(u"Ghana", "GH", "GHA", "288", "620"),
        Country(u"Gibraltar", "GI", "GIB", "292", "266"),
        Country(u"Greece", "GR", "GRC", "300", "202"),
        Country(u"Greenland", "GL", "GRL", "304", "290"),
        Country(u"Grenada", "GD", "GRD", "308", "352"),
        Country(u"Guadeloupe", "GP", "GLP", "312", "340"),
        Country(u"Guam", "GU", "GUM", "316", ("310", "311")),
        Country(u"Guatemala", "GT", "GTM", "320", "704"),
        Country(u"Guernsey", "GG", "GGY", "831", "234"),
        Country(u"Guinea", "GN", "GIN", "324", "611"),
        Country(u"Guinea-Bissau", "GW", "GNB", "624", "632"),
        Country(u"Guyana", "GY", "GUY", "328", "738"),
        Country(u"Haiti", "HT", "HTI", "332", "372"),
        Country(u"Heard Island and McDonald Islands", "HM", "HMD", "334", "708"),
        Country(u"Holy See (Vatican City State)", "VA", "VAT", "336", "225"),
        Country(u"Honduras", "HN", "HND", "340", None),
        Country(u"Hong Kong", "HK", "HKG", "344", "454"),
        Country(u"Hungary", "HU", "HUN", "348", "216"),
        Country(u"Iceland", "IS", "ISL", "352", "274"),
        Country(u"India", "IN", "IND", "356", ("404", "405")),
        Country(u"Indonesia", "ID", "IDN", "360", "510"),
        Country(u"Iran, Islamic Republic of", "IR", "IRN", "364", "432"),
        Country(u"Iraq", "IQ", "IRQ", "368", "418"),
        Country(u"Ireland", "IE", "IRL", "372", "272"),
        Country(u"Isle of Man", "IM", "IMN", "833", "234"),
        Country(u"Israel", "IL", "ISR", "376", "425"),
        Country(u"Italy", "IT", "ITA", "380", "222"),
        Country(u"Jamaica", "JM", "JAM", "388", "338"),
        Country(u"Japan", "JP", "JPN", "392", "440"),
        Country(u"Jersey", "JE", "JEY", "832", "234"),
        Country(u"Jordan", "JO", "JOR", "400", "416"),
        Country(u"Kazakhstan", "KZ", "KAZ", "398", "401"),
        Country(u"Kenya", "KE", "KEN", "404", "639"),
        Country(u"Kiribati", "KI", "KIR", "296", "545"),
        Country(u"Korea, Democratic People's Republic of", "KP", "PRK", "408", None),
        Country(u"Korea, Republic of", "KR", "KOR", "410", "450"),
        Country(u"Kuwait", "KW", "KWT", "414", "419"),
        Country(u"Kyrgyzstan", "KG", "KGZ", "417", "437"),
        Country(u"Lao People's Democratic Republic", "LA", "LAO", "418", "457"),
        Country(u"Latvia", "LV", "LVA", "428", "247"),
        Country(u"Lebanon", "LB", "LBN", "422", "415"),
        Country(u"Lesotho", "LS", "LSO", "426", "651"),
        Country(u"Liberia", "LR", "LBR", "430", "618"),
        Country(u"Libya", "LY", "LBY", "434", "606"),
        Country(u"Liechtenstein", "LI", "LIE", "438", "295"),
        Country(u"Lithuania", "LT", "LTU", "440", "246"),
        Country(u"Luxembourg", "LU", "LUX", "442", "270"),
        Country(u"Macao", "MO", "MAC", "446", "455"),
        Country(u"Macedonia, the former Yugoslav Republic of", "MK", "MKD", "807", "294"),
        Country(u"Madagascar", "MG", "MDG", "450", "646"),
        Country(u"Malawi", "MW", "MWI", "454", "650"),
        Country(u"Malaysia", "MY", "MYS", "458", "502"),
        Country(u"Maldives", "MV", "MDV", "462", "472"),
        Country(u"Mali", "ML", "MLI", "466", "610"),
        Country(u"Malta", "MT", "MLT", "470", "278"),
        Country(u"Marshall Islands", "MH", "MHL", "584", "551"),
        Country(u"Martinique", "MQ", "MTQ", "474", "340"),
        Country(u"Mauritania", "MR", "MRT", "478", "609"),
        Country(u"Mauritius", "MU", "MUS", "480", "617"),
        Country(u"Mayotte", "YT", "MYT", "175", None),
        Country(u"Mexico", "MX", "MEX", "484", "334"),
        Country(u"Micronesia, Federated States of", "FM", "FSM", "583", "550"),
        Country(u"Moldova, Republic of", "MD", "MDA", "498", "259"),
        Country(u"Monaco", "MC", "MCO", "492", "212"),
        Country(u"Mongolia", "MN", "MNG", "496", "428"),
        Country(u"Montenegro", "ME", "MNE", "499", "297"),
        Country(u"Montserrat", "MS", "MSR", "500", "354"),
        Country(u"Morocco", "MA", "MAR", "504", "604"),
        Country(u"Mozambique", "MZ", "MOZ", "508", "643"),
        Country(u"Myanmar", "MM", "MMR", "104", "414"),
        Country(u"Namibia", "NA", "NAM", "516", "649"),
        Country(u"Nauru", "NR", "NRU", "520", "536"),
        Country(u"Nepal", "NP", "NPL", "524", "429"),
        Country(u"Netherlands", "NL", "NLD", "528", "204"),
        Country(u"New Caledonia", "NC", "NCL", "540", "546"),
        Country(u"New Zealand", "NZ", "NZL", "554", "530"),
        Country(u"Nicaragua", "NI", "NIC", "558", "710"),
        Country(u"Niger", "NE", "NER", "562", "614"),
        Country(u"Nigeria", "NG", "NGA", "566", "621"),
        Country(u"Niue", "NU", "NIU", "570", "555"),
        Country(u"Norfolk Island", "NF", "NFK", "574", "505"),
        Country(u"Northern Mariana Islands", "MP", "MNP", "580", None),
        Country(u"Norway", "NO", "NOR", "578", "242"),
        Country(u"Oman", "OM", "OMN", "512", "422"),
        Country(u"Pakistan", "PK", "PAK", "586", "410"),
        Country(u"Palau", "PW", "PLW", "585", "552"),
        Country(u"Palestine, State of", "PS", "PSE", "275", "425"),
        Country(u"Panama", "PA", "PAN", "591", "714"),
        Country(u"Papua New Guinea", "PG", "PNG", "598", "537"),
        Country(u"Paraguay", "PY", "PRY", "600", "744"),
        Country(u"Peru", "PE", "PER", "604", "716"),
        Country(u"Philippines", "PH", "PHL", "608", "515"),
        Country(u"Pitcairn", "PN", "PCN", "612", None),
        Country(u"Poland", "PL", "POL", "616", "260"),
        Country(u"Portugal", "PT", "PRT", "620", "268"),
        Country(u"Puerto Rico", "PR", "PRI", "630", "330"),
        Country(u"Qatar", "QA", "QAT", "634", "427"),
        Country(u"Réunion", "RE", "REU", "638", "647"),
        Country(u"Romania", "RO", "ROU", "642", "226"),
        Country(u"Russian Federation", "RU", "RUS", "643", "250"),
        Country(u"Rwanda", "RW", "RWA", "646", "635"),
        Country(u"Saint Barthélemy", "BL", "BLM", "652", None),
        Country(u"Saint Helena, Ascension and Tristan da Cunha",
                "SH", "SHN", "654", None),
        Country(u"Saint Kitts and Nevis", "KN", "KNA", "659", "356"),
        Country(u"Saint Lucia", "LC", "LCA", "662", "358"),
        Country(u"Saint Martin (French part)", "MF", "MAF", "663", None),
        Country(u"Saint Pierre and Miquelon", "PM", "SPM", "666", "308"),
        Country(u"Saint Vincent and the Grenadines", "VC", "VCT", "670", "360"),
        Country(u"Samoa", "WS", "WSM", "882", "549"),
        Country(u"San Marino", "SM", "SMR", "674", "292"),
        Country(u"Sao Tome and Principe", "ST", "STP", "678", "626"),
        Country(u"Saudi Arabia", "SA", "SAU", "682", "420"),
        Country(u"Senegal", "SN", "SEN", "686", "608"),
        Country(u"Serbia", "RS", "SRB", "688", "220"),
        Country(u"Seychelles", "SC", "SYC", "690", "633"),
        Country(u"Sierra Leone", "SL", "SLE", "694", "619"),
        Country(u"Singapore", "SG", "SGP", "702", "525"),
        Country(u"Sint Maarten (Dutch part)", "SX", "SXM", "534", None),
        Country(u"Slovakia", "SK", "SVK", "703", "231"),
        Country(u"Slovenia", "SI", "SVN", "705", "293"),
        Country(u"Solomon Islands", "SB", "SLB", "090", "540"),
        Country(u"Somalia", "SO", "SOM", "706", "637"),
        Country(u"South Africa", "ZA", "ZAF", "710", "655"),
        Country(u"South Georgia and the South Sandwich Islands",
                "GS", "SGS", "239", None),
        Country(u"South Sudan", "SS", "SSD", "728", "659"),
        Country(u"Spain", "ES", "ESP", "724", "214"),
        Country(u"Sri Lanka", "LK", "LKA", "144", "13"),
        Country(u"Sudan", "SD", "SDN", "729", "634"),
        Country(u"Suriname", "SR", "SUR", "740", "746"),
        Country(u"Svalbard and Jan Mayen", "SJ", "SJM", "744", None),
        Country(u"Swaziland", "SZ", "SWZ", "748", "653"),
        Country(u"Sweden", "SE", "SWE", "752", "240"),
        Country(u"Switzerland", "CH", "CHE", "756", "228"),
        Country(u"Syrian Arab Republic", "SY", "SYR", "760", "417"),
        Country(u"Taiwan, Province of China", "TW", "TWN", "158", "466"),
        Country(u"Tajikistan", "TJ", "TJK", "762", "436"),
        Country(u"Tanzania, United Republic of", "TZ", "TZA", "834", "640"),
        Country(u"Thailand", "TH", "THA", "764", "520"),
        Country(u"Timor-Leste", "TL", "TLS", "626", None),
        Country(u"Togo", "TG", "TGO", "768", "615"),
        Country(u"Tokelau", "TK", "TKL", "772", None),
        Country(u"Tonga", "TO", "TON", "776", "539"),
        Country(u"Trinidad and Tobago", "TT", "TTO", "780", "374"),
        Country(u"Tunisia", "TN", "TUN", "788", "605"),
        Country(u"Turkey", "TR", "TUR", "792", "286"),
        Country(u"Turkmenistan", "TM", "TKM", "795", "438"),
        Country(u"Turks and Caicos Islands", "TC", "TCA", "796", ("338", "376")),
        Country(u"Tuvalu", "TV", "TUV", "798", "553"),
        Country(u"Uganda", "UG", "UGA", "800", "641"),
        Country(u"Ukraine", "UA", "UKR", "804", "255"),
        Country(u"United Arab Emirates", "AE", "ARE", "784", "424"),
        Country(u"United Kingdom", "GB", "GBR", "826", ("234", "235")),
        Country(u"United States", "US", "USA", "840", ("310", "311", "313", "316")),
        Country(u"United States Minor Outlying Islands", "UM", "UMI", "581", None),
        Country(u"Uruguay", "UY", "URY", "858", "748"),
        Country(u"Uzbekistan", "UZ", "UZB", "860", "434"),
        Country(u"Vanuatu", "VU", "VUT", "548", "541"),
        Country(u"Venezuela, Bolivarian Republic of", "VE", "VEN", "862", "734"),
        Country(u"Viet Nam", "VN", "VNM", "704", "452"),
        Country(u"Virgin Islands, British", "VG", "VGB", "092", None),
        Country(u"Virgin Islands, U.S.", "VI", "VIR", "850", None),
        Country(u"Wallis and Futuna", "WF", "WLF", "876", None),
        Country(u"Western Sahara", "EH", "ESH", "732", None),
        Country(u"Yemen", "YE", "YEM", "887", "412"),
        Country(u"Zambia", "ZM", "ZMB", "894", "645"),
        Country(u"Zimbabwe", "ZW", "ZWE", "716", "648")
    ]


def _operators():
    # Last updated from Wikipedia, April 19, 2014
    return [
        Operator("001", "01", "TEST", u"Test Network"),
        Operator("289", "67", "Aquafon", u"Aquafon JSC"),
        Operator("289", "68", "A-Mobile", u"A-Mobile LLC"),
        Operator("289", "88", "A-Mobile", u"A-Mobile LLC"),
        Operator("412", "01", "AWCC", u"AWCC"),
        Operator("412", "20", "Roshan", u"Roshan"),
        Operator("412", "40", "MTN", u"MTN"),
        Operator("412", "50", "Etisalat", u"Etisalat"),
        Operator("412", "55", "WASEL", u"WASEL"),
        Operator("276", "01", "AMC", u"Albanian Mobile Communications"),
        Operator("276", "02", "Vodafone", u"Vodafone Albania"),
        Operator("276", "03", "Eagle Mobile", u"Eagle Mobile"),
        Operator("276", "04", "Plus Communication", u"Plus Communication"),
        Operator("603", "01", "Mobilis", u"ATM Mobilis"),
        Operator("603", "02", "Djezzy", u"Djezzy"),
        Operator("603", "03", "Ooredoo", u"Ooredoo"),
        Operator("544", "11", "Bluesky", u"Bluesky"),
        Operator("213", "03", "Mobiland", u"Servei De Tele. DAndorra"),
        Operator("631", "02", "UNITEL", u"UNITEL"),
        Operator("631", "04", "MOVICEL", u"MOVICEL"),
        Operator("365", "010", "", u"Weblinks Limited"),
        Operator("365", "840", "LIME", u"Cable &amp; Wireless"),
        Operator("344", "030", "APUA", u"Antigua Public Utilities Authority"),
        Operator("344", "050", "Digicel", u"Digicel"),
        Operator("344", "920", "LIME", u"LIME"),
        Operator("722", "010", "Movistar", u"Movistar"),
        Operator("722", "020", "Nextel", u"NII Holdings"),
        Operator("722", "040", "Globalstar", u"TE.SA.M Argentina S.A."),
        Operator("722", "070", "Movistar", u"Movistar"),
        Operator("722", "315", "Claro", u"Claro"),
        Operator("722", "320", "Claro", u"Claro"),
        Operator("722", "330", "Claro", u"Claro"),
        Operator("722", "340", "Personal", u"Telecom Personal S.A."),
        Operator("722", "350", "PORT-HABLE", u"Hutchison Telecommunications Argentina S.A."),
        Operator("283", "01", "Beeline", u"Beeline"),
        Operator("283", "04", "Karabakh Telecom", u"Karabakh Telecom"),
        Operator("283", "05", "VivaCell-MTS", u"VivaCell-MTS"),
        Operator("283", "10", "Orange", u"Orange"),
        Operator("363", "01", "SETAR", u"SETAR"),
        Operator("363", "02", "Digicel", u"Digicel"),
        Operator("505", "01", "Telstra", u"Telstra"),
        Operator("505", "02", "Optus", u"Optus"),
        Operator("505", "03", "Vodafone", u"Vodafone"),
        Operator("505", "04", "", u"Department of Defence"),
        Operator("505", "05", "Ozitel", u""),
        Operator("505", "06", "3", u"3"),
        Operator("505", "08", "One.Tel", u"One.Tel"),
        Operator("505", "09", "Airnet", u""),
        Operator("505", "10", "Norfolk Is.", u"Norfolk Telecom"),
        Operator("505", "12", "3", u"3"),
        Operator("505", "13", "Railcorp", u"Railcorp"),
        Operator("505", "14", "AAPT", u"AAPT"),
        Operator("505", "15", "3GIS", u""),
        Operator("505", "16", "Victorian Rail Track", u"Victorian Rail Track"),
        Operator("505", "18", "Pactel", u"Pactel International Pty Ltd"),
        Operator("505", "19", "Lycamobile Pty Ltd", u""),
        Operator("505", "21", "SOUL", u"SOUL"),
        Operator("505", "23", "", u"Challenge Networks Pty. Ltd."),
        Operator("505", "24", "Advance Communications Technologies Pty. Ltd.", u""),
        Operator("505", "26", "", u"Dialogue Communications Pty. Ltd."),
        Operator("505", "27", "", u"Nexium Telecommunications"),
        Operator("505", "38", "Crazy John's", u"Crazy John's"),
        Operator("505", "62", "NBN", u"NBN"),
        Operator("505", "68", "NBN", u"NBN"),
        Operator("505", "71", "Telstra", u"Telstra"),
        Operator("505", "72", "Telstra", u"Telstra"),
        Operator("505", "88", "Localstar Holding Pty. Ltd.", u""),
        Operator("505", "90", "Optus", u"Optus"),
        Operator("505", "99", "One.Tel", u"One.Tel"),
        Operator("232", "01", "A1 TA", u"A1 Telekom Austria"),
        Operator("232", "02", "", u"A1 Telekom Austria"),
        Operator("232", "03", "T-Mobile AT", u"T-Mobile Austria"),
        Operator("232", "05", "Orange AT", u"Hutchison Drei Austria"),
        Operator("232", "07", "tele.ring", u"tele.ring"),
        Operator("232", "08", "", u""),
        Operator("232", "09", "Tele2Mobil", u"A1 Telekom Austria"),
        Operator("232", "10", "3AT", u"Hutchison Drei Austria"),
        Operator("232", "11", "bob", u"bob"),
        Operator("232", "12", "yesss!", u"yesss!"),
        Operator("232", "13", "", u""),
        Operator("232", "14", "", u"Hutchison Drei Austria"),
        Operator("232", "15", "Vectone", u"Vectone"),
        Operator("232", "16", "", u"Hutchison Drei Austria"),
        Operator("232", "91", "GSM-R A", u"ÖBB"),
        Operator("400", "01", "Azercell", u"Azercell"),
        Operator("400", "02", "Bakcell", u"Bakcell"),
        Operator("400", "03", "FONEX", u"CATEL"),
        Operator("400", "04", "Nar Mobile", u"Nar Mobile"),
        Operator("364", "39", "BaTelCo", u"The Bahamas Telecommunications Company Ltd"),
        Operator("426", "01", "Batelco", u"Batelco"),
        Operator("426", "02", "zain BH", u"zain BH"),
        Operator("426", "04", "VIVA Bahrain", u"Viva Bahrain"),
        Operator("426", "05", "Batelco", u"Batelco"),
        Operator("470", "01", "Grameenphone", u"Grameenphone"),
        Operator("470", "02", "Robi", u"Robi"),
        Operator("470", "03", "Banglalink", u"Banglalink"),
        Operator("470", "04", "TeleTalk", u"TeleTalk"),
        Operator("470", "05", "Citycell", u"Citycell"),
        Operator("470", "06", "Beeong3GWarid Telekom[citation needed]", u"Beeong3G"),
        Operator("470", "07", "Airtel", u"Airtel"),
        Operator("342", "600", "LIME", u"LIME"),
        Operator("342", "750", "Digicel", u"Digicel"),
        Operator("342", "820", "", u"Sunbeach Communications"),
        Operator("257", "01", "velcom", u"velcom"),
        Operator("257", "02", "MTS", u"Mobile TeleSystems"),
        Operator("257", "03", "DIALLOG", u"DIALLOG"),
        Operator("257", "04", "life:)", u"life:)"),
        Operator("257", "501", "BelCel JV", u""),
        Operator("206", "01", "Proximus", u"Proximus"),
        Operator("206", "05", "Telenet", u"Telenet"),
        Operator("206", "10", "Mobistar", u"Mobistar"),
        Operator("206", "20", "BASE", u"BASE"),
        Operator("702", "67", "DigiCell", u"Belize Telemedia Ltd. (BTL)"),
        Operator("702", "99", "Smart", u"SpeedNet Communications Limited"),
        Operator("616", "01", "Libercom", u"Benin Telecoms Mobile"),
        Operator("616", "02", "Moov", u"Telecel Benin"),
        Operator("616", "03", "MTN", u"MTN"),
        Operator("616", "04", "BBCOM", u"Bell Benin Communications"),
        Operator("616", "04", "BLK", u"BLK"),
        Operator("616", "05", "Glo", u"Glo"),
        Operator("350", "01", "Digicel Bermuda", u"Telecommunications (Bermuda &amp; West Indies) Ltd"),
        Operator("350", "02", "Mobility", u"M3 Wireless"),
        Operator("338", "050", "Digicel Bermuda", u""),
        Operator("310", "59", "Cellular One", u""),
        Operator("402", "11", "B-Mobile", u"B-Mobile / Bhutan Telecom Ltd."),
        Operator("402", "77", "TashiCell", u"Tashi InfoComm Limited"),
        Operator("736", "01", "Nuevatel", u"Nuevatel PCS De Bolivia SA"),
        Operator("736", "02", "Entel", u"Entel SA"),
        Operator("736", "03", "Tigo", u"Telefónica Celular De Bolivia S.A"),
        Operator("218", "03", "HT-ERONET", u"HT-ERONET"),
        Operator("218", "05", "m:tel", u"RS Telecommunications JSC Banja Luka"),
        Operator("218", "90", "BH Mobile", u"BH Telecom"),
        Operator("652", "01", "Mascom", u"Mascom Wireless (Pty) Limited"),
        Operator("652", "02", "Orange", u"Orange (Botswana) Pty Limited"),
        Operator("652", "04", "BTC Mobile", u"Botswana Telecommunications Corporation"),
        Operator("724", "00", "Nextel", u"NII Holdings, Inc."),
        Operator("724", "02", "TIM", u"Telecom Italia Mobile"),
        Operator("724", "03", "TIM", u"Telecom Italia Mobile"),
        Operator("724", "04", "TIM", u"Telecom Italia Mobile"),
        Operator("724", "05", "Claro BR", u"Claro"),
        Operator("724", "055", "Sercomtel", u"Sercomtel Celular"),
        Operator("724", "06", "Vivo", u"Vivo S.A."),
        Operator("724", "10", "Vivo", u"Vivo S.A."),
        Operator("724", "11", "Vivo", u"Vivo S.A."),
        Operator("724", "15", "CTBC Celular", u"CTBC Celular S.A."),
        Operator("724", "16", "Brasil Telecom GSM", u"Brasil Telecom GSM"),
        Operator("724", "23", "Vivo", u"Vivo S.A."),
        Operator("724", "31", "Oi", u"Oi"),
        Operator("724", "32", "CTBC Celular", u"CTBC Celular S.A."),
        Operator("724", "33", "CTBC Celular", u"CTBC Celular S.A."),
        Operator("724", "34", "CTBC Celular", u"CTBC Celular S.A."),
        Operator("724", "39", "Nextel", u"NII Holdings, Inc."),
        Operator("348", "170", "LIME", u"LIME"),
        Operator("348", "570", "CCT Boatphone", u"Caribbean Cellular Telephone"),
        Operator("348", "770", "Digicel", u"Digicel"),
        Operator("528", "01", "", u"Jabatan Telekom Brunei"),
        Operator("528", "02", "B-Mobile", u"B-Mobile"),
        Operator("528", "11", "DSTCom", u"Data Stream Technology"),
        Operator("284", "01", "M-Tel", u"Mobiltel"),
        Operator("284", "03", "Vivacom", u"BTC"),
        Operator("284", "05", "GLOBUL", u"GLOBUL"),
        Operator("284", "07", "НКЖИ", u"НАЦИОНАЛНА КОМПАНИЯ ЖЕЛЕЗОПЪТНА ИНФРАСТРУКТУРА"),
        Operator("284", "09", "COMPATEL LIMITED", u"COMPATEL LIMITED"),
        Operator("284", "11", "Bulsatcom", u"Undisclosed"),
        Operator("284", "13", "Max Telecom", u"Max Telecom"),
        Operator("613", "01", "Telmob", u"Onatel"),
        Operator("613", "02", "Airtel", u"Airtel"),
        Operator("613", "03", "Telecel Faso", u"Telecel Faso SA"),
        Operator("642", "01", "Spacetel", u"Econet Wireless Burundi PLC"),
        Operator("642", "02", "Tempo", u"Africell PLC"),
        Operator("642", "03", "Onatel", u"Onatel"),
        Operator("642", "07", "Smart Mobile", u"LACELL SU"),
        Operator("642", "08", "HiTs Telecom", u"HiTs Telecom"),
        Operator("642", "82", "Leo", u"Orascom Telecom (a subsidiary of Vimplecom)"),
        Operator("456", "01", "Cellcard", u"The Royal Group"),
        Operator("456", "02", "Smart", u"Smart"),
        Operator("456", "03", "qb", u"Cambodia Advance Communications Co. Ltd"),
        Operator("456", "04", "qb", u"Cambodia Advance Communications Co. Ltd"),
        Operator("456", "05", "Smart", u"Smart"),
        Operator("456", "06", "Smart", u"Smart"),
        Operator("456", "08", "Cellcard", u"The Royal Group"),
        Operator("456", "09", "Beeline", u"Beeline"),
        Operator("456", "11", "Excell", u""),
        Operator("456", "18", "Cellcard", u"The Royal Group"),
        Operator("624", "01", "MTN Cameroon", u"Mobile Telephone Network Cameroon Ltd"),
        Operator("624", "02", "Orange", u"Orange Cameroun S.A."),
        Operator("302", "220", "Telus", u"Telus"),
        Operator("302", "221", "Telus", u"Telus"),
        Operator("302", "222", "Telus", u"Telus"),
        Operator("302", "250", "ALO", u"ALO"),
        Operator("302", "270", "EastLink", u"EastLink"),
        Operator("302", "290", "Airtel Wireless", u"Airtel Wireless"),
        Operator("302", "320", "Mobilicity", u"DAVE Wireless"),
        Operator("302", "340", "Execulink", u"Execulink"),
        Operator("302", "350", "FIRST", u"FIRST Networks Operations"),
        Operator("302", "360", "MiKe", u"Telus Mobility"),
        Operator("302", "361", "Telus", u"Telus"),
        Operator("302", "370", "Fido", u"Fido Solutions(Rogers Wireless)"),
        Operator("302", "380", "DMTS", u"Dryden Mobility"),
        Operator("302", "480", "SSi Connexions", u"SSi Connexions"),
        Operator("302", "490", "WIND Mobile", u"WIND Mobile"),
        Operator("302", "500", "Videotron", u"Videotron"),
        Operator("302", "510", "Videotron", u"Videotron"),
        Operator("302", "530", "Keewatinook Okimakanak Mobile", u"Keewatinook Okimakanak Mobile"),
        Operator("302", "560", "Lynx Mobility", u"Lynx Mobility"),
        Operator("302", "570", "LightSquared", u"LightSquared"),
        Operator("302", "590", "Quadro Communication", u"Quadro Communication"),
        Operator("302", "610", "Bell", u"Bell Mobility and Virgin Mobile Canada"),
        Operator("302", "620", "ICE Wireless", u"ICE Wireless"),
        Operator("302", "630", "Aliant Mobility", u"Aliant Mobility"),
        Operator("302", "640", "Bell", u"Bell Mobility"),
        Operator("302", "652", "", u"BC Tel Mobility (Telus)"),
        Operator("302", "653", "Telus", u"Telus"),
        Operator("302", "655", "MTS", u"MTS Mobility"),
        Operator("302", "656", "TBay", u"Thunder Bay TelephoneMobility"),
        Operator("302", "657", "Telus", u"Telus"),
        Operator("302", "660", "MTS", u"MTS Mobility"),
        Operator("302", "670", "CityTel Mobility", u"CityTel Mobility"),
        Operator("302", "680", "SaskTel", u"SaskTel"),
        Operator("302", "690", "Bell", u"Bell Mobility"),
        Operator("302", "701", "", u"MB Tel Mobility"),
        Operator("302", "702", "", u"MT&amp;T Mobility (Aliant)"),
        Operator("302", "703", "", u"New Tel Mobility (Aliant)"),
        Operator("302", "710", "Globalstar", u""),
        Operator("302", "720", "Rogers Wireless", u"Rogers Wireless"),
        Operator("302", "730", "TerreStar Solutions", u"TerreStar Solutions"),
        Operator("302", "740", "Shaw Telecom G.P.", u"Shaw Telecom G.P."),
        Operator("302", "750", "SaskTel", u"SaskTel"),
        Operator("302", "760", "Public Mobile Inc.", u"Public Mobile Inc."),
        Operator("302", "770", "Rural Com", u"Rural Com"),
        Operator("302", "780", "SaskTel", u"SaskTel"),
        Operator("302", "860", "Telus", u"Telus"),
        Operator("302", "880", "Bell/Telus/SaskTel", u"Bell"),
        Operator("302", "940", "Wightman Telecom", u"Wightman Telecom"),
        Operator("625", "01", "CVMOVEL", u"CVMovel, S.A."),
        Operator("625", "02", "T+", u"T+"),
        Operator("346", "140", "LIME", u"LIME"),
        Operator("346", "050", "Digicel", u"Digicel Cayman Ltd."),
        Operator("623", "01", "CTP", u"Centrafrique Telecom Plus"),
        Operator("623", "02", "TC", u"Telecel Centrafrique"),
        Operator("623", "03", "Orange", u"Orange RCA"),
        Operator("623", "04", "Nationlink", u"Nationlink Telecom RCA"),
        Operator("622", "01", "Airtel", u"Airtel"),
        Operator("622", "02", "Tchad Mobile", u"Orascom Telecom"),
        Operator("622", "02", "Tawali", u"Sotel Chad"),
        Operator("622", "03", "Tigo", u"Millicom"),
        Operator("622", "04", "Salam", u"Sotel Mobile"),
        Operator("730", "01", "entel", u"Entel PCS Telecomunicaciones S.A."),
        Operator("730", "02", "movistar", u"Telefónica Móvil de Chile"),
        Operator("730", "03", "Claro", u"Claro Chile S.A."),
        Operator("730", "04", "Nextel", u"Centennial Cayman Corp. Chile"),
        Operator("730", "07", "Virgin Mobile", u"Virgin Mobile"),
        Operator("730", "08", "VTR Móvil", u"VTR S.A."),
        Operator("730", "09", "Nextel", u"Centennial Cayman Corp. Chile"),
        Operator("730", "10", "entel", u"Entel Telefonía Móvil S.A."),
        Operator("730", "99", "Will", u"WILL Telefonía"),
        Operator("460", "00", "China Mobile", u"China Mobile"),
        Operator("460", "01", "China Unicom", u"China Unicom"),
        Operator("460", "02", "China Mobile", u"China Mobile"),
        Operator("460", "03", "China Telecom", u"China Telecom"),
        Operator("460", "05", "China Telecom", u"China Telecom"),
        Operator("460", "06", "China Unicom", u"China Unicom"),
        Operator("460", "07", "China Mobile", u"China Mobile"),
        Operator("460", "20", "China Tietong", u"China Tietong"),
        Operator("732", "001", "", u"Colombia Telecomunicaciones S.A."),
        Operator("732", "002", "Edatel", u"Edatel S.A."),
        Operator("732", "101", "Claro", u"Claro(Comcel)"),
        Operator("732", "102", "movistar", u"movistar"),
        Operator("732", "103", "Tigo", u"Colombia Móvil"),
        Operator("732", "111", "Tigo", u"Colombia Móvil"),
        Operator("732", "123", "movistar", u"movistar"),
        Operator("732", "130", "AVANTEL", u"Avantel S.A.S"),
        Operator("732", "99", "EMCALI", u"EMCALI"),
        Operator("654", "01", "", u"HURI - SNPT"),
        Operator("629", "01", "Airtel", u"Airtel"),
        Operator("629", "07", "", u"Warid Telecom"),
        Operator("629", "10", "Libertis Telecom", u"MTN CONGO S.A"),
        Operator("548", "01", "", u"Telecom Cook"),
        Operator("712", "01", "Kolbi ICE", u"Instituto Costarricense de Electricidad"),
        Operator("712", "017", "fullmóvil", u"full"),
        Operator("712", "02", "Kolbi ICE", u"Instituto Costarricense de Electricidad"),
        Operator("712", "03", "Claro", u"Claro CR Telecomunicaciones"),
        Operator("712", "04", "movistar", u"Telefónica Móviles Costa Rica"),
        Operator("219", "01", "T-Mobile", u"T-MobileCroatia"),
        Operator("219", "02", "Tele2", u"Tele2"),
        Operator("219", "10", "Vip", u"Vipnet"),
        Operator("368", "01", "CUBACEL", u"Empresa de Telecomunicaciones de Cuba, SA"),
        Operator("280", "01", "Cytamobile-Vodafone", u"Cyprus Telecommunications Auth"),
        Operator("280", "10", "MTN", u"Areeba Ltd"),
        Operator("280", "20", "PrimeTel", u"PrimeTel PLC"),
        Operator("230", "01", "T-Mobile", u"T-MobileCzech Republic"),
        Operator("230", "02", "O2", u"2"),
        Operator("230", "03", "Vodafone", u"Vodafone Czech Republic"),
        Operator("230", "04", "U:fon", u"Air Telecom a. s."),
        Operator("230", "05", "", u"TRAVEL TELEKOMMUNIKATION, s.r.o."),
        Operator("230", "06", "", u"OSNO TELECOMUNICATION, s.r.o."),
        Operator("230", "07", "", u"ASTELNET, s.r.o."),
        Operator("230", "98", "", u"Správa železniční dopravní cesty, s.o."),
        Operator("230", "99", "Vodafone", u"Vodafone Czech Republic"),
        Operator("630", "01", "Vodacom", u"Vodacom Congo RDC sprl"),
        Operator("630", "02", "groupe bahati", u"groupe bahati"),
        Operator("630", "04", "", u"Cellco"),
        Operator("630", "05", "Supercell", u"Supercell SPRL"),
        Operator("630", "10", "Libertis Telecom", u""),
        Operator("630", "86", "France telecom", u"orange.TM"),
        Operator("630", "89", "TigoDRC Sait Telecom", u"Tigo"),
        Operator("630", "992", "lintel holding", u"Africell RDC sprl"),
        Operator("238", "01", "TDC", u"TDC A/S"),
        Operator("238", "02", "Telenor", u"Telenor"),
        Operator("238", "03", "End2End", u"MIGway A/S"),
        Operator("238", "05", "", u"ApS KBUS"),
        Operator("238", "06", "3", u"3"),
        Operator("238", "07", "", u"Barablu Mobile Ltd."),
        Operator("238", "08", "Nordisk Mobiltelefon", u""),
        Operator("238", "09", "", u"Dansk Beredskabskommunikation A/S"),
        Operator("238", "10", "TDC", u"TDC A/S"),
        Operator("238", "11", "", u"Dansk Beredskabskommunikation A/S"),
        Operator("238", "12", "", u"Lycamobile Denmark Ltd"),
        Operator("238", "20", "Telia", u"Telia"),
        Operator("238", "23", "GSM-R DK", u"Banedanmark"),
        Operator("238", "30", "Telia", u"Telia"),
        Operator("238", "40", "", u"Ericsson Danmark A/S"),
        Operator("238", "77", "Telenor", u"Telenor"),
        Operator("638", "01", "Evatis", u"Djibouti Telecom SA"),
        Operator("366", "020", "Digicel", u"Digicel"),
        Operator("366", "110", "", u"Cable &amp; Wireless"),
        Operator("370", "01", "Orange", u"Orange Dominicana"),
        Operator("370", "02", "Claro", u"Compañía Dominicana de Teléfonos, C por"),
        Operator("370", "03", "Tricom", u"Tricom S.A."),
        Operator("370", "04", "Viva", u"Trilogy Dominicana, S.A."),
        Operator("514", "01", "Telin Telkomcel", u"PT Telekomunikasi Indonesia International"),
        Operator("514", "02", "", u"Timor Telecom"),
        Operator("514", "03", "", u"Viettel Timor-Leste"),
        Operator("740", "00", "Movistar", u"Movistar"),
        Operator("740", "01", "Claro", u"CONECEL S.A."),
        Operator("740", "02", "CNT Mobile", u"CNT Mobile"),
        Operator("602", "01", "Mobinil", u"Mobinil"),
        Operator("602", "02", "Vodafone", u"Vodafone Egypt"),
        Operator("602", "03", "Etisalat", u"Etisalat Egypt"),
        Operator("706", "01", "CTE Telecom Personal,Claro", u"Claro"),
        Operator("706", "02", "digicel", u"digicel"),
        Operator("706", "03", "Tigo", u"Tigo"),
        Operator("706", "04", "movistar", u"movistar"),
        Operator("627", "01", "Orange GQ", u"GETESA"),
        Operator("627", "03", "Hits GQ", u"HiTs EG.SA"),
        Operator("657", "01", "Eritel", u"Eritrea Telecommunications Services Corporation"),
        Operator("248", "01", "EMT", u"EMT"),
        Operator("248", "02", "Elisa", u"Elisa"),
        Operator("248", "03", "Tele 2", u"Tele 2"),
        Operator("248", "04", "", u"OY Top Connect"),
        Operator("248", "05", "", u"AS Bravocom Mobiil"),
        Operator("248", "06", "", u"Progroup Holding"),
        Operator("248", "08", "VIVEX", u"VIVEX OU"),
        Operator("636", "011", "ETH-MTN", u"Ethio Telecom"),
        Operator("288", "01", "Faroese Telecom", u"Faroese Telecom"),
        Operator("288", "02", "Vodafone", u"Vodafone Faroe Islands"),
        Operator("542", "01", "Vodafone", u"Vodafone Fiji"),
        Operator("542", "02", "Digicel", u"Digicel Fiji"),
        Operator("244", "03", "DNA", u"DNA Oy"),
        Operator("244", "04", "AINA", u"DNA Oy/Aina Oyj"),
        Operator("244", "05", "Elisa", u"Elisa Oyj"),
        Operator("244", "07", "Nokia", u"Nokia"),
        Operator("244", "08", "Nokia", u"Nokia"),
        Operator("244", "09", "Finnet Group /Nokia Solutions and Networks", u"Nokia Solutions and Networks"),
        Operator("244", "10", "TDC", u"TDC Oy"),
        Operator("244", "11", "Vectone Mobile", u"Vectone Mobile"),
        Operator("244", "12", "DNA", u"DNA Oy"),
        Operator("244", "13", "DNA", u"DNA Oy"),
        Operator("244", "14", "Ålcom", u"Ålands Telekommunikation Ab"),
        Operator("244", "15", "SAMK", u"Samk Student Test Network"),
        Operator("244", "21", "Saunalahti", u"Saunalahti"),
        Operator("244", "25", "Datame", u"Datame Oy"),
        Operator("244", "26", "Compatel", u"Compatel Ltd"),
        Operator("244", "30", "Vectone Mobile", u"Vectone Mobile"),
        Operator("244", "31", "Ukko Mobile", u"Ukko Mobile Oy"),
        Operator("244", "32", "Voxbone", u"Voxbone"),
        Operator("244", "91", "Sonera", u"Sonera"),
        Operator("208", "01", "Orange", u"Orange"),
        Operator("208", "02", "Orange", u"Orange S.A."),
        Operator("208", "03", "MobiquiThings", u"MobiquiThings"),
        Operator("208", "04", "Sisteer", u"Sisteer"),
        Operator("208", "05", "", u"GlobalstarEurope"),
        Operator("208", "06", "", u"GlobalstarEurope"),
        Operator("208", "07", "", u"GlobalstarEurope"),
        Operator("208", "08", "Completel Mobile", u"Completel Mobile"),
        Operator("208", "09", "SFR", u"SFR"),
        Operator("208", "10", "SFR", u"SFR"),
        Operator("208", "11", "SFR", u"SFR"),
        Operator("208", "13", "SFR", u"SFR"),
        Operator("208", "14", "RFF", u"RFF"),
        Operator("208", "15", "Free Mobile", u"Free Mobile"),
        Operator("208", "16", "Free Mobile", u"Free Mobile"),
        Operator("208", "18", "Orange", u"Orange"),
        Operator("208", "20", "Bouygues", u"Bouygues Telecom"),
        Operator("208", "21", "Bouygues", u"Bouygues Telecom"),
        Operator("208", "22", "Transatel Mobile", u"Transatel"),
        Operator("208", "23", "Virgin Mobile (MVNO)", u"Omea Telecom"),
        Operator("208", "24", "MobiquiThings", u"MobiquiThings"),
        Operator("208", "25", "LycaMobile", u"LycaMobile"),
        Operator("208", "26", "NRJ Mobile (MVNO)", u"NRJ Mobile"),
        Operator("208", "88", "Bouygues", u"Bouygues Telecom"),
        Operator("547", "15", "Vodafone", u"PMT"),
        Operator("547", "20", "Vini", u"Tikiphone SA"),
        Operator("628", "01", "Libertis", u"Gabon Telecom &amp; Libertis S.A."),
        Operator("628", "02", "Moov", u"Atlantique Télécom (Etisalat Group) Gabon S.A."),
        Operator("628", "03", "Airtel", u"Airtel"),
        Operator("628", "04", "Azur", u"USAN Gabon S.A."),
        Operator("607", "01", "Gamcel", u"Gamcel"),
        Operator("607", "02", "Africel", u"Africel"),
        Operator("607", "03", "Comium", u"Comium"),
        Operator("607", "04", "QCell", u"QCell Gambia"),
        Operator("282", "01", "Geocell", u"Geocell"),
        Operator("282", "02", "MagtiCom", u"MagtiCom"),
        Operator("282", "03", "MagtiCom", u"MagtiCom"),
        Operator("282", "04", "Beeline", u"Beeline"),
        Operator("282", "05", "Silknet", u"Silknet"),
        Operator("262", "01", "T-Mobile", u"T-Mobile Deutschland GmbH"),
        Operator("262", "02", "Vodafone", u"Vodafone D2 GmbH"),
        Operator("262", "03", "E-Plus", u"E-Plus Mobilfunk"),
        Operator("262", "04", "Vodafone", u""),
        Operator("262", "05", "E-Plus", u"E-Plus Mobilfunk"),
        Operator("262", "06", "T-Mobile", u""),
        Operator("262", "07", "O2", u"2"),
        Operator("262", "08", "O2", u"2"),
        Operator("262", "09", "Vodafone", u""),
        Operator("262", "10", "", u"Arcor AG &amp; Co"),
        Operator("262", "11", "O2", u"2"),
        Operator("262", "12", "Dolphin Telecom / sipgate", u"sipgate Wireless"),
        Operator("262", "13", "", u"Mobilcom Multimedia"),
        Operator("262", "14", "", u"Group 3G UMTS"),
        Operator("262", "15", "Airdata", u""),
        Operator("262", "16", "Telogic ex. Vistream", u""),
        Operator("262", "20", "OnePhone", u"E-Plus"),
        Operator("262", "42", "CCC Event", u"Chaos Computer Club"),
        Operator("262", "43", "LYCA", u"Lycamobile"),
        Operator("262", "60", "", u"DB Telematik"),
        Operator("262", "76", "", u"Siemens AG"),
        Operator("262", "77", "E-Plus", u""),
        Operator("262", "92", "Nash Technologies", u""),
        Operator("262", "901", "Debitel", u""),
        Operator("620", "01", "MTN", u"MTN Group"),
        Operator("620", "02", "Vodafone", u"Vodafone"),
        Operator("620", "03", "tiGO", u"MillicomGhana"),
        Operator("620", "04", "Expresso", u"Kasapa / Hutchison Telecom"),
        Operator("620", "06", "Airtel", u"Airtel"),
        Operator("620", "07", "Globacom", u"GlobacomGroup"),
        Operator("266", "01", "GibTel", u"Gibtelecom"),
        Operator("266", "06", "CTS Mobile", u"CTS Gibraltar"),
        Operator("266", "09", "Shine", u"Eazitelecom"),
        Operator("202", "01", "Cosmote", u"Cosmote"),
        Operator("202", "05", "Vodafone", u"Vodafone Greece"),
        Operator("202", "09", "Wind", u"Wind Hellas Telecommunications S.A."),
        Operator("202", "10", "Wind", u"Wind Hellas Telecommunications S.A."),
        Operator("290", "01", "", u"TELE Greenland A/S"),
        Operator("352", "030", "Digicel", u"Digicel Grenada Ltd."),
        Operator("352", "110", "Cable &amp; Wireless", u"Cable &amp; Wireless Grenada Ltd."),
        Operator("340", "01", "Orange", u"Orange Caraïbe Mobiles"),
        Operator("340", "02", "Outremer", u"Outremer Telecom"),
        Operator("340", "03", "Telcell", u"Saint Martin et Saint Barthelemy Telcell Sarl"),
        Operator("340", "08", "Dauphin", u"Dauphin Telecom"),
        Operator("340", "20", "Digicel", u"Digicel"),
        Operator("310", "032", "IT&amp;E Wireless", u"IT&amp;E Overseas, Inc"),
        Operator("310", "033", "", u"Guam Telephone Authority"),
        Operator("310", "140", "mPulse", u"GTA Wireless"),
        Operator("311", "250", "i CAN_GSM", u"Wave Runner LLC"),
        Operator("310", "370", "Docomo", u"NTT Docomo Pacific"),
        Operator("310", "470", "Docomo", u"NTT Docomo Pacific"),
        Operator("704", "01", "Claro", u"Telecomunicaciones de Guatemala, S.A."),
        Operator("704", "02", "Tigo", u"Tigo"),
        Operator("704", "03", "movistar", u"movistar"),
        Operator("704", "&#160;?", "digicel", u"digicel"),
        Operator("704", "&#160;?", "RED/INTELFON", u"INTELFON"),
        Operator("234", "03", "Airtel Vodafone", u"Guernsey Airtel Ltd"),
        Operator("234", "50", "Wave Telecom", u"Wave Telecom (JT-Wave)"),
        Operator("234", "55", "Sure Mobile", u"Cable &amp; Wireless Guernsey"),
        Operator("611", "01", "Orange S.A.", u"Orange"),
        Operator("611", "02", "Sotelgui", u"Sotelgui Lagui"),
        Operator("611", "03", "Telecel Guinee", u"INTERCEL Guinée"),
        Operator("611", "04", "MTN", u"Areeba Guinea"),
        Operator("611", "05", "Cellcom", u"Cellcom"),
        Operator("632", "02", "MTN Areeba", u"Spacetel Guiné-Bissau S.A."),
        Operator("632", "03", "Orange", u""),
        Operator("632", "07", "Guinetel", u""),
        Operator("738", "01", "Digicel", u"U-Mobile (Cellular) Inc."),
        Operator("738", "02", "GT&amp;T Cellink Plus", u"Guyana Telephone &amp; Telegraph Co."),
        Operator("372", "01", "Voila", u"Voila"),
        Operator("372", "02", "Digicel", u"Digicel"),
        Operator("372", "03", "Natcom", u"Natcom"),
        Operator("708", "001", "Claro", u"Servicios de Comunicaciones de Honduras S.A. de C.V."),
        Operator("708", "02", "Tigo", u"Celtel /Tigo"),
        Operator("708", "30", "Hondutel", u"Empresa Hondureña de Telecomunicaciones"),
        Operator("708", "40", "DIGICEL", u"Digicel de Honduras"),
        Operator("454", "00", "1O1O / One2Free / New World Mobility", u"CSL Limited"),
        Operator("454", "01", "", u"CITIC Telecom 1616"),
        Operator("454", "02", "", u"CSL Limited"),
        Operator("454", "03", "3", u"3"),
        Operator("454", "04", "3(2G)", u"3"),
        Operator("454", "05", "3(CDMA)", u"3"),
        Operator("454", "06", "SmarTone", u"SmarTone"),
        Operator("454", "07", "", u"China Unicom (Hong Kong) Limited"),
        Operator("454", "08", "Truphone", u"Truphone Limited"),
        Operator("454", "09", "", u"China Motion Telecom"),
        Operator("454", "10", "New World Mobility", u"CSL Limited"),
        Operator("454", "11", "", u"China-Hong Kong Telecom"),
        Operator("454", "12", "CMCC HK", u"China Mobile Hong Kong Company Limited"),
        Operator("454", "13", "CMCC HK", u"China Mobile Hong Kong Company Limited"),
        Operator("454", "14", "", u"Hutchison Telecom"),
        Operator("454", "15", "", u"SmarTone Mobile Communications Limited"),
        Operator("454", "16", "PCCW Mobile(2G)", u"PCCW Mobile"),
        Operator("454", "17", "", u"SmarTone Mobile Communications Limited"),
        Operator("454", "18", "", u"CSL Limited"),
        Operator("454", "19", "PCCW Mobile(3G/4G)", u"PCCW Mobile"),
        Operator("454", "22", "P Plus", u"P Plus Communications"),
        Operator("454", "29", "PCCW Mobile(CDMA)", u"PCCW Mobile"),
        Operator("216", "20", "Telenor", u"Telenor"),
        Operator("216", "30", "T-Mobile", u"T-Mobile"),
        Operator("216", "70", "Vodafone", u"Vodafone"),
        Operator("216", "71", "UPC Hungary", u"UPC Hungary"),
        Operator("274", "01", "Síminn", u"Síminn"),
        Operator("274", "02", "Vodafone", u"Og fjarskipti hf"),
        Operator("274", "03", "Vodafone", u"Vodafone Iceland"),
        Operator("274", "04", "Viking", u"IMC Island ehf"),
        Operator("274", "06", "", u"Núll níu ehf"),
        Operator("274", "07", "IceCell", u"IceCell ehf"),
        Operator("274", "08", "On-waves", u"Iceland Telecom"),
        Operator("274", "11", "Nova", u"Nova ehf"),
        Operator("274", "12", "Tal", u"Tal hf"),
        Operator("404", "01", "Vodafone IN", u"Haryana"),
        Operator("404", "02", "AirTel", u"Punjab"),
        Operator("404", "03", "AirTel", u"Himachal Pradesh"),
        Operator("404", "04", "IDEA", u"Delhi &amp; NCR"),
        Operator("404", "05", "Vodafone IN", u"Gujarat"),
        Operator("404", "07", "IDEA", u"Andhra Pradesh"),
        Operator("404", "09", "Reliance", u"Assam"),
        Operator("404", "10", "AirTel", u"Delhi &amp; NCR"),
        Operator("404", "11", "Vodafone IN", u"Delhi &amp; NCR"),
        Operator("404", "12", "IDEA", u"Haryana"),
        Operator("404", "13", "Vodafone IN", u"Andhra Pradesh"),
        Operator("404", "14", "IDEA", u"Punjab"),
        Operator("404", "15", "Vodafone IN", u"Uttar Pradesh (East)"),
        Operator("404", "16", "Airtel", u"North East"),
        Operator("404", "17", "AIRCEL", u"West Bengal"),
        Operator("404", "18", "Reliance", u"Himachal Pradesh"),
        Operator("404", "19", "IDEA", u"Kerala"),
        Operator("404", "20", "Vodafone IN", u"Mumbai"),
        Operator("404", "21", "Loop Mobile", u"Mumbai"),
        Operator("404", "22", "IDEA", u"Maharashtra &amp; Goa"),
        Operator("404", "24", "IDEA", u"Gujarat"),
        Operator("404", "25", "AIRCEL", u"Bihar"),
        Operator("404", "27", "Vodafone IN", u"Maharashtra &amp; Goa"),
        Operator("404", "28", "AIRCEL", u"Orissa"),
        Operator("404", "29", "AIRCEL", u"Assam"),
        Operator("404", "30", "Vodafone IN", u"Kolkata"),
        Operator("404", "31", "AirTel", u"Kolkata"),
        Operator("404", "34", "CellOne", u"Haryana"),
        Operator("404", "36", "Reliance", u"Bihar &amp; Jharkhand"),
        Operator("404", "37", "Aircel", u"Jammu &amp; Kashmir"),
        Operator("404", "38", "CellOne", u"Assam"),
        Operator("404", "40", "AirTel", u"Chennai"),
        Operator("404", "41", "Aircel", u"Chennai"),
        Operator("404", "42", "Aircel", u"Tamil Nadu"),
        Operator("404", "43", "Vodafone IN", u"Tamil Nadu"),
        Operator("404", "44", "IDEA", u"Karnataka"),
        Operator("404", "45", "Airtel", u"Karnataka"),
        Operator("404", "46", "Vodafone IN", u"Kerala"),
        Operator("404", "48", "Dishnet Wireless", u"Unknown"),
        Operator("404", "49", "Airtel", u"Andhra Pradesh"),
        Operator("404", "50", "Reliance", u"North East"),
        Operator("404", "51", "CellOne", u"Himachal Pradesh"),
        Operator("404", "52", "Reliance", u"Orissa"),
        Operator("404", "53", "CellOne", u"Punjab"),
        Operator("404", "54", "CellOne", u"Uttar Pradesh (West)"),
        Operator("404", "55", "CellOne", u"Uttar Pradesh (East)"),
        Operator("404", "56", "IDEA", u"Uttar Pradesh (West)"),
        Operator("404", "57", "CellOne", u"Gujarat"),
        Operator("404", "58", "CellOne", u"Madhya Pradesh &amp; Chhattisgarh"),
        Operator("404", "59", "CellOne", u"Rajasthan"),
        Operator("404", "60", "Vodafone IN", u"Rajasthan"),
        Operator("404", "62", "CellOne", u"Jammu &amp; Kashmir"),
        Operator("404", "64", "CellOne", u"Chennai"),
        Operator("404", "66", "CellOne", u"Maharashtra &amp; Goa"),
        Operator("404", "67", "Reliance", u"Madhya Pradesh &amp; Chhattisgarh"),
        Operator("404", "68", "DOLPHIN", u"Delhi &amp; NCR"),
        Operator("404", "69", "DOLPHIN", u"Mumbai"),
        Operator("404", "70", "AirTel", u"Rajasthan"),
        Operator("404", "71", "CellOne", u"Karnataka (Bangalore)"),
        Operator("404", "72", "CellOne", u"Kerala"),
        Operator("404", "73", "CellOne", u"Andhra Pradesh"),
        Operator("404", "74", "CellOne", u"West Bengal"),
        Operator("404", "75", "CellOne", u"Bihar"),
        Operator("404", "76", "CellOne", u"Orissa"),
        Operator("404", "77", "CellOne", u"North East"),
        Operator("404", "78", "Idea Cellular Ltd", u"Madhya Pradesh &amp; Chattishgarh"),
        Operator("404", "79", "CellOne", u"Andaman Nicobar"),
        Operator("404", "80", "CellOne", u"Tamil Nadu"),
        Operator("404", "81", "CellOne", u"Kolkata"),
        Operator("404", "82", "Idea", u"Himachal Pradesh"),
        Operator("404", "83", "Reliance", u"Kolkata"),
        Operator("404", "84", "Vodafone IN", u"Chennai"),
        Operator("404", "85", "Reliance", u"West Bengal"),
        Operator("404", "86", "Vodafone IN", u"Karnataka"),
        Operator("404", "87", "IDEA", u"Rajasthan"),
        Operator("404", "88", "Vodafone IN", u"Vodafone Punjab"),
        Operator("404", "89", "Idea", u"Uttar Pradesh (East)"),
        Operator("404", "90", "AirTel", u"Maharashtra"),
        Operator("404", "91", "AIRCEL", u"Kolkata"),
        Operator("404", "92", "AirTel", u"Mumbai"),
        Operator("404", "93", "AirTel", u"Madhya Pradesh"),
        Operator("404", "94", "AirTel", u"Tamil Nadu"),
        Operator("404", "95", "AirTel", u"Kerala"),
        Operator("404", "96", "AirTel", u"Haryana"),
        Operator("404", "97", "AirTel", u"Uttar Pradesh (West)"),
        Operator("404", "98", "AirTel", u"Gujarat"),
        Operator("405", "01", "Reliance", u"Andhra Pradesh"),
        Operator("405", "025", "TATA DOCOMO", u"Andhra Pradesh"),
        Operator("405", "026", "TATA DOCOMO", u"Assam"),
        Operator("405", "027", "TATA DOCOMO", u"Bihar/Jharkhand"),
        Operator("405", "028", "TATA DOCOMO", u"Chennai"),
        Operator("405", "029", "TATA DOCOMO", u"Delhi"),
        Operator("405", "03", "Reliance", u"Bihar"),
        Operator("405", "030", "TATA DOCOMO", u"Gujarat"),
        Operator("405", "031", "TATA DOCOMO", u"Haryana"),
        Operator("405", "032", "TATA DOCOMO", u"Himachal Pradesh"),
        Operator("405", "033", "TATA DOCOMO", u"Jammu &amp; Kashmir"),
        Operator("405", "034", "TATA DOCOMO", u"Karnataka"),
        Operator("405", "035", "TATA DOCOMO", u"Kerala"),
        Operator("405", "036", "TATA DOCOMO", u"Kolkata"),
        Operator("405", "037", "TATA DOCOMO", u"Maharashtra &amp; Goa"),
        Operator("405", "038", "TATA DOCOMO", u"Madhya Pradesh"),
        Operator("405", "039", "TATA DOCOMO", u"Mumbai"),
        Operator("405", "04", "Reliance", u"Chennai"),
        Operator("405", "041", "TATA DOCOMO", u"Orissa"),
        Operator("405", "042", "TATA DOCOMO", u"Punjab"),
        Operator("405", "043", "TATA DOCOMO", u"Rajasthan"),
        Operator("405", "044", "TATA DOCOMO", u"Tamil Nadu including Chennai"),
        Operator("405", "045", "TATA DOCOMO", u"[Uttar Pradesh (E)]"),
        Operator("405", "046", "TATA DOCOMO", u"[Uttar Pradesh (W) &amp; Uttarkhand ]"),
        Operator("405", "047", "TATA DOCOMO", u"[West Bengal]"),
        Operator("405", "05", "Reliance", u"Delhi &amp; NCR"),
        Operator("405", "06", "Reliance", u"Gujarat"),
        Operator("405", "07", "Reliance", u"Haryana"),
        Operator("405", "08", "Reliance", u"Himachal Pradesh"),
        Operator("405", "09", "Reliance", u"Jammu &amp; Kashmir"),
        Operator("405", "10", "Reliance", u"Karnataka"),
        Operator("405", "11", "Reliance", u"Kerala"),
        Operator("405", "12", "Reliance", u"Kolkata"),
        Operator("405", "13", "Reliance", u"Maharashtra &amp; Goa"),
        Operator("405", "14", "Reliance", u"Madhya Pradesh"),
        Operator("405", "15", "Reliance", u"Mumbai"),
        Operator("405", "17", "Reliance", u"Orissa"),
        Operator("405", "18", "Reliance", u"Punjab"),
        Operator("405", "19", "Reliance", u"Rajasthan"),
        Operator("405", "20", "Reliance", u"Tamil Nadu"),
        Operator("405", "21", "Reliance", u"Uttar Pradesh (East)"),
        Operator("405", "22", "Reliance", u"Uttar Pradesh (West)"),
        Operator("405", "23", "Reliance", u"West Bengal"),
        Operator("405", "51", "AirTel", u"West Bengal"),
        Operator("405", "52", "AirTel", u"Bihar &amp; Jharkhand"),
        Operator("405", "53", "AirTel", u"Orissa"),
        Operator("405", "54", "AirTel", u"Uttar Pradesh (East)"),
        Operator("405", "55", "Airtel", u"Jammu &amp; Kashmir"),
        Operator("405", "56", "AirTel", u"Assam"),
        Operator("405", "66", "Vodafone IN", u"Uttar Pradesh (West)"),
        Operator("405", "67", "Vodafone IN", u"West Bengal"),
        Operator("405", "70", "IDEA", u"Bihar &amp; Jharkhand"),
        Operator("405", "750", "Vodafone IN", u"Jammu &amp; Kashmir"),
        Operator("405", "751", "Vodafone IN", u"Assam"),
        Operator("405", "752", "Vodafone IN", u"Bihar &amp; Jharkhand"),
        Operator("405", "753", "Vodafone IN", u"Orissa"),
        Operator("405", "754", "Vodafone IN", u"Himachal Pradesh"),
        Operator("405", "755", "Vodafone IN", u"North East"),
        Operator("405", "756", "Vodafone IN", u"Madhya Pradesh &amp; Chhattisgarh"),
        Operator("405", "799", "IDEA", u"Mumbai"),
        Operator("405", "800", "AIRCEL", u"Delhi &amp; NCR"),
        Operator("405", "801", "AIRCEL", u"Andhra Pradesh"),
        Operator("405", "802", "AIRCEL", u"Gujarat"),
        Operator("405", "803", "AIRCEL", u"Karnataka"),
        Operator("405", "804", "AIRCEL", u"Maharashtra &amp; Goa"),
        Operator("405", "805", "AIRCEL", u"Mumbai"),
        Operator("405", "806", "AIRCEL", u"Rajasthan"),
        Operator("405", "807", "AIRCEL", u"Haryana"),
        Operator("405", "808", "AIRCEL", u"Madhya Pradesh"),
        Operator("405", "809", "AIRCEL", u"Kerala"),
        Operator("405", "810", "AIRCEL", u"Uttar Pradesh (East)"),
        Operator("405", "811", "AIRCEL", u"Uttar Pradesh (West)"),
        Operator("405", "812", "AIRCEL", u"Punjab"),
        Operator("405", "819", "Uninor", u"Uninor"),
        Operator("405", "818", "Uninor", u"Uninor"),
        Operator("405", "820", "Uninor", u"Uninor"),
        Operator("405", "821", "Uninor", u"Uninor"),
        Operator("405", "822", "Uninor", u"Kolkata"),
        Operator("405", "824", "Videocon Datacom", u"Assam"),
        Operator("405", "827", "Videocon Datacom", u"Gujarat"),
        Operator("405", "834", "Videocon Datacom", u"Madhya Pradesh"),
        Operator("405", "844", "Uninor", u"Delhi &amp; NCR"),
        Operator("405", "840", "Jio", u"West Bengal"),
        Operator("405", "845", "IDEA", u"Assam"),
        Operator("405", "846", "IDEA", u"Jammu &amp; Kashmir"),
        Operator("405", "847", "IDEA", u"Karnataka"),
        Operator("405", "848", "IDEA", u"Kolkata"),
        Operator("405", "849", "IDEA", u"North East"),
        Operator("405", "850", "IDEA", u"Orissa"),
        Operator("405", "851", "IDEA", u"Punjab"),
        Operator("405", "852", "IDEA", u"Tamil Nadu"),
        Operator("405", "853", "IDEA", u"West Bengal"),
        Operator("405", "854", "Jio", u"Andra Pradesh"),
        Operator("405", "855", "Jio", u"Assam"),
        Operator("405", "856", "Jio", u"Bihar"),
        Operator("405", "857", "Jio", u"Gujarat"),
        Operator("405", "858", "Jio", u"Haryana"),
        Operator("405", "859", "Jio", u"Himachal Pradesh"),
        Operator("405", "860", "Jio", u"Jammu Kashmir"),
        Operator("405", "861", "Jio", u"Karnataka"),
        Operator("405", "862", "Jio", u"Kerala"),
        Operator("405", "863", "Jio", u"Madhyya Pradesh"),
        Operator("405", "864", "Jio", u"Maharashtra"),
        Operator("405", "865", "Jio", u"North East"),
        Operator("405", "866", "Jio", u"Orissa"),
        Operator("405", "867", "Jio", u"Punjab"),
        Operator("405", "868", "Jio", u"Rajasthan"),
        Operator("405", "869", "Jio", u"Tamil Nadu Chennai"),
        Operator("405", "870", "Jio", u"Uttar Pradesh West"),
        Operator("405", "871", "Jio", u"Uttar Pradesh East"),
        Operator("405", "872", "Jio", u"Delhi"),
        Operator("405", "873", "Jio", u"Kolkatta"),
        Operator("405", "874", "Jio", u"Mumbai"),
        Operator("405", "875", "Uninor", u"Assam"),
        Operator("405", "880", "Uninor", u"Uninor"),
        Operator("405", "881", "S Tel", u"Assam"),
        Operator("405", "908", "IDEA", u"Andhra Pradesh"),
        Operator("405", "909", "IDEA", u"Delhi"),
        Operator("405", "910", "IDEA", u"Haryana"),
        Operator("405", "911", "IDEA", u"Maharashtra"),
        Operator("405", "912", "Etisalat DB(cheers)", u"Andhra Pradesh"),
        Operator("405", "913", "Etisalat DB(cheers)", u"Delhi &amp; NCR"),
        Operator("405", "914", "Etisalat DB(cheers)", u"Gujarat"),
        Operator("405", "917", "Etisalat DB(cheers)", u"Kerala"),
        Operator("405", "927", "Uninor", u"Gujarat"),
        Operator("405", "929", "Uninor", u"Maharashtra"),
        Operator("510", "00", "PSN", u"PT Pasifik Satelit Nusantara (ACeS)"),
        Operator("510", "01", "INDOSAT", u"INDOSAT"),
        Operator("510", "03", "StarOne", u"PT Indosat Tbk"),
        Operator("510", "07", "TelkomFlexi", u"TelkomFlexi"),
        Operator("510", "08", "AXIS", u"AXIS"),
        Operator("510", "09", "SMARTFREN", u"PT Smart Telecom"),
        Operator("510", "10", "Telkomsel", u"Telkomsel"),
        Operator("510", "11", "XL", u"XL"),
        Operator("510", "20", "TELKOMMobile", u"PT Telkom Indonesia Tbk"),
        Operator("510", "21", "IM3", u"IM3"),
        Operator("510", "27", "Ceria", u"PT Sampoerna Telekomunikasi Indonesia"),
        Operator("510", "28", "Fren/Hepi", u"Fren/Hepi"),
        Operator("510", "89", "3", u"3"),
        Operator("510", "99", "Esia", u"Esia"),
        Operator("510", "995", "Komselindo", u"[Komselindo STKB-C \(NMT\)]"),
        Operator("510", "996", "Komselindo", u"[Komselindo STKB-C \(NMT\)]"),
        Operator("432", "11", "IR-MCI", u"Mobile Communications Company of Iran"),
        Operator("432", "14", "TKC", u"KFZO"),
        Operator("432", "19", "MTCE", u"Mobile Telecommunications Company of Esfahan"),
        Operator("432", "20", "Rightel", u""),
        Operator("432", "32", "Taliya", u"Taliya"),
        Operator("432", "35", "Irancell", u"Irancell"),
        Operator("432", "70", "TCI", u"TCI"),
        Operator("432", "93", "Iraphone", u"Iraphone"),
        Operator("418", "05", "Asia Cell", u"Asia Cell"),
        Operator("418", "08", "SanaTel", u""),
        Operator("418", "20", "Zain", u"Zain"),
        Operator("418", "30", "Zain", u"Zain"),
        Operator("418", "40", "Korek", u"Korek"),
        Operator("418", "45", "Mobitel", u"Mobitel"),
        Operator("418", "62", "Itisaluna", u"Itisaluna"),
        Operator("418", "92", "Omnnea", u"Omnnea"),
        Operator("272", "01", "Vodafone", u"Vodafone Ireland"),
        Operator("272", "02", "O2", u"2"),
        Operator("272", "03", "Meteor", u"Meteor"),
        Operator("272", "04", "", u"Access Telecom"),
        Operator("272", "05", "3", u"Hutchison 3GIreland limited"),
        Operator("272", "07", "eMobile", u"eMobile"),
        Operator("272", "09", "", u"Clever Communications"),
        Operator("272", "11", "Tesco Mobile", u"Liffey Telecom"),
        Operator("272", "13", "Lycamobile", u"Lycamobile"),
        Operator("234", "09", "Sure Mobile", u"Cable &amp; Wireless Isle of Man Ltd."),
        Operator("234", "58", "Pronto GSM", u"Manx Telecom"),
        Operator("234", "?", "Cloud 9 Mobile", u"Cloud 9 Mobile Communications PLC"),
        Operator("425", "01", "Orange", u"Partner Communications Company Ltd"),
        Operator("425", "02", "Cellcom", u"Cellcom"),
        Operator("425", "03", "Pelephone", u"Pelephone"),
        Operator("425", "07", "Hot Mobile", u"Hot Mobile"),
        Operator("425", "08", "Golan Telecom", u"Golan Telecom"),
        Operator("425", "14", "Youphone", u"Youphone"),
        Operator("425", "15", "Home Cellular", u"Home Cellular"),
        Operator("425", "16", "Rami Levy", u"Rami Levy"),
        Operator("425", "18", "Cellact Communications", u"Cellact Communications"),
        Operator("222", "01", "TIM", u"Telecom Italia SpA"),
        Operator("222", "02", "Elsacom", u""),
        Operator("222", "04", "Intermatica", u""),
        Operator("222", "05", "Telespazio", u""),
        Operator("222", "07", "Noverca", u""),
        Operator("222", "10", "Vodafone", u"Vodafone Omnitel N.V."),
        Operator("222", "30", "RFI", u"Rete Ferroviaria Italiana"),
        Operator("222", "34", "BT Italia", u"British Telecom Italia"),
        Operator("222", "35", "Lyca Italy", u"Lyca Mobile"),
        Operator("222", "77", "IPSE 2000", u""),
        Operator("222", "88", "Wind", u"Wind Telecomunicazioni SpA"),
        Operator("222", "98", "Blu", u""),
        Operator("222", "99", "3 Italia", u"Hutchison 3G"),
        Operator("612", "01", "", u"Cora de Comstar"),
        Operator("612", "02", "Moov", u""),
        Operator("612", "03", "Orange", u""),
        Operator("612", "04", "KoZ", u"Comium Ivory Coast Inc"),
        Operator("612", "05", "MTN", u""),
        Operator("612", "06", "ORICEL", u"ORICEL"),
        Operator("338", "020", "LIME", u"LIME"),
        Operator("338", "050", "Digicel", u"Digicel"),
        Operator("338", "180", "LIME", u"LIME"),
        Operator("440", "00", "eMobile", u"eMobile"),
        Operator("440", "01", "NTT docomo", u"NTT docomo"),
        Operator("440", "02", "NTT docomo", u"NTT docomo"),
        Operator("440", "03", "NTT docomo", u"NTT docomo"),
        Operator("440", "04", "SoftBank", u"SoftBank"),
        Operator("440", "06", "SoftBank", u"SoftBank"),
        Operator("440", "07", "KDDI", u"KDDI"),
        Operator("440", "08", "KDDI", u"KDDI"),
        Operator("440", "09", "NTT docomo", u"NTT docomo"),
        Operator("440", "10", "NTT docomo", u"NTT docomo"),
        Operator("440", "11", "NTT docomo", u"NTT docomo"),
        Operator("440", "12", "NTT docomo", u"NTT docomo"),
        Operator("440", "13", "NTT docomo", u"NTT docomo"),
        Operator("440", "14", "NTT docomo", u"NTT docomo"),
        Operator("440", "15", "NTT docomo", u"NTT docomo"),
        Operator("440", "16", "NTT docomo", u"NTT docomo"),
        Operator("440", "17", "NTT docomo", u"NTT docomo"),
        Operator("440", "18", "NTT docomo", u"NTT docomo"),
        Operator("440", "19", "NTT docomo", u"NTT docomo"),
        Operator("440", "20", "SoftBank", u"SoftBank"),
        Operator("440", "21", "NTT docomo", u"NTT docomo"),
        Operator("440", "22", "NTT docomo", u"NTT docomo"),
        Operator("440", "23", "NTT docomo", u"NTT docomo"),
        Operator("440", "24", "NTT docomo", u"NTT docomo"),
        Operator("440", "25", "NTT docomo", u"NTT docomo"),
        Operator("440", "26", "NTT docomo", u"NTT docomo"),
        Operator("440", "27", "NTT docomo", u"NTT docomo"),
        Operator("440", "28", "NTT docomo", u"NTT docomo"),
        Operator("440", "29", "NTT docomo", u"NTT docomo"),
        Operator("440", "30", "NTT docomo", u"NTT docomo"),
        Operator("440", "31", "NTT docomo", u"NTT docomo"),
        Operator("440", "32", "NTT docomo", u"NTT docomo"),
        Operator("440", "33", "NTT docomo", u"NTT docomo"),
        Operator("440", "34", "NTT docomo", u"NTT docomo"),
        Operator("440", "35", "NTT DoCoMo", u"NTT DoCoMo"),
        Operator("440", "36", "NTT DoCoMo", u"NTT DoCoMo"),
        Operator("440", "37", "NTT DoCoMo", u"NTT DoCoMo"),
        Operator("440", "38", "NTT DoCoMo", u"NTT DoCoMo"),
        Operator("440", "39", "NTT DoCoMo", u"NTT DoCoMo"),
        Operator("440", "40", "SoftBank", u"SoftBank"),
        Operator("440", "41", "SoftBank", u"SoftBank"),
        Operator("440", "42", "SoftBank", u"SoftBank"),
        Operator("440", "43", "SoftBank", u"SoftBank"),
        Operator("440", "44", "SoftBank", u"SoftBank"),
        Operator("440", "45", "SoftBank", u"SoftBank"),
        Operator("440", "46", "SoftBank", u"SoftBank"),
        Operator("440", "47", "SoftBank", u"SoftBank"),
        Operator("440", "48", "SoftBank", u"SoftBank"),
        Operator("440", "49", "NTT DoCoMo", u"NTT DoCoMo"),
        Operator("440", "50", "KDDI", u"KDDI"),
        Operator("440", "51", "KDDI", u"KDDI"),
        Operator("440", "52", "KDDI", u"KDDI"),
        Operator("440", "53", "KDDI", u"KDDI"),
        Operator("440", "54", "KDDI", u"KDDI"),
        Operator("440", "55", "KDDI", u"KDDI"),
        Operator("440", "56", "KDDI", u"KDDI"),
        Operator("440", "58", "NTT DoCoMo", u"NTT DoCoMo"),
        Operator("440", "60", "NTT DoCoMo", u"NTT DoCoMo"),
        Operator("440", "61", "NTT DoCoMo", u"NTT DoCoMo"),
        Operator("440", "62", "NTT DoCoMo", u"NTT DoCoMo"),
        Operator("440", "63", "NTT DoCoMo", u"NTT DoCoMo"),
        Operator("440", "64", "NTT DoCoMo", u"NTT DoCoMo"),
        Operator("440", "65", "NTT DoCoMo", u"NTT DoCoMo"),
        Operator("440", "66", "NTT DoCoMo", u"NTT DoCoMo"),
        Operator("440", "67", "NTT DoCoMo", u"NTT DoCoMo"),
        Operator("440", "68", "NTT DoCoMo", u"NTT DoCoMo"),
        Operator("440", "69", "NTT DoCoMo", u"NTT DoCoMo"),
        Operator("440", "70", "au", u"au"),
        Operator("440", "71", "KDDI", u"KDDI"),
        Operator("440", "72", "KDDI", u"KDDI"),
        Operator("440", "73", "KDDI", u"KDDI"),
        Operator("440", "74", "KDDI", u"KDDI"),
        Operator("440", "75", "KDDI", u"KDDI"),
        Operator("440", "76", "KDDI", u"KDDI"),
        Operator("440", "77", "KDDI", u"KDDI"),
        Operator("440", "78", "", u"Okinawa Cellular Telephone"),
        Operator("440", "79", "KDDI", u"KDDI"),
        Operator("440", "80", "TU-KA", u"TU-KA"),
        Operator("440", "81", "TU-KA", u"TU-KA"),
        Operator("440", "82", "TU-KA", u"TU-KA"),
        Operator("440", "83", "TU-KA", u"TU-KA"),
        Operator("440", "84", "TU-KA", u"TU-KA"),
        Operator("440", "85", "TU-KA", u"TU-KA"),
        Operator("440", "86", "TU-KA", u"TU-KA"),
        Operator("440", "87", "NTT DoCoMo", u"NTT DoCoMo"),
        Operator("440", "88", "KDDI", u"KDDI"),
        Operator("440", "89", "KDDI", u"KDDI"),
        Operator("440", "90", "SoftBank", u"SoftBank"),
        Operator("440", "92", "SoftBank", u"SoftBank"),
        Operator("440", "93", "SoftBank", u"SoftBank"),
        Operator("440", "94", "SoftBank", u"SoftBank"),
        Operator("440", "95", "SoftBank", u"SoftBank"),
        Operator("440", "96", "SoftBank", u"SoftBank"),
        Operator("440", "97", "SoftBank", u"SoftBank"),
        Operator("440", "98", "SoftBank", u"SoftBank"),
        Operator("440", "99", "NTT DoCoMo", u"NTT DoCoMo"),
        Operator("234", "03", "Airtel Vodafone", u"JERSEY AIRTEL LIMITED"),
        Operator("234", "50", "JT", u"JT Global"),
        Operator("234", "55", "Sure Mobile", u"Cable &amp; Wireless Jersey Limited"),
        Operator("416", "01", "zain JO", u"zain JO"),
        Operator("416", "03", "Umniah", u"Umniah"),
        Operator("416", "74", "XPress Telecom", u"XPress Telecom"),
        Operator("416", "77", "Orange", u"Orange"),
        Operator("401", "01", "Beeline", u"Beeline"),
        Operator("401", "02", "Kcell", u"Kcell"),
        Operator("401", "07", "Dalacom", u"Altel"),
        Operator("401", "08", "Kazakhtelecom", u""),
        Operator("401", "77", "Tele2.kz", u"Tele2.kz"),
        Operator("639", "02", "Safaricom", u"Safaricom"),
        Operator("639", "03", "Airtel", u"Airtel"),
        Operator("639", "05", "yu", u"Econet Wireless Kenya"),
        Operator("639", "07", "Orange Kenya", u"Telkom Kenya"),
        Operator("545", "01", "Kiribati - TSKL", u"Telecom Services Kiribati Ltd"),
        Operator("545", "09", "Kiribati - Frigate Net", u"Telecom Services Kiribati Ltd"),
        Operator("467", "05", "Koryolink", u"Cheo Technology Jv Company"),
        Operator("467", "193", "SunNet", u"Korea Posts and Telecommunications Corporation"),
        Operator("450", "02", "KT", u"KT"),
        Operator("450", "03", "Power 017", u"Shinsegi Telecom, Inc."),
        Operator("450", "04", "KT", u"KT"),
        Operator("450", "05", "SKTelecom", u"SK Telecom"),
        Operator("450", "06", "LG U+", u"LG Telecom"),
        Operator("450", "08", "olleh", u"KT"),
        Operator("450", "11", "SKTelecom", u"Korea Cable Telecom(t-plus), Eco-mobile"),
        Operator("212", "01", "Vala", u"Vala"),
        Operator("212", "01", "Z Mobile", u"Z Mobile"),
        Operator("293", "41", "IPKO", u"IPKO"),
        Operator("293", "41", "D3 Mobile", u"D3 Mobile"),
        Operator("419", "02", "zain KW", u"zain KW"),
        Operator("419", "03", "Wataniya", u"National Mobile Telecommunications"),
        Operator("419", "04", "Viva", u"Kuwait Telecommunication Company"),
        Operator("437", "01", "Beeline", u"Beeline"),
        Operator("437", "03", "Fonex", u"Aktel Ltd"),
        Operator("437", "05", "MegaCom", u"Alfa Telecom CJSC"),
        Operator("437", "09", "O!", u"NurTelecom LLC"),
        Operator("457", "01", "LTC", u"LaoTelecom"),
        Operator("457", "02", "ETL", u"Enterprise of Telecommunications Lao"),
        Operator("457", "03", "Unitel", u"Star Telecom Co., Ltd"),
        Operator("457", "08", "Beeline", u"VimpelCom Lao Ltd"),
        Operator("247", "01", "LMT", u"Latvian Mobile Telephone"),
        Operator("247", "02", "Tele2", u"Tele2"),
        Operator("247", "03", "TRIATEL", u"Telekom Baltija"),
        Operator("247", "05", "Bite", u"Bite Latvija"),
        Operator("247", "06", "", u"Rigatta"),
        Operator("247", "07", "MTS", u"Master Telecom"),
        Operator("247", "08", "IZZI", u"IZZI"),
        Operator("247", "09", "Camel Mobile", u"Camel Mobile"),
        Operator("415", "01", "Alfa", u"Alfa"),
        Operator("415", "03", "mtc touch", u"mtc touch"),
        Operator("415", "05", "Ogero Mobile", u"Ogero Telecom"),
        Operator("651", "01", "Vodacom", u"Vodacom Lesotho (Pty) Ltd"),
        Operator("651", "02", "", u"Econet Ezi-cel"),
        Operator("618", "01", "Lonestar Cell", u"Lonestar Communications Corporation"),
        Operator("618", "02", "Libercell", u"Atlantic Wireless (Liberia) Inc."),
        Operator("618", "04", "Comium", u"Comium Liberia"),
        Operator("618", "07", "Cellcom", u"Cellcom Telecommunications, Inc"),
        Operator("618", "20", "LIBTELCO", u"Liberia Telecommunications Corporation"),
        Operator("606", "00", "Libyana", u"Libyana"),
        Operator("606", "01", "Madar", u"Al-Madar Al-Jadeed"),
        Operator("606", "02", "Al-Jeel Phone", u"Al-Jeel Al-Jadeed"),
        Operator("606", "03", "Libya Phone", u"Libya Telecom and Technology (LTT)"),
        Operator("606", "06", "Hatef Libya", u"Hatef Libya"),
        Operator("295", "01", "Swisscom", u"Swisscom"),
        Operator("295", "02", "Orange", u"Orange LiechtensteinAG"),
        Operator("295", "05", "FL1", u"Mobilkom Liechtenstein AG"),
        Operator("295", "06", "Cubic Telecom", u"Cubic Telecom AG"),
        Operator("295", "77", "Alpmobil", u"Alpcom AG"),
        Operator("246", "01", "Omnitel", u"Omnitel"),
        Operator("246", "02", "BITĖ", u"UAB Bitė Lietuva"),
        Operator("246", "03", "Tele 2", u"Tele 2"),
        Operator("246", "05", "LitRail", u"Lithuanian Railways"),
        Operator("246", "06", "Mediafon", u"Mediafon"),
        Operator("270", "01", "POST", u"POST Luxembourg"),
        Operator("270", "77", "Tango", u"Tango SA"),
        Operator("270", "99", "Orange", u"Orange S.A."),
        Operator("455", "00", "SmarTone", u"SmarTone"),
        Operator("455", "01", "CTM", u"CTM"),
        Operator("455", "02", "China Telecom", u"China Telecom"),
        Operator("455", "03", "3", u"Hutchison Telecom"),
        Operator("455", "04", "CTM", u"CTM"),
        Operator("455", "05", "3", u"Hutchison Telecom"),
        Operator("294", "01", "T-Mobile MK", u"T-Mobile Macedonia"),
        Operator("294", "02", "ONE", u"One"),
        Operator("294", "03", "Vip MK", u"VIP Operator"),
        Operator("646", "01", "Airtel", u"Airtel"),
        Operator("646", "02", "Orange", u"Orange Madagascar S.A."),
        Operator("646", "03", "Sacel", u"Sacel Madagascar S.A."),
        Operator("646", "04", "Telma", u"Telma Mobile S.A."),
        Operator("650", "01", "TNM", u"Telecom Network Malawi"),
        Operator("650", "10", "Airtel", u"Airtel"),
        Operator("502", "01", "ATUR 450", u"Telekom Malaysia Bhd"),
        Operator("502", "10", "", u"DiGi Telecommunications"),
        Operator("502", "11", "TM Homeline", u"TM Homeline"),
        Operator("502", "12", "Maxis", u"Maxis Mobile Services SDN Berhad"),
        Operator("502", "13", "Celcom", u"Celcom"),
        Operator("502", "14", "", u"Telekom Malaysia Berhad for PSTN SMS"),
        Operator("502", "150", "Tune Talk", u"Tune Talk"),
        Operator("502", "151", "", u"Baraka Telecom Sdn Bhd (MVNE)"),
        Operator("502", "152", "Yes", u"Yes"),
        Operator("502", "156", "Altel", u"Altel Communications Sdn Bhd"),
        Operator("502", "16", "DiGi", u"DiGi Telecommunications"),
        Operator("502", "17", "Hotlink", u"Maxis Prepaid"),
        Operator("502", "18", "U Mobile", u"U Mobile"),
        Operator("502", "18", "TM Homeline", u"TM Homeline"),
        Operator("502", "19", "Celcom", u"Celcom"),
        Operator("502", "20", "", u"Electcoms Wireless Sdn Bhd"),
        Operator("472", "01", "Dhiraagu", u"Dhiraagu"),
        Operator("472", "02", "Ooredoo", u"Ooredoo"),
        Operator("610", "01", "Malitel", u"Malitel SA"),
        Operator("610", "02", "Orange", u"Orange Mali SA"),
        Operator("278", "01", "Vodafone", u"Vodafone Malta"),
        Operator("278", "21", "GO", u"GO"),
        Operator("278", "77", "Melita", u"Melita"),
        Operator("551", "01", "", u"Marshall Islands National Telecommunications Authority (MINTA)"),
        Operator("340", "01", "Orange", u"Orange Caraïbe Mobiles"),
        Operator("340", "02", "Outremer", u"Outremer Telecom"),
        Operator("340", "20", "Digicel", u"Digicel"),
        Operator("609", "01", "Mattel", u"Mattel"),
        Operator("609", "02", "Chinguitel", u"Chinguitel"),
        Operator("609", "10", "Mauritel", u"Mauritel Mobiles"),
        Operator("617", "01", "Orange", u"Orange"),
        Operator("617", "02", "MTML", u"MTML"),
        Operator("617", "10", "Emtel", u"Emtel"),
        Operator("334", "01", "Nextel", u"Nextel"),
        Operator("334", "02", "Telcel", u"Telcel"),
        Operator("334", "03", "movistar", u"movistar"),
        Operator("334", "05", "Iusacell/Unefon", u"Iusacell"),
        Operator("334", "05", "Iusacell", u"Iusacell"),
        Operator("334", "09", "Nextel", u"Nextel"),
        Operator("550", "01", "", u"FSMTC"),
        Operator("259", "01", "Orange", u"Orange Moldova"),
        Operator("259", "02", "Moldcell", u"Moldcell"),
        Operator("259", "03", "IDC", u"Interdnestrcom"),
        Operator("259", "03", "Unité", u"Unité"),
        Operator("259", "04", "Eventis", u"Eventis"),
        Operator("259", "05", "Unité", u"Unité"),
        Operator("259", "99", "Unité", u"Unité"),
        Operator("212", "01", "Office des Telephones", u"Monaco Telecom"),
        Operator("428", "88", "Unitel", u"Unitel"),
        Operator("428", "91", "Skytel", u"Skytel"),
        Operator("428", "98", "G.Mobile", u"G.Mobile"),
        Operator("428", "99", "MobiCom", u"Mobicom Corporation"),
        Operator("297", "01", "Telenor", u"Telenor Montenegro"),
        Operator("297", "02", "T-Mobile", u"T-Mobile Montenegro LLC"),
        Operator("297", "03", "m:tel CG", u"MTEL CG"),
        Operator("297", "04", "T-Mobile", u"T-Mobile Montenegro"),
        Operator("354", "860", "Cable &amp; Wireless", u"Cable &amp; Wireless"),
        Operator("604", "00", "Méditel", u"Méditel"),
        Operator("604", "01", "IAM", u"Ittissalat Al Maghrib (Maroc Telecom)"),
        Operator("604", "02", "Wana Corporate", u"Wan Mobile (Wana)"),
        Operator("604", "05", "INWI", u"INWI"),
        Operator("643", "01", "mCel", u"Mocambique Celular S.A."),
        Operator("643", "03", "Movitel", u"Movitel S.A."),
        Operator("643", "04", "Vodacom", u"Vodacom Mozambique, S.A."),
        Operator("414", "01", "MPT", u"Myanmar Post and Telecommunication"),
        Operator("649", "01", "MTC", u"MTC Namibia"),
        Operator("649", "02", "switch", u"Telecom Namibia"),
        Operator("649", "03", "TN Mobile", u"TN Mobile"),
        Operator("536", "02", "Digicel", u"Digicel (Nauru) Corporation"),
        Operator("429", "01", "Namaste / NT Mobile", u"Nepal Telecom"),
        Operator("429", "02", "Ncell", u"Ncell Pvt. Ltd.Spice Nepal"),
        Operator("429", "03", "Sky/C-Phone", u"Nepal Telecom"),
        Operator("429", "04", "SmartCell", u"Smart Telecom Pvt. Ltd."),
        Operator("204", "01", "", u"VastMobiel B.V."),
        Operator("204", "02", "Tele2", u"Tele2"),
        Operator("204", "03", "Voiceworks", u"Voiceworks B.V."),
        Operator("204", "04", "Vodafone", u"Vodafone"),
        Operator("204", "05", "", u"Elephant Talk Communications Premium Rate Services"),
        Operator("204", "06", "Vectone MobileDelight Mobile", u"Vectone Mobile"),
        Operator("204", "07", "", u"Teleena (MVNE)"),
        Operator("204", "08", "KPN", u"KPN"),
        Operator("204", "09", "Lycamobile", u"Lycamobile Netherlands Limited"),
        Operator("204", "10", "KPN", u"KPN"),
        Operator("204", "12", "Telfort", u"Telfort"),
        Operator("204", "13", "", u"Unica Installatietechniek B.V."),
        Operator("204", "14", "", u"6GMOBILE B.V."),
        Operator("204", "15", "Ziggo", u"Ziggo"),
        Operator("204", "16", "T-Mobile(BEN)", u"T-Mobile"),
        Operator("204", "17", "Intercity Zakelijk", u"Intercity Mobile Communications B.V."),
        Operator("204", "18", "", u"UPC Nederland B.V."),
        Operator("204", "19", "", u"Mixe Communication Solutions B.V."),
        Operator("204", "20", "T-Mobile", u"T-Mobile"),
        Operator("204", "21", "", u"ProRailB.V."),
        Operator("204", "22", "", u"Ministerie van Defensie"),
        Operator("204", "23", "", u"ASPIDER Solutions Nederland B.V."),
        Operator("204", "24", "", u"Private Mobility Nederland B.V."),
        Operator("204", "25", "", u"CapX B.V."),
        Operator("204", "26", "", u"SpeakUp B.V."),
        Operator("204", "27", "", u"Breezz Nederland B.V."),
        Operator("204", "28", "", u"Lancelot B.V."),
        Operator("204", "67", "", u"RadioAccess B.V."),
        Operator("204", "68", "", u"Unify Group Holding B.V."),
        Operator("204", "69", "", u"KPN Mobile The Netherlands B.V."),
        Operator("362", "51", "Telcell", u"Telcell N.V."),
        Operator("362", "69", "Digicel", u"Curaçao Telecom N.V."),
        Operator("362", "91", "UTS", u"Setel N.V."),
        Operator("362", "&#160;?", "", u"East Caribbean Cellular"),
        Operator("362", "&#160;?", "", u"Antiliano Por N.V."),
        Operator("362", "94", "Bayòs", u"Bòbò Frus N.V."),
        Operator("362", "95", "MIO", u"E.O.C.G. Wireless"),
        Operator("546", "01", "Mobilis", u"OPT New Caledonia"),
        Operator("530", "00", "Telecom", u"Telecom New Zealand"),
        Operator("530", "01", "Vodafone", u"Vodafone New Zealand"),
        Operator("530", "02", "Telecom", u"Telecom New Zealand"),
        Operator("530", "03", "Woosh", u"Woosh WirelessNew Zealand Walker"),
        Operator("530", "04", "TelstraClear", u"TelstraClearNew Zealand"),
        Operator("530", "05", "XT Mobile Network", u"XT Mobile Network"),
        Operator("530", "06", "Skinny", u"Telecom New Zealand"),
        Operator("530", "24", "2degrees", u"2degrees"),
        Operator("710", "21", "Claro", u"Empresa Nicaragüense de Telecomunicaciones, S.A. (ENITEL) (América Móvil)"),
        Operator("710", "30", "movistar", u"movistar"),
        Operator("710", "73", "SERCOM", u"Servicios de Comunicaciones S.A."),
        Operator("614", "01", "SahelCom", u"La Société Sahélienne de Télécommunications (SahelCom)"),
        Operator("614", "02", "Airtel", u"Airtel"),
        Operator("614", "03", "Moov", u"Atlantique Telecom (subsidiary of Etisalat)"),
        Operator("614", "04", "Orange", u"Orange Niger"),
        Operator("621", "20", "Airtel", u"Airtel"),
        Operator("621", "25", "Visafone", u"Visafone"),
        Operator("621", "30", "MTN", u"MTN"),
        Operator("621", "40", "M-Tel", u"Nigerian Mobile Telecommunications Limited"),
        Operator("621", "50", "Glo", u"Glo"),
        Operator("621", "60", "Etisalat", u"Etisalat"),
        Operator("555", "01", "Telecom Niue", u"Telecom Niue"),
        Operator("505", "10", "Norfolk Telecom", u"Norfolk Telecom"),
        Operator("242", "01", "Telenor", u"Telenor"),
        Operator("242", "02", "NetCom", u"NetCom GSM"),
        Operator("242", "03", "Teletopia", u"Teletopia"),
        Operator("242", "04", "Tele2", u"Tele2"),
        Operator("242", "05", "Network Norway", u"Network Norway"),
        Operator("242", "06", "Ice", u"Nordisk Mobiltelefon"),
        Operator("242", "07", "Ventelo", u"Ventelo AS"),
        Operator("242", "08", "TDC", u"TDC Mobil AS"),
        Operator("242", "09", "Com4", u"Com4 AS[120]"),
        Operator("242", "11", "SystemNet", u"SystemNet AS[121]"),
        Operator("242", "20", "", u"Jernbaneverket AS"),
        Operator("242", "23", "Lyca", u"Lyca Mobile Ltd"),
        Operator("422", "02", "Oman Mobile", u"Oman Telecommunications Company"),
        Operator("422", "03", "Nawras", u"Nawras"),
        Operator("410", "01", "Mobilink", u"Mobilink"),
        Operator("410", "03", "Ufone", u"Ufone"),
        Operator("410", "04", "Zong", u"Zong"),
        Operator("410", "06", "Telenor", u"Telenor"),
        Operator("410", "07", "Warid", u"Warid"),
        Operator("552", "01", "PNCC", u"Palau National Communications Corp."),
        Operator("552", "80", "Palau Mobile", u"Palau Mobile Corporation"),
        Operator("425", "05", "Jawwal", u"Jawwal"),
        Operator("425", "06", "Wataniya", u"Wataniya"),
        Operator("714", "01", "Cable &amp; Wireless", u"Cable &amp; Wireless Panama S.A."),
        Operator("714", "02", "movistar", u"movistar"),
        Operator("714", "03", "Claro", u"América Móvil"),
        Operator("714", "04", "Digicel", u"Digicel Group"),
        Operator("537", "01", "BeMobile", u"Pacific Mobile Communications"),
        Operator("537", "03", "Digicel", u"Digicel"),
        Operator("744", "01", "VOX", u"Hola Paraguay S.A"),
        Operator("744", "02", "Claro/Hutchison", u"AMX Paraguay S.A."),
        Operator("744", "04", "Tigo", u"Telefónica Celular Del Paraguay S.A. (Telecel)"),
        Operator("744", "05", "Personal", u"Núcleo S.A(TIM)"),
        Operator("744", "06", "Copaco", u"Copaco S.A."),
        Operator("716", "06", "Movistar", u"Movistar"),
        Operator("716", "07", "NEXTEL", u"NEXTEL"),
        Operator("716", "10", "Claro(TIM)", u"Claro"),
        Operator("716", "15", "Viettel Mobile", u"Viettel Mobile"),
        Operator("716", "17", "NEXTEL", u"NEXTEL"),
        Operator("515", "01", "Islacom", u"Globe Telecomvia Innove Communications"),
        Operator("515", "02", "Globe", u"Globe Telecom"),
        Operator("515", "03", "Smart", u"PLDT viaSmart Communications"),
        Operator("515", "05", "Sun", u"Digital Telecommunications Philippines"),
        Operator("515", "11", "", u"PLDT via ACeS Philippines"),
        Operator("515", "18", "Cure", u"PLDT via Smart's Connectivity Unlimited Resources Enterprise"),
        Operator("515", "88", "", u"Nextel"),
        Operator("260", "01", "Plus", u"Plus"),
        Operator("260", "02", "T-Mobile", u"T-Mobile"),
        Operator("260", "03", "Orange", u"Orange"),
        Operator("260", "04", "", u"CenterNet S.A."),
        Operator("260", "05", "", u"Polska Telefonia Komórkowa Centertel Sp. z o.o."),
        Operator("260", "06", "Play", u"Play"),
        Operator("260", "07", "Netia", u"Netia S.A."),
        Operator("260", "08", "", u"E-Telko Sp. z o.o."),
        Operator("260", "09", "Lycamobile", u"Lycamobile Sp. z o.o."),
        Operator("260", "10", "Sferia", u"Sferia S.A."),
        Operator("260", "11", "Nordisk Polska", u"Nordisk Polska Sp. z o.o."),
        Operator("260", "12", "Cyfrowy Polsat", u"Cyfrowy Polsat"),
        Operator("260", "13", "Sferia", u"Sferia S.A."),
        Operator("260", "14", "Sferia", u"Sferia S.A."),
        Operator("260", "15", "CenterNet", u"CenterNet S.A."),
        Operator("260", "16", "Mobyland", u"Mobyland Sp. z o.o."),
        Operator("260", "17", "Aero2", u"Aero 2 Sp. z o.o."),
        Operator("260", "34", "", u"T-Mobile Polska S.A."),
        Operator("260", "98", "", u"P4 Sp. z o.o."),
        Operator("268", "01", "Vodafone", u"Vodafone Portugal"),
        Operator("268", "03", "Optimus", u"Sonaecom – Serviços de Comunicações, S.A."),
        Operator("268", "04", "LycaMobile", u"MVNO"),
        Operator("268", "06", "TMN", u"Telecomunicações Móveis Nacionais"),
        Operator("268", "07", "Vectonemobile - Delightmobile", u"MVNO"),
        Operator("268", "21", "Zapp", u"Zapp Portugal"),
        Operator("330", "00", "Open Mobile", u"PR Wireless"),
        Operator("330", "110", "Claro Puerto Rico", u"América Móvil"),
        Operator("330", "120", "Open Mobile", u"PR Wireless"),
        Operator("427", "01", "ooredoo", u"ooredoo"),
        Operator("427", "02", "Vodafone", u"Vodafone"),
        Operator("427", "05", "Ministry of Interior", u"Ministry of Interior"),
        Operator("647", "00", "Orange", u"Orange La Réunion"),
        Operator("647", "02", "Outremer", u"Outremer Telecom"),
        Operator("647", "10", "SFR Reunion", u"Societe Reunionnaise de Radiotelephone"),
        Operator("226", "01", "Vodafone", u"Vodafone România"),
        Operator("226", "02", "Romtelecom", u"Romtelecom"),
        Operator("226", "03", "Cosmote", u"Cosmote România"),
        Operator("226", "04", "Cosmote/Zapp", u"Cosmote România"),
        Operator("226", "05", "Digi.Mobil", u"RCS&amp;RDS"),
        Operator("226", "06", "Cosmote/Zapp", u"Cosmote România"),
        Operator("226", "10", "Orange", u"Orange România"),
        Operator("250", "01", "MTS", u"Mobile TeleSystems"),
        Operator("250", "02", "MegaFon", u"MegaFon"),
        Operator("250", "03", "NCC", u"Nizhegorodskaya Cellular Communications"),
        Operator("250", "04", "Sibchallenge", u"Sibchallenge"),
        Operator("250", "05", "ETK", u"Yeniseytelecom"),
        Operator("250", "06", "Skylink", u"Skylink"),
        Operator("250", "07", "SMARTS", u"SMARTS"),
        Operator("250", "09", "Skylink", u"Khabarovsky Cellular Phone"),
        Operator("250", "10", "DTC", u"Dontelekom"),
        Operator("250", "11", "Yota", u"Scartel"),
        Operator("250", "12", "Baykalwestcom", u"Baykal Westcom / New Telephone Company / Far Eastern Cellular"),
        Operator("250", "12", "Akos", u""),
        Operator("250", "13", "KUGSM", u"Kuban GSM"),
        Operator("250", "14", "MegaFon", u"MegaFon"),
        Operator("250", "15", "SMARTS", u"SMARTS"),
        Operator("250", "16", "NTC", u"New Telephone Company"),
        Operator("250", "17", "Utel", u"JSCUralsvyazinform"),
        Operator("250", "18", "Osnova Telecom", u""),
        Operator("250", "19", "INDIGO", u"INDIGO"),
        Operator("250", "20", "Tele2", u"Tele2"),
        Operator("250", "23", "Mobicom - Novosibirsk", u"Mobicom - Novosibirsk"),
        Operator("250", "28", "Beeline", u"Beeline"),
        Operator("250", "35", "MOTIV", u"EKATERINBURG-2000"),
        Operator("250", "38", "Tambov GSM", u"Central Telecommunication Company"),
        Operator("250", "39", "Rostelecom", u"Rostelecom"),
        Operator("250", "44", "", u"Stavtelesot / North Caucasian GSM"),
        Operator("250", "50", "MTS", u"Bezlimitno.ru"),
        Operator("250", "91", "Sonic Duo", u"Sonic Duo CJSC"),
        Operator("250", "92", "", u"Primtelefon"),
        Operator("250", "93", "", u"Telecom XXI"),
        Operator("250", "99", "Beeline", u"Beeline"),
        Operator("250", "&#160;?", "", u"SkyLink/MTS/the Moscow Cellular communication"),
        Operator("635", "10", "MTN", u"MTN"),
        Operator("635", "12", "Rwandatel", u"Rwandatel S.A."),
        Operator("635", "13", "Tigo", u"Tigo"),
        Operator("635", "14", "Airtel", u"Airtel"),
        Operator("356", "050", "Digicel", u"Wireless Ventures (St Kitts-Nevis) Limited"),
        Operator("356", "070", "Chippie", u"UTS"),
        Operator("356", "110", "LIME", u"LIME"),
        Operator("358", "050", "Digicel[citation needed]", u"[citation needed]"),
        Operator("358", "110", "", u"Cable &amp; Wireless"),
        Operator("308", "01", "Ameris", u"St. Pierre-et-Miquelon Télécom"),
        Operator("308", "02", "GLOBALTEL", u"GLOBALTEL"),
        Operator("360", "070", "Digicel", u"Digicel (St. Vincent and the Grenadines) Limited"),
        Operator("360", "100", "Cingular Wireless", u""),
        Operator("360", "110", "Lime", u"Cable &amp; Wireless (St. Vincent &amp; the Grenadines) Ltd"),
        Operator("549", "01", "Digicel", u"Digicel Pacific Ltd."),
        Operator("549", "27", "Bluesky", u"Bluesky Samoa Ltd"),
        Operator("292", "01", "PRIMA", u"San Marino Telecom"),
        Operator("626", "01", "CSTmovel", u"Companhia Santomese de Telecomunicaçôe"),
        Operator("420", "01", "Al Jawal (STC )", u"Saudi Telecom Company"),
        Operator("420", "03", "Mobily", u"Mobily"),
        Operator("420", "04", "ZainSA", u"Zain"),
        Operator("420", "21", "RGSM", u"RGSM"),
        Operator("608", "01", "Orange", u"Orange"),
        Operator("608", "02", "Tigo", u"Tigo"),
        Operator("608", "03", "Expresso", u"Sudatel"),
        Operator("220", "01", "Telenor", u"Telenor Serbia"),
        Operator("220", "02", "Telenor", u"Telenor Montenegro"),
        Operator("220", "03", "mt:s", u"Telekom Srbija"),
        Operator("220", "05", "VIP", u"VIP Mobile"),
        Operator("633", "01", "Cable &amp; Wireless", u"Cable &amp; Wireless"),
        Operator("633", "02", "Mediatech International", u"Mediatech International"),
        Operator("633", "10", "Airtel", u"Telecom Seychelles Ltd"),
        Operator("619", "01", "Airtel", u"Bharti Airtel Limited"),
        Operator("619", "03", "Africell", u"Africell"),
        Operator("619", "04", "Comium", u"Comium Sierra leone INC"),
        Operator("619", "05", "Africell", u"Lintel Sierra Leone Limited"),
        Operator("619", "06", "SierraTel", u"Sierra Leone Telephony"),
        Operator("619", "25", "Mobitel", u"Mobitel"),
        Operator("619", "&#160;?", "GreenNet", u"Intergroup"),
        Operator("525", "01", "SingTel", u"Singapore Telecom"),
        Operator("525", "02", "SingTel-G18", u"Singapore Telecom"),
        Operator("525", "03", "M1", u"M1 Limited"),
        Operator("525", "05", "StarHub", u"StarHub Mobile"),
        Operator("525", "06", "StarHub", u"StarHub Mobile"),
        Operator("525", "07", "SingTel", u"Singapore Telecom"),
        Operator("525", "12", "Grid", u"GRID Communications Pte Ltd."),
        Operator("231", "01", "Orange", u"Orange Slovensko"),
        Operator("231", "02", "Telekom", u"Slovak Telekom"),
        Operator("231", "03", "", u"Unient Communications"),
        Operator("231", "04", "T-Mobile", u"T-Mobile Slovensko"),
        Operator("231", "06", "O2", u"2"),
        Operator("231", "99", "ŽSR", u"Železnice Slovenskej Republiky"),
        Operator("293", "31", "Mobitel", u"Mobitel"),
        Operator("293", "40", "Si.mobil", u"Si.mobil"),
        Operator("293", "41", "Mobitel", u"Mobitel"),
        Operator("293", "51", "Mobitel", u"Mobitel"),
        Operator("293", "64", "T-2", u"T-2 d.o.o."),
        Operator("293", "70", "Tušmobil", u"Tušmobil"),
        Operator("540", "01", "BREEZE", u"Solomon Telekom Co Ltd"),
        Operator("540", "02", "BeMobile", u"BMobile (SI) Ltd"),
        Operator("637", "01", "Telesom", u"Telesom"),
        Operator("637", "04", "SomaCyber", u"SomaCyber"),
        Operator("637", "04", "Somafone", u"Somafone"),
        Operator("637", "10", "Nationlink", u"NationLink Telecom"),
        Operator("637", "25", "Hormuud", u"Hormuud Telecom Somalia Inc"),
        Operator("637", "30", "Golis", u"Golis Telecom Somalia"),
        Operator("637", "57", "Unittel", u"Unittel"),
        Operator("637", "60", "Nationlink Telecom", u"Nationlink Telecom"),
        Operator("637", "71", "Somtel", u"2G/3G"),
        Operator("637", "82", "Telcom", u"Telcom"),
        Operator("655", "01", "Vodacom", u"Vodacom"),
        Operator("655", "02", "Telkom Mobile / 8.ta / Telekom SA", u"Telekom SA"),
        Operator("655", "06", "Sentech", u"Sentech"),
        Operator("655", "07", "Cell C", u"Cell C"),
        Operator("655", "10", "MTN", u"MTN Group"),
        Operator("655", "11", "", u"South African Police ServiceGauteng"),
        Operator("655", "13", "Neotel", u"Neotel"),
        Operator("655", "19", "iBurst", u"iBurst"),
        Operator("655", "21", "", u"Cape Town Metropolitan Council"),
        Operator("655", "30", "", u"Bokamoso Consortium"),
        Operator("655", "31", "", u"Karabo Telecoms (Pty) Ltd."),
        Operator("655", "32", "", u"Ilizwi Telecommunications"),
        Operator("655", "33", "", u"Thinta Thinta Telecommunications"),
        Operator("659", "02", "MTN", u"MTN South Sudan"),
        Operator("659", "03", "Gemtel", u"Gemtel"),
        Operator("659", "04", "Vivacell", u"Network of the World (NOW)"),
        Operator("659", "06", "Zain", u"Zain South Sudan"),
        Operator("659", "07", "Sudani", u"Sudani"),
        Operator("214", "01", "Vodafone", u"Vodafone"),
        Operator("214", "03", "Orange", u"Orange"),
        Operator("214", "04", "Yoigo", u"Yoigo"),
        Operator("214", "05", "TME", u"Telefónica Móviles España"),
        Operator("214", "06", "Vodafone", u"Vodafone"),
        Operator("214", "07", "movistar", u"movistar"),
        Operator("214", "08", "Euskaltel", u"Euskaltel"),
        Operator("214", "09", "Orange", u"France Telecom España SA"),
        Operator("214", "15", "BT", u"BT GroupEspaña Compañia de Servicios Globales de Telecomunicaciones S.A.U."),
        Operator("214", "16", "TeleCable", u"TeleCable"),
        Operator("214", "17", "Móbil R", u"Móbil R"),
        Operator("214", "18", "ONO", u"ONO"),
        Operator("214", "19", "Simyo", u"Simyo"),
        Operator("214", "20", "Fonyou", u"Fonyou Telecom S.L."),
        Operator("214", "21", "Jazztel", u"Jazztel"),
        Operator("214", "22", "DigiMobil", u"Best Spain Telecom"),
        Operator("214", "23", "Barablu", u"Barablu Móvil España"),
        Operator("214", "24", "Eroski", u"Eroski Móvil España"),
        Operator("214", "25", "LycaMobile", u"LycaMobile S.L."),
        Operator("413", "01", "Mobitel", u"Mobitel"),
        Operator("413", "02", "Dialog", u"Dialog"),
        Operator("413", "03", "Etisalat", u"Etisalat"),
        Operator("413", "04", "Lanka Bell", u"Lanka Bell"),
        Operator("413", "05", "Airtel", u"Airtel"),
        Operator("413", "08", "Hutch", u"Hutch"),
        Operator("413", "11", "Dialog", u"Dialog"),
        Operator("413", "17", "Dialog", u"Dialog"),
        Operator("634", "01", "ZainSD", u"Zain"),
        Operator("634", "02", "MTN", u"MTN"),
        Operator("634", "05", "Canar Telecom", u""),
        Operator("634", "07", "Sudani One", u"Sudani One"),
        Operator("634", "09", "Privet Network", u"Privet Network"),
        Operator("746", "02", "Telesur", u"Telesur"),
        Operator("746", "03", "Digicel", u"Digicel"),
        Operator("746", "04", "Uniqa", u"Uniqa"),
        Operator("653", "10", "Swazi MTN", u"Swazi MTN Limited"),
        Operator("240", "01", "Telia", u"TeliaSonera Sverige AB"),
        Operator("240", "02", "3", u"HI3G Access AB"),
        Operator("240", "03", "Net 1", u"Netett Sverige AB"),
        Operator("240", "04", "SWEDEN", u"3G Infrastructure Services AB"),
        Operator("240", "05", "Sweden 3G", u"Svenska UMTS-Nät AB"),
        Operator("240", "06", "Telenor", u"Telenor"),
        Operator("240", "07", "Tele2", u"Tele2"),
        Operator("240", "08", "Telenor", u"Telenor"),
        Operator("240", "09", "djuice", u"djuice"),
        Operator("240", "10", "Spring Mobil", u"Spring Mobil AB"),
        Operator("240", "11", "", u"Lindholmen Science Park AB"),
        Operator("240", "12", "Lycamobile Sweden", u"Lycamobile Sweden Limited"),
        Operator("240", "13", "", u"Alltele Företag Sverige AB"),
        Operator("240", "14", "", u"TDC Sverige AB"),
        Operator("240", "15", "", u"Wireless Maingate Nordic AB"),
        Operator("240", "16", "", u"42 Telecom AB"),
        Operator("240", "17", "Gotanet", u"Gotanet"),
        Operator("240", "18", "", u"Generic Mobile Systems Sweden AB"),
        Operator("240", "19", "Vectone Mobile/Delight Mobile", u"Vectone Mobile"),
        Operator("240", "20", "", u"Wireless Maingate Messaging Services AB"),
        Operator("240", "21", "MobiSir", u"Trafikverket ICT"),
        Operator("240", "22", "", u"EuTel AB"),
        Operator("240", "23", "", u"Infobip Limited"),
        Operator("240", "24", "Sweden 2G", u"Net4Mobility HB"),
        Operator("240", "25", "", u"Digitel Mobile Srl"),
        Operator("240", "26", "", u"Beepsend AB"),
        Operator("240", "27", "", u"Fogg Mobile AB"),
        Operator("240", "28", "", u"CoolTEL Aps"),
        Operator("240", "29", "", u"Mercury International Carrier Services"),
        Operator("240", "30", "", u"NextGen Mobile Ltd."),
        Operator("240", "31", "", u"Mobimax AB"),
        Operator("240", "32", "", u"Compatel Limited"),
        Operator("240", "33", "", u"Mobile Arts AB"),
        Operator("240", "34", "", u"Tigo LTD."),
        Operator("240", "35", "", u"42 Telecom LTD"),
        Operator("240", "36", "", u"interactive digital media GmbH"),
        Operator("240", "37", "", u"CLX Networks AB"),
        Operator("240", "38", "", u"Voxbone SA"),
        Operator("240", "40", "", u"ReWiCom Scandinavia AB"),
        Operator("240", "41", "", u"Shyam Telecom UK Ltd."),
        Operator("240", "42", "", u"Telenor Connexion AB"),
        Operator("228", "01", "Swisscom", u"Swisscom"),
        Operator("228", "02", "Sunrise", u"Sunrise Communications AG"),
        Operator("228", "03", "Orange", u"Orange Communications SA"),
        Operator("228", "05", "", u"Togewanet AG (Comfone)"),
        Operator("228", "06", "SBB-CFF-FFS", u"SBB-CFF-FFS"),
        Operator("228", "07", "IN&amp;Phone", u"IN&amp;Phone SA"),
        Operator("228", "08", "Tele4u", u"TelCommunication Services AG"),
        Operator("228", "09", "", u"Comfone"),
        Operator("228", "12", "", u"Sunrise"),
        Operator("228", "50", "", u"3G Mobile AG"),
        Operator("228", "51", "", u"BebbiCell AG"),
        Operator("228", "52", "Barablu", u"Barablu"),
        Operator("228", "53", "", u"UPC"),
        Operator("228", "54", "", u"Lyca Mobile"),
        Operator("417", "01", "Syriatel", u"Syriatel"),
        Operator("417", "02", "MTN", u"MTN Syria"),
        Operator("466", "01", "FarEasTone", u"FarEasTone"),
        Operator("466", "05", "APTG", u"Asia Pacific Telecom"),
        Operator("466", "06", "FarEasTone", u"FarEasTone"),
        Operator("466", "11", "Chunghwa LDM", u"LDTA/Chunghwa Telecom"),
        Operator("466", "88", "FarEasTone", u"FarEasTone"),
        Operator("466", "89", "VIBO", u"VIBO"),
        Operator("466", "92", "Chungwa", u"Chunghwa Telecom"),
        Operator("466", "93", "MobiTai", u"Mobitai Communications"),
        Operator("466", "97", "Taiwan Mobile", u"Taiwan Mobile"),
        Operator("466", "99", "TransAsia", u"TransAsia Telecoms"),
        Operator("436", "01", "Tcell", u"Tcell"),
        Operator("436", "02", "Tcell", u"Tcell"),
        Operator("436", "03", "Megafon Tajikistan", u"TT Mobile"),
        Operator("436", "04", "Babilon-M", u"Babilon-Mobile"),
        Operator("436", "05", "Beeline", u"Tacom"),
        Operator("436", "12", "Tcell", u"Tcell"),
        Operator("640", "02", "tiGO", u"MIC Tanzania Limited"),
        Operator("640", "03", "Zantel", u"Zanzibar Telecom Ltd"),
        Operator("640", "04", "Vodacom", u"Vodacom"),
        Operator("640", "05", "Airtel", u"Airtel"),
        Operator("640", "06", "Sasatel", u"Sasatel"),
        Operator("640", "07", "TTCL Mobile", u"TTCL Mobile"),
        Operator("640", "08", "Benson Online (BOL)", u"Benson Online (BOL)"),
        Operator("640", "09", "Hits", u"Hits"),
        Operator("640", "11", "SmileCom", u"Smile Telecoms Holdings Ltd."),
        Operator("520", "00", "my by CAT", u"CAT Telecom"),
        Operator("520", "01", "AIS", u"AIS"),
        Operator("520", "02", "CAT CDMA", u"CAT Telecom"),
        Operator("520", "03", "AIS3G", u"AIS"),
        Operator("520", "04", "truemove H4G LTE", u"4G LTE"),
        Operator("520", "05", "dtac 3G", u"dtac 3G"),
        Operator("520", "10", "&#160;?", u"WCS IQ"),
        Operator("520", "15", "TOT 3G", u"Telephone Organization of Thailand (TOT)"),
        Operator("520", "18", "dtac", u"dtac"),
        Operator("520", "23", "AIS GSM 1800", u"(AIS)"),
        Operator("520", "25", "WE PCT", u"True Corporation"),
        Operator("520", "99", "truemove", u"True Corporation"),
        Operator("615", "01", "Togo Cell", u"Togo Telecom"),
        Operator("615", "03", "Moov", u"Moov Togo"),
        Operator("539", "01", "U-Call", u"Tonga Communications Corporation"),
        Operator("539", "43", "", u"Shoreline Communication"),
        Operator("539", "88", "Digicel", u"Digicel (Tonga) Limited"),
        Operator("374", "12", "bmobile", u"bmobile"),
        Operator("374", "130", "Digicel", u"Digicel"),
        Operator("605", "01", "Orange", u"Orange Tunisie"),
        Operator("605", "02", "Tunicell", u"Tunisie Telecom"),
        Operator("605", "03", "Tunisiana", u"Tunisiana"),
        Operator("286", "01", "Turkcell", u"TurkcellIletisim Hizmetleri A.S."),
        Operator("286", "02", "Vodafone", u"Vodafone Turkey"),
        Operator("286", "03", "Avea", u"Avea"),
        Operator("286", "04", "", u"Aycell"),
        Operator("438", "01", "MTS (BARASH Communication)", u'ES "MTS-Turkmenistan"'),
        Operator("438", "02", "TM-Cell", u"Altyn Asyr"),
        Operator("338", "050", "Digicel", u"Digicel (Turks &amp; Caicos) Limited"),
        Operator("376", "350", "C&amp;W", u"Cable &amp; Wireless West Indies Ltd (Turks &amp; Caicos)"),
        Operator("376", "352", "Islandcom", u"Islandcom Telecommunications"),
        Operator("553", "01", "TTC", u"Tuvalu Telecom"),
        Operator("641", "01", "Airtel", u"Airtel"),
        Operator("641", "10", "MTN", u"MTN"),
        Operator("641", "11", "UTL ( Telecom Limited)", u"Uganda Telecom Ltd."),
        Operator("641", "14", "Orange", u"Orange"),
        Operator("641", "22", "Warid Telecom", u"Warid Telecom"),
        Operator("641", "33", "Smile", u"Smile"),
        Operator("641", "44", "K2", u"K2"),
        Operator("641", "66", "i-Tel", u"i-Tel"),
        Operator("255", "01", "MTS", u"MTS Ukraine"),
        Operator("255", "02", "Beeline", u"Beeline"),
        Operator("255", "03", "Kyivstar", u"Kyivstar"),
        Operator("255", "04", "IT", u"Intertelecom"),
        Operator("255", "05", "Golden Telecom", u"Golden Telecom"),
        Operator("255", "06", "life:)", u"life:)"),
        Operator("255", "07", "3Mob", u"3Mob (Ukrtelecom UMTS )"),
        Operator("255", "21", "PEOPLEnet", u"PEOPLEnet"),
        Operator("255", "23", "CDMA Ukraine", u"Intertelecom"),
        Operator("255", "25", "NEWTONE", u"CST Invest"),
        Operator("424", "02", "Etisalat", u"Etisalat"),
        Operator("424", "03", "du", u"du"),
        Operator("234", "00", "BT", u"BT Group"),
        Operator("234", "01", "Vectone Mobile", u"Vectone Mobile"),
        Operator("234", "02", "O2 (UK)", u"O2 (UK)"),
        Operator("234", "03", "Airtel-Vodafone", u"Airtel-Vodafone"),
        Operator("234", "04", "FMS Solutions Ltd", u"FMS Solutions Ltd"),
        Operator("234", "05", "", u"COLT Mobile Telecommunications Limited"),
        Operator("234", "06", "", u"Internet Computer Bureau Limited"),
        Operator("234", "07", "", u"Cable &amp; Wireless Worldwide"),
        Operator("234", "08", "", u"OnePhone (UK) Ltd"),
        Operator("234", "09", "", u"Tismi BV"),
        Operator("234", "10", "O2 (UK)", u"O2 (UK)"),
        Operator("234", "11", "O2 (UK)", u"O2 (UK)"),
        Operator("234", "12", "Railtrack", u"Network Rail Infrastructure Ltd"),
        Operator("234", "13", "Railtrack", u"Network Rail Infrastructure Ltd"),
        Operator("234", "14", "Hay Systems Ltd", u"Hay Systems Ltd"),
        Operator("234", "15", "Vodafone UK", u"Vodafone UK"),
        Operator("234", "16", "Talk Talk (Opal Tel Ltd)", u"TalkTalk Communications Limited"),
        Operator("234", "17", "", u"FleXtel Limited"),
        Operator("234", "18", "Cloud9", u"Cloud9"),
        Operator("234", "19", "Private Mobile Networks PMN", u"Teleware plc"),
        Operator("234", "20", "3", u"3"),
        Operator("234", "22", "RoutoMessaging", u"RoutoMessaging"),
        Operator("234", "24", "Greenfone", u"Stour Marine"),
        Operator("234", "25", "Truphone", u"Truphone"),
        Operator("234", "26", "Lycamobile", u""),
        Operator("234", "27", "", u"Teleena UK Limited"),
        Operator("234", "30", "T-Mobile UK", u"T-Mobile UK"),
        Operator("234", "31", "Virgin Mobile UK", u"Virgin Mobile UK"),
        Operator("234", "32", "Virgin Mobile UK", u"Virgin Mobile UK"),
        Operator("234", "33", "Orange (UK)", u"Orange (UK)"),
        Operator("234", "34", "Orange (UK)", u"Orange (UK)"),
        Operator("234", "35", "", u"JSC Ingenium (UK) Limited"),
        Operator("234", "36", "", u"Cable and Wireless Isle of Man Limited"),
        Operator("234", "37", "", u"Synectiv Ltd"),
        Operator("234", "50", "JT", u"JT Group Limited"),
        Operator("234", "51", "UK Broadband Limited", u"UK Broadband Limited"),
        Operator("234", "55", "", u"Cable &amp; Wireless Guernsey / Sure Mobile (Jersey)"),
        Operator("234", "58", "", u"Manx Telecom"),
        Operator("234", "76", "BT", u"BT Group"),
        Operator("234", "78", "Airwave", u"Airwave (communications network)[citation needed]"),
        Operator("235", "00", "", u"Mundio Mobile Limited"),
        Operator("235", "01", "", u"EE"),
        Operator("235", "02", "", u"EE"),
        Operator("235", "77", "BT", u"BT Group"),
        Operator("235", "91", "", u"Vodafone United Kingdom"),
        Operator("235", "92", "", u"Cable &amp; Wireless UK"),
        Operator("235", "94", "", u"Hutchison 3G UK Ltd"),
        Operator("235", "95", "", u"Network Rail Infrastructure Limited"),
        Operator("310", "004", "Verizon", u"Verizon Wireless"),
        Operator("310", "005", "Verizon", u"Verizon Wireless"),
        Operator("310", "010", "", u"MCI"),
        Operator("310", "013", "MobileTel", u""),
        Operator("310", "014", "", u"Testing"),
        Operator("310", "016", "Cricket Communications", u"Cricket Wireless"),
        Operator("310", "017", "", u"North Sight Communications Inc."),
        Operator("310", "020", "", u"Union Telephone Company"),
        Operator("310", "026", "T-Mobile", u""),
        Operator("310", "030", "AT&amp;T", u"AT&amp;T Mobility"),
        Operator("310", "034", "Airpeak", u""),
        Operator("310", "040", "Concho", u"Concho Cellular Telephone Co., Inc."),
        Operator("310", "046", "SIMMETRY", u"TMP Corp"),
        Operator("310", "053", "", u"Virgin Mobile US"),
        Operator("310", "054", "", u"Alltel US"),
        Operator("310", "060", "", u"Consolidated Telcom"),
        Operator("310", "066", "", u"U.S. Cellular"),
        Operator("310", "070", "", u"Highland Cellular"),
        Operator("310", "080", "Corr", u"Corr Wireless Communications LLC"),
        Operator("310", "090", "Cricket Communications", u"Cricket Wireless"),
        Operator("310", "100", "Plateau Wireless", u"New Mexico RSA 4 East Ltd. Partnership"),
        Operator("310", "110", "PTI Pacifica", u"PTI Pacifica Inc."),
        Operator("310", "120", "Sprint", u""),
        Operator("310", "150", "AT&amp;T", u"AT&amp;T Mobility"),
        Operator("310", "160", "", u"T-Mobile"),
        Operator("310", "170", "AT&amp;T", u"AT&amp;T Mobility"),
        Operator("310", "180", "West Central", u"West Central Wireless"),
        Operator("310", "190", "Dutch Harbor", u"Alaska Wireless Communications, LLC"),
        Operator("310", "200", "", u"T-Mobile"),
        Operator("310", "210", "", u"T-Mobile"),
        Operator("310", "220", "", u"T-Mobile"),
        Operator("310", "230", "", u"T-Mobile"),
        Operator("310", "240", "", u"T-Mobile"),
        Operator("310", "250", "", u"T-Mobile"),
        Operator("310", "260", "", u"T-Mobile"),
        Operator("310", "270", "", u"T-Mobile"),
        Operator("310", "280", "AT&amp;T", u"AT&amp;T Mobility"),
        Operator("310", "290", "", u"T-Mobile"),
        Operator("310", "300", "Big Sky Mobile", u"Smart Call (Truphone)"),
        Operator("310", "310", "", u"T-Mobile"),
        Operator("310", "311", "", u"Farmers Wireless"),
        Operator("310", "320", "Cellular One", u"Cellular One"),
        Operator("310", "330", "T-Mobile", u""),
        Operator("310", "340", "Westlink", u"Westlink Communications"),
        Operator("310", "350", "", u"Carolina Phone"),
        Operator("310", "380", "AT&amp;T", u"AT&amp;T Mobility"),
        Operator("310", "390", "Cellular One of East Texas", u"TX-11 Acquisition, LLC"),
        Operator("310", "400", "i CAN_GSM", u"Wave Runner LLC (Guam)"),
        Operator("310", "410", "AT&amp;T", u"AT&amp;T Mobility"),
        Operator("310", "420", "Cincinnati Bell", u"Cincinnati Bell"),
        Operator("310", "430", "", u"Alaska Digitel"),
        Operator("310", "440", "Cellular One", u""),
        Operator("310", "450", "Viaero", u"Viaero Wireless"),
        Operator("310", "460", "Simmetry", u"TMP Corporation"),
        Operator("310", "470", "nTelos", u""),
        Operator("310", "480", "", u"Choice Phone"),
        Operator("310", "490", "T-Mobile", u""),
        Operator("310", "500", "Alltel", u""),
        Operator("310", "510", "Airtel", u"Airtel Wireless"),
        Operator("310", "520", "VeriSign", u""),
        Operator("310", "530", "", u"West Virginia Wireless"),
        Operator("310", "540", "Oklahoma Western", u"Oklahoma Western Telephone Company"),
        Operator("310", "560", "AT&amp;T", u"AT&amp;T Mobility"),
        Operator("310", "570", "Cellular One", u"MTPCS, LLC"),
        Operator("310", "580", "T-Mobile", u""),
        Operator("310", "590", "Alltel", u"Alltel"),
        Operator("310", "610", "Epic Touch", u"Elkhart Telephone Co."),
        Operator("310", "620", "Coleman County Telecom", u"Coleman County Telecommunications"),
        Operator("310", "630", "AmeriLink PCS", u"Choice Wireless"),
        Operator("310", "640", "Airadigm", u"Airadigm Communications"),
        Operator("310", "650", "Jasper", u"Jasper Wireless, inc"),
        Operator("310", "660", "T-Mobile", u""),
        Operator("310", "670", "Northstar", u""),
        Operator("310", "680", "AT&amp;T", u"AT&amp;T Mobility"),
        Operator("310", "690", "Immix", u"Immix Wireless"),
        Operator("310", "730", "SeaMobile", u""),
        Operator("310", "740", "Convey", u"Convey Communications Inc."),
        Operator("310", "750", "Appalachian Wireless", u"Appalachian Wireless"),
        Operator("310", "760", "Panhandle", u"Panhandle Telecommunications Systems Inc."),
        Operator("310", "770", "i wireless", u"i wireless"),
        Operator("310", "780", "", u"Airlink PCS"),
        Operator("310", "790", "PinPoint", u"PinPoint Communications"),
        Operator("310", "800", "", u"T-Mobile"),
        Operator("310", "830", "Caprock", u"Caprock Cellular"),
        Operator("310", "840", "telna Mobile", u"Telecom North America Mobile, Inc."),
        Operator("310", "850", "Aeris", u"Aeris Communications, Inc."),
        Operator("310", "870", "PACE", u"Kaplan Telephone Company"),
        Operator("310", "880", "Advantage", u"Advantage Cellular Systems"),
        Operator("310", "890", "Unicel", u"Unicel"),
        Operator("310", "900", "Mid-Rivers Wireless", u"Mid-Rivers Communications"),
        Operator("310", "910", "First Cellular", u"First Cellular of Southern Illinois"),
        Operator("310", "940", "", u"Iris Wireless LLC"),
        Operator("310", "950", "XIT Wireless", u"Texas RSA 1 dba XIT Cellular"),
        Operator("310", "960", "Plateau Wireless", u""),
        Operator("310", "970", "Globalstar", u""),
        Operator("310", "980", "AT&amp;T", u"AT&amp;T Mobility"),
        Operator("310", "990", "AT&amp;T", u"AT&amp;T Mobility"),
        Operator("311", "000", "", u"Mid-Tex Cellular"),
        Operator("311", "010", "Chariton Valley", u"Chariton Valley Communications"),
        Operator("311", "012", "Verizon", u"Verizon Wireless"),
        Operator("311", "020", "", u"Missouri RSA 5 Partnership"),
        Operator("311", "030", "", u"Indigo Wireless"),
        Operator("311", "040", "", u"Commnet Wireless"),
        Operator("311", "050", "", u"Wikes Cellular"),
        Operator("311", "060", "Farmers Cellular", u"Farmers Cellular Telephone"),
        Operator("311", "070", "Easterbrooke", u"Easterbrooke Cellular Corporation"),
        Operator("311", "080", "Pine Cellular", u"Pine Telephone Company"),
        Operator("311", "090", "Long Lines Wireless", u"Long Lines Wireless LLC"),
        Operator("311", "100", "", u"High Plains Wireless"),
        Operator("311", "110", "", u"High Plains Wireless"),
        Operator("311", "120", "", u"Choice Phone"),
        Operator("311", "130", "", u"Cell One Amarillo"),
        Operator("311", "140", "Sprocket", u"MBO Wireless"),
        Operator("311", "150", "", u"Wilkes Cellular"),
        Operator("311", "160", "", u"Endless Mountains Wireless"),
        Operator("311", "170", "PetroCom", u"Broadpoint Inc"),
        Operator("311", "180", "", u"Cingular Wireless"),
        Operator("311", "190", "", u"Cellular Properties"),
        Operator("311", "210", "", u"Emery Telcom Wireless"),
        Operator("311", "220", "", u"U.S. Cellular"),
        Operator("311", "230", "", u"C Spire Wireless"),
        Operator("311", "330", "Bug Tussel Wireless", u"Bug Tussel Wireless"),
        Operator("311", "480", "Verizon", u"Verizon Wireless"),
        Operator("311", "481-489", "Verizon", u"Verizon Wireless"),
        Operator("311", "490", "Sprint Corporation", u"Sprint Corporation"),
        Operator("311", "660", "metroPCS", u"metroPCS"),
        Operator("311", "870", "Boost", u"Boost Mobile"),
        Operator("311", "960", "Lycamobile", u"Lyca Technology Solutions"),
        Operator("311", "970", "Big River Broadband", u"Big River Broadband, LLC"),
        Operator("312", "590", "NMU", u"Northern Michigan University"),
        Operator("313", "100", "700&#160;MHz Public Safety Broadband", u""),
        Operator("313", "101-199", "700&#160;MHz Public Safety Broadband", u""),
        Operator("316", "010", "Nextel", u"Nextel Communications"),
        Operator("316", "011", "", u"Southern Communications Services"),
        Operator("748", "01", "Antel", u"Compania estatal (ANTEL)"),
        Operator("748", "07", "Movistar", u"Telefónica Móviles Uruguay"),
        Operator("748", "10", "Claro", u"AM Wireless Uruguay S.A."),
        Operator("434", "01", "", u"Buztel"),
        Operator("434", "02", "", u"Uzmacom"),
        Operator("434", "04", "Beeline", u"Beeline"),
        Operator("434", "05", "Ucell", u"Coscom"),
        Operator("434", "06", "Perfectum Mobile", u"RUBICON WIRELESS COMMUNICATION"),
        Operator("434", "07", "MTS", u"MTS"),
        Operator("434", "03", "UzMobile", u"Uzbektelekom"),
        Operator("541", "00", "AIL", u"ACeS International (AIL)"),
        Operator("541", "01", "SMILE", u"Telecom Vanuatu Ltd"),
        Operator("541", "05", "Digicel", u"Digicel Vanuatu Ltd"),
        Operator("541", "07", "CANL", u"CANL Vanuatu Ltd"),
        Operator("225", "", "", u""),
        Operator("734", "01", "Digitel", u"Digitel"),
        Operator("734", "02", "Digitel GSM", u"Digitel GSM"),
        Operator("734", "03", "Digitel", u"Digitel"),
        Operator("734", "04", "movistar", u"movistar"),
        Operator("734", "06", "Movilnet", u"Movilnet"),
        Operator("452", "01", "MobiFone", u"MobiFone"),
        Operator("452", "02", "Vinaphone", u"Vinaphone"),
        Operator("452", "03", "S-Fone", u"S-Fone"),
        Operator("452", "04", "Viettel Mobile", u"Viettel Mobile"),
        Operator("452", "05", "Vietnamobile (HT Mobile )", u"Hanoi Telecom"),
        Operator("452", "06", "EVNTelecom", u"EVNTelecom - EVN"),
        Operator("452", "07", "G-Mobile", u"GTEL Mobile JSC"),
        Operator("452", "08", "3G EVNTelecom", u"3G EVNTelecom"),
        Operator("421", "01", "SabaFon", u"SabaFon"),
        Operator("421", "02", "MTN", u"MTN"),
        Operator("421", "03", "Yemen Mobile", u"Yemen Mobile"),
        Operator("421", "04", "HiTS-UNITEL", u"HiTS-UNITEL"),
        Operator("645", "01", "Airtel", u"Airtel"),
        Operator("645", "02", "MTN", u"MTN Group"),
        Operator("645", "03", "ZAMTEL", u"Zambia Telecommunications Company Ltd"),
        Operator("648", "01", "Net*One", u"Net*One Cellular (Pvt) Ltd"),
        Operator("648", "03", "Telecel", u"Telecel Zimbabwe (PVT) Ltd"),
        Operator("648", "04", "Econet", u"Econet Wireless (Private) Limited"),
        Operator("901", "01", "ICO", u"ICO Satellite Management"),
        Operator("901", "02", "", u"Unassigned"),
        Operator("901", "03", "Iridium", u"Iridium"),
        Operator("901", "04", "", u"Unassigned"),
        Operator("901", "05", "", u"ThurayaRMSS Network"),
        Operator("901", "06", "", u"ThurayaSatellite Telecommunications Company"),
        Operator("901", "07", "", u"Unassigned"),
        Operator("901", "08", "", u"Unassigned"),
        Operator("901", "09", "", u"Unassigned"),
        Operator("901", "10", "ACeS", u"ACeS"),
        Operator("901", "11", "Inmarsat", u"Inmarsat"),
        Operator("901", "12", "Telenor", u"Telenor"),
        Operator("901", "13", "GSM.AQ", u"Global Networks Switzerland Inc."),
        Operator("901", "14", "", u"AeroMobile AS"),
        Operator("901", "15", "OnAir", u"OnAir"),
        Operator("901", "16", "", u"Jasper Systems"),
        Operator("901", "17", "Navitas", u""),
        Operator("901", "18", "Cellular @Sea", u"AT&amp;T Mobility"),
        Operator("901", "19", "", u"Vodafone MaltaMaritime"),
        Operator("901", "20", "", u"Intermatica"),
        Operator("901", "21", "", u"Unassigned"),
        Operator("901", "22", "", u"MediaLincc Ltd"),
        Operator("901", "23", "", u"Unassigned"),
        Operator("901", "24", "iNum", u"Voxbone"),
        Operator("901", "25", "", u"Unassigned"),
        Operator("901", "26", "TIM", u"Telecom Italia"),
        Operator("901", "27", "OnAir", u"OnAir"),
        Operator("901", "28", "Vodafone", u"Vodafone"),
        Operator("901", "29", "Telenor", u"Telenor"),
        Operator("901", "30", "", u"Unassigned"),
        Operator("901", "31", "Orange", u"Orange"),
        Operator("901", "32", "Sky High", u"MegaFon"),
        Operator("901", "33", "", u"Smart Communications"),
        Operator("901", "34", "", u"tyntecGmbH"),
        Operator("901", "35", "", u"Globecomm Network Services"),
        Operator("901", "36", "", u"Azerfon"),
        Operator("901", "88", "", u"UN Office for the Coordination of Humanitarian Affairs (OCHA)"),
    ]


def _build_index(idx, records):
    return dict((':'.join([r[k] for k in idx]).upper(), r) for r in records)


def _build_index_tuple(idx, records):
    # There can be multiple MCC codes per country
    result = {}
    for r in records:
        if isinstance(r[idx], tuple):
            for k in r[idx]:
                if k:
                    result[k.upper()] = r
        elif r[idx]:
            result[r[idx].upper()] = r
    return result


def _build_list_index(idx, records):
    res = defaultdict(list)
    for r in records:
        res[r[idx].upper()].append(r)
    return res


def _get(data, var, method, idx, *codes):
    global _cache
    if data.__name__ not in _cache:
        _cache[data.__name__] = data()
    if var not in _cache:
        _cache[var] = method(idx, _cache[data.__name__])
    return _cache[var][':'.join(k.upper() for k in codes)]


_cache = {}
name = partial(_get, _countries, 'name', _build_index, [0])
alpha2 = partial(_get, _countries, 'alpha2', _build_index, [1])
alpha3 = partial(_get, _countries, 'alpha3', _build_index, [2])
numeric = partial(_get, _countries, 'numeric', _build_index, [3])
mcc = partial(_get, _countries, 'mcc', _build_index_tuple, 4)
operators = partial(_get, _operators, 'operators', _build_list_index, 0)
mcc_mnc = partial(_get, _operators, 'mcc_mnc', _build_index, [0, 1])
