r"""
================================================================================
Auto generated by mod2doctest on 2009-11-09 23:46:50.464000
================================================================================

Python 2.6.2 (r262:71605, Apr 14 2009, 22:40:02) [MSC v.1500 32 bit (Intel)] on win32
Type "help", "copyright", "credits" or "license" for more information.


===============================================================================
Test Setup
===============================================================================
>>> import mod2doctest
>>> from mod2doctest import m2d_print
>>> 
>>> def fix_output(input):
...     '''Fixes docstring output for this test suite. 
... 
...     Due to how doctest works, we need to: 
...     
...       *  Convert triple quotes to single quotes. 
...       *  Replace \>>> to |>> and \... to |\...  
...       *  Add a + sign to each line of output. 
...     
...     '''
...     input = input.replace('""', '')
...     return '\n+ '.join(input.replace('>>', '|>').replace('..', '|.').split('\n'))
... 
>>> def get_title(docstr):
...     return ''
... 


===============================================================================
Test File
===============================================================================
>>> file = r'''
... import sys
... import os
... print "Current dir is '%s'" % os.getcwd()
... 
... '''
>>> print fix_output(mod2doctest.convert(src=file, target=None, 
...                                      run_doctest=False, add_testmod=False, 
...                                      fn_title_docstr=get_title))
"
+ 
+ Python 2.6.2 (r262:71605, Apr 14 2009, 22:40:02) [MSC v.1500 32 bit (Intel)] on win32
+ Type "help", "copyright", "credits" or "license" for more information.
+ 
+ 
+ |>> import sys
+ |>> import os
+ |>> print "Current dir is '%s'" % os.getcwd()
+ Current dir is '|..tests'
+ 
+ "


===============================================================================
Test Ellipse Memory ID
===============================================================================
>>> file = r'''
... class MyClass(object):
...     pass
... 
... print MyClass
... print MyClass()
... 
... '''
>>> print fix_output(mod2doctest.convert(src=file, target=None, 
...                                      run_doctest=False, add_testmod=False, 
...                                      fn_title_docstr=get_title))
"
+ 
+ Python 2.6.2 (r262:71605, Apr 14 2009, 22:40:02) [MSC v.1500 32 bit (Intel)] on win32
+ Type "help", "copyright", "credits" or "license" for more information.
+ 
+ 
+ |>> class MyClass(object):
+ |..     pass
+ |.. 
+ |>> print MyClass
+ <class '__main__.MyClass'>
+ |>> print MyClass()
+ <...MyClass object at 0x...>
+ 
+ "


===============================================================================
Test Ellipse Traceback
===============================================================================
>>> file = r'''
... import os
... import pickle
... print pickle.dumps(os)
... 
... '''
>>> print fix_output(mod2doctest.convert(src=file, target=None, 
...                                      run_doctest=False, add_testmod=False, 
...                                      fn_title_docstr=get_title))
"
+ 
+ Python 2.6.2 (r262:71605, Apr 14 2009, 22:40:02) [MSC v.1500 32 bit (Intel)] on win32
+ Type "help", "copyright", "credits" or "license" for more information.
+ 
+ 
+ |>> import os
+ |>> import pickle
+ |>> print pickle.dumps(os)
+ Traceback (most recent call last):
+     |..
+ TypeError: can't pickle module objects
+ 
+ "


===============================================================================
Test Shift Comment Left
===============================================================================
>>> file = r'''
... #===============================================================================
... 
... # Header
... 
... #===============================================================================
... 
... # Comment Level 1
... 
... ## Double Comments
... 
... ### Triple Comments
... 
... 
... '''
>>> print fix_output(mod2doctest.convert(src=file, target=None, 
...                                      run_doctest=False, add_testmod=False, 
...                                      fn_title_docstr=get_title))
"
+ 
+ Python 2.6.2 (r262:71605, Apr 14 2009, 22:40:02) [MSC v.1500 32 bit (Intel)] on win32
+ Type "help", "copyright", "credits" or "license" for more information.
+ 
+ 
+ ===============================================================================
+ |>> 
+ Header
+ |>> 
+ ===============================================================================
+ |>> 
+ Comment Level 1
+ |>> 
+ # Double Comments
+ |>> 
+ ## Triple Comments
+ 
+ "


===============================================================================
Fix line breaks.
===============================================================================
>>> file = r'''
... print 'Only one line break'
... 
... print 'Two line breaks'
... 
... 
... print 'Six line breaks'
... 
... 
... 
... 
... 
... print 'DONE!'
... '''
>>> print fix_output(mod2doctest.convert(src=file, target=None, 
...                                      run_doctest=False, add_testmod=False, 
...                                      fn_title_docstr=get_title))
"
+ 
+ Python 2.6.2 (r262:71605, Apr 14 2009, 22:40:02) [MSC v.1500 32 bit (Intel)] on win32
+ Type "help", "copyright", "credits" or "license" for more information.
+ 
+ 
+ |>> print 'Only one line break'
+ Only one line break
+ |>> 
+ |>> print 'Two line breaks'
+ Two line breaks
+ 
+ 
+ |>> print 'Six line breaks'
+ Six line breaks
+ 
+ 
+ |>> print 'DONE!'
+ DONE!
+ 
+ "


===============================================================================
Test m2d_print
===============================================================================


>>> file = r'''
... from mod2doctest import m2d_print
... 
... 
... m2d_print.h1('HEADER 1')
... #=======================
... 
... 
... 
... m2d_print.h2('HEADER 2')
... #-----------------------
... 
... 
... 
... '''
>>> 
>>> print fix_output(mod2doctest.convert(src=file, target=None, 
...                                      run_doctest=False, add_testmod=False, 
...                                      fn_title_docstr=get_title))
"
+ 
+ Python 2.6.2 (r262:71605, Apr 14 2009, 22:40:02) [MSC v.1500 32 bit (Intel)] on win32
+ Type "help", "copyright", "credits" or "license" for more information.
+ 
+ 
+ |>> from mod2doctest import m2d_print
+ 
+ 
+ HEADER 1
+ =======================
+ 
+ 
+ HEADER 2
+ -----------------------
+ 
+ "

"""



#===============================================================================
# Test Setup
#===============================================================================
import mod2doctest
from mod2doctest import m2d_print

def fix_output(input):
    """Fixes docstring output for this test suite. 

    Due to how doctest works, we need to: 
    
      *  Convert triple quotes to single quotes. 
      *  Replace >>> to |>> and ... to |...  
      *  Add a + sign to each line of output. 
    
    """
    input = input.replace('""', '')
    return '\n+ '.join(input.replace('>>', '|>').replace('..', '|.').split('\n'))

def get_title(docstr):
    return ''



#===============================================================================
m2d_print.h1("Test File")
#===============================================================================
file = r'''
import sys
import os
print "Current dir is '%s'" % os.getcwd()

'''
print fix_output(mod2doctest.convert(src=file, target=None, 
                                     run_doctest=False, add_testmod=False, 
                                     fn_title_docstr=get_title))



#===============================================================================
m2d_print.h1("Test Ellipse Memory ID")
#===============================================================================
file = r'''
class MyClass(object):
    pass

print MyClass
print MyClass()

'''
print fix_output(mod2doctest.convert(src=file, target=None, 
                                     run_doctest=False, add_testmod=False, 
                                     fn_title_docstr=get_title))



#===============================================================================
m2d_print.h1("Test Ellipse Traceback")
#===============================================================================
file = r'''
import os
import pickle
print pickle.dumps(os)

'''
print fix_output(mod2doctest.convert(src=file, target=None, 
                                     run_doctest=False, add_testmod=False, 
                                     fn_title_docstr=get_title))



#===============================================================================
m2d_print.h1("Test Shift Comment Left")
#===============================================================================
file = r'''
#===============================================================================
# Header
#===============================================================================
# Comment Level 1
## Double Comments
### Triple Comments

'''
print fix_output(mod2doctest.convert(src=file, target=None, 
                                     run_doctest=False, add_testmod=False, 
                                     fn_title_docstr=get_title))




#===============================================================================
m2d_print.h1("Fix line breaks.")
#===============================================================================
file = r'''
print 'Only one line break'

print 'Two line breaks'


print 'Six line breaks'





print 'DONE!'
'''
print fix_output(mod2doctest.convert(src=file, target=None, 
                                     run_doctest=False, add_testmod=False, 
                                     fn_title_docstr=get_title))





#===============================================================================
m2d_print.h1("Test m2d_print")
#===============================================================================


file = r'''
from mod2doctest import m2d_print


m2d_print.h1('HEADER 1')
#=======================


m2d_print.h2('HEADER 2')
#-----------------------


'''

print fix_output(mod2doctest.convert(src=file, target=None, 
                                     run_doctest=False, add_testmod=False, 
                                     fn_title_docstr=get_title))


if __name__ == '__main__':
    import mod2doctest
    mod2doctest.convert(src=None, 
                        target=True, 
                        run_doctest=True, 
                        add_testmod=True)
