from django.conf.urls.defaults import patterns, url

from tastypie.api import Api

from molo.api import ModelBaseResource


v1_api = Api(api_name='v1')
v1_api.register(ModelBaseResource())


urlpatterns = patterns(
    '',

    url(
        r'^content/detail/(?P<slug>[\w-]+)/$',
        'molo.views.object_detail',
        {},
        name='object_detail'
    ),
    url(
        r'^content/list/(?P<app_label>[\w-]+)/(?P<model>[\w-]+)/$',
        'molo.views.object_list',
        {},
        name='object_list'
    ),
    url(
        r'^content/peek/(?P<slug>[\w-]+)/$',
        'molo.views.object_peek',
        {},
        name='object_peek'
    ),
    url(
        r'^content/(?P<category_slug>[\w-]+)/list/$',
        'molo.views.category_object_list',
        {},
        name='category_object_list'
    ),
    url(
        r'^content/(?P<category_slug>[\w-]+)/(?P<slug>[\w-]+)/$',
        'molo.views.category_object_detail',
        {},
        name='category_object_detail'
    ),
)
