from django.conf import settings
from django.db import models


DB_ENGINE = settings.DATABASES['default']['ENGINE']


class PermittedManager(models.Manager):

    def get_query_set(self, for_user=None):
        is_staff = getattr(for_user, 'is_staff', False)
        queryset = super(PermittedManager, self).get_query_set()

        # Exclude unpublished if user is not staff
        if not is_staff:
            queryset = queryset.exclude(
                state='unpublished'
            )

        # Exclude objects in staging state if not in
        # staging mode (settings.STAGING = False).
        if not getattr(settings, 'STAGING', False):
            queryset = queryset.exclude(state='staging')

        # Filter objects for current site is user is not staff
        if not is_staff:
            queryset = queryset.filter(sites__id__exact=settings.SITE_ID)

        return queryset


class DefaultManager(models.Manager):

    def get_by_natural_key(self, slug):
        return self.get(slug=slug)
