from django.core.management.base import BaseCommand, CommandError
from django.db import transaction
from django.db.models import Q
from django.utils import timezone

from django.db.models.loading import get_model


class Command(BaseCommand):
    help = "Publish or unpublish Jmbo objects."

    @transaction.commit_on_success
    def handle(self, *args, **options):
        for model_string in args:
            try:
                model = get_model(*model_string.split('.', 1))
            except Exception, e:
                raise CommandError(
                    'Model doesn\'t exist. '
                    'Please use the format appname.model. [%s]' %
                    model_string)
            now = timezone.now()

            q1 = Q(publish_on__lte=now, retract_on__isnull=True)
            q2 = Q(publish_on__lte=now, retract_on__gt=now)
            model.objects.filter(
                state='unpublished'
            ).filter(q1 | q2).update(state='published')

            model.objects.filter(
                state='published'
            ).filter(retract_on__lte=now).update(state='unpublished')
