from django.conf.urls.defaults import patterns, url


urlpatterns = patterns(
    '',

    url(
        r'^content/detail/(?P<slug>[\w-]+)/$',
        'molo.views.object_detail',
        {},
        name='object_detail'
    ),
    url(
        r'^content/list/(?P<app_label>[\w-]+)/(?P<model>[\w-]+)/$',
        'molo.views.object_list',
        {},
        name='object_list'
    ),
    url(
        r'^content/peek/(?P<slug>[\w-]+)/$',
        'molo.views.object_peek',
        {},
        name='object_peek'
    ),
    url(
        r'^content/(?P<category_slug>[\w-]+)/list/$',
        'molo.views.category_object_list',
        {},
        name='category_object_list'
    ),
    url(
        r'^content/(?P<category_slug>[\w-]+)/(?P<slug>[\w-]+)/$',
        'molo.views.category_object_detail',
        {},
        name='category_object_detail'
    ),

    # Admin ajax urls
    (
        r'^admin/molo/publish-ajax/(?P<app_label>[\w-]+)/(?P<model>[\w-]+)/$',
        'molo.admin_views.publish_ajax',
        {},
        'molo-publish-ajax',
    ),

    (
        r'^admin/molo/unpublish-ajax/(?P<app_label>[\w-]+)/(?P<model>[\w-]+)/$',
        'molo.admin_views.unpublish_ajax',
        {},
        'molo-unpublish-ajax',
    ),
)
