from setuptools import setup, find_packages

setup(
    name='molo',
    version='1.0.5',
    description='Jmbo-lite without photologue and atlas',
    long_description=open('README.rst', 'r').read() + open(
        'AUTHORS.rst', 'r').read() + open('CHANGELOG.rst', 'r').read(),
    author='Praekelt Foundation',
    author_email='dev@praekelt.com',
    license='BSD',
    url='http://www.jmbo.org',
    packages=find_packages(),
    install_requires=[
        'Pillow',
        'pytz',
        'django>=1.4,<1.5',
        'django-category>=0.0.5',
        'django-likes>=0.0.8',
        'django-preferences',
        'django-publisher',
        'django-sites-groups',
        'south',
        'django-tastypie<0.10',
        'django-celery',
        'psycopg2',
    ],
    include_package_data=True,
    tests_require=[
        'pysqlite>=2.5',
        'django-setuptest>=0.1.2',
    ],
    test_suite="setuptest.setuptest.SetupTestSuite",
    classifiers=[
        "Programming Language :: Python",
        "License :: OSI Approved :: BSD License",
        "Development Status :: 4 - Beta",
        "Operating System :: OS Independent",
        "Framework :: Django",
        "Intended Audience :: Developers",
        "Topic :: Internet :: WWW/HTTP :: Dynamic Content",
    ],
    zip_safe=False,
)
