from django.contrib.admin.views.decorators import staff_member_required
from django.http import HttpResponse
from django.db.models.loading import get_model


@staff_member_required
def publish_ajax(request, app_label, model):
    obj = get_model(app_label, model).objects.get(id=request.REQUEST['id'])
    obj.publish()
    return HttpResponse('published')


@staff_member_required
def unpublish_ajax(request):
    obj = get_model(app_label, model).objects.get(id=request.REQUEST['id'])
    obj.unpublish()
    return HttpResponse('unpublished')
