/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Connection {
    private static final String TRUST_STORE_PATH_KEY = "trust_store_path";
    private static final String TRUST_STORE_PASSWORD_KEY = "trust_store_password";
    private Integer port;
    private String host;
    private String user;
    private String password;
    private String trustStorePath;
    private String trustStorePassword;
    private MBeanServerConnection mbs;
    private static final Long CONNECTION_TIMEOUT = new Long(10000L);
    private static final Logger LOGGER = Logger.getLogger(Connection.class.getName());
    private static final ThreadFactory daemonThreadFactory = new DaemonThreadFactory();

    public Connection(LinkedHashMap<String, Object> connectionParams) throws IOException {
        this.host = (String)connectionParams.get("host");
        this.port = (Integer)connectionParams.get("port");
        this.user = (String)connectionParams.get("user");
        this.password = (String)connectionParams.get("password");
        if (connectionParams.containsKey(TRUST_STORE_PATH_KEY) && connectionParams.containsKey(TRUST_STORE_PASSWORD_KEY)) {
            this.trustStorePath = (String)connectionParams.get(TRUST_STORE_PATH_KEY);
            this.trustStorePassword = (String)connectionParams.get(TRUST_STORE_PASSWORD_KEY);
        } else {
            this.trustStorePath = null;
            this.trustStorePassword = null;
        }
        this.mbs = this.createConnection();
    }

    public MBeanAttributeInfo[] getAttributesForBean(ObjectName bean_name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        return this.mbs.getMBeanInfo(bean_name).getAttributes();
    }

    public Set<ObjectInstance> queryMBeans() throws IOException {
        return this.mbs.queryMBeans(null, null);
    }

    private MBeanServerConnection createConnection() throws IOException {
        JMXServiceURL address = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + this.host + ":" + this.port + "/jmxrmi");
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("jmx.remote.credentials", new String[]{this.user, this.password});
        env.put("jmx.remote.x.request.waiting.timeout", CONNECTION_TIMEOUT);
        if (this.trustStorePath != null && this.trustStorePassword != null) {
            System.setProperty("javax.net.ssl.trustStore", this.trustStorePath);
            System.setProperty("javax.net.ssl.trustStorePassword", this.trustStorePassword);
            LOGGER.info("Setting trustStore path: " + this.trustStorePath + " and trustStorePassword");
        }
        JMXConnector connector = Connection.connectWithTimeout(address, env, 20L, TimeUnit.SECONDS);
        MBeanServerConnection mbs = connector.getMBeanServerConnection();
        return mbs;
    }

    public Object getAttribute(ObjectName objectName, String attributeName) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        return this.mbs.getAttribute(objectName, attributeName);
    }

    public static JMXConnector connectWithTimeout(final JMXServiceURL url, final Map<String, Object> env, long timeout, TimeUnit unit) throws IOException {
        Object result;
        final ArrayBlockingQueue<String> mailbox = new ArrayBlockingQueue<String>(1);
        ExecutorService executor = Executors.newSingleThreadExecutor(daemonThreadFactory);
        executor.submit(new Runnable(){

            public void run() {
                try {
                    JMXConnector connector = JMXConnectorFactory.connect(url, env);
                    if (!mailbox.offer(connector)) {
                        connector.close();
                    }
                }
                catch (Throwable t) {
                    mailbox.offer(t);
                }
            }
        });
        try {
            result = mailbox.poll(timeout, unit);
            if (result == null && !mailbox.offer("")) {
                result = mailbox.take();
            }
        }
        catch (InterruptedException e) {
            throw Connection.initCause(new InterruptedIOException(e.getMessage()), e);
        }
        finally {
            executor.shutdown();
        }
        if (result == null) {
            LOGGER.warn("Connection timed out: " + url);
            throw new SocketTimeoutException("Connection timed out: " + url);
        }
        if (result instanceof JMXConnector) {
            return (JMXConnector)result;
        }
        try {
            throw (Throwable)result;
        }
        catch (Throwable e) {
            throw new IOException(e.toString(), e);
        }
    }

    private static <T extends Throwable> T initCause(T wrapper, Throwable wrapped) {
        wrapper.initCause(wrapped);
        return wrapper;
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            return t;
        }
    }
}

