/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.yaml.snakeyaml.Yaml;

public class Status {
    HashMap<String, Object> instanceStats;
    private static volatile Status _instance = null;
    private static final Logger LOGGER = Logger.getLogger(Status.class.getName());
    private String status_file_location;
    private boolean isEnabled;
    public static final String STATUS_WARNING = "WARNING";
    public static final String STATUS_OK = "OK";
    public static final String STATUS_ERROR = "ERROR";
    private static final String INITIALIZED_CHECKS = "initialized_checks";
    private static final String FAILED_CHECKS = "failed_checks";

    private Status() {
        this.configure(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Status getInstance() {
        if (_instance != null) return _instance;
        Class<Status> clazz = Status.class;
        synchronized (Status.class) {
            if (_instance != null) return _instance;
            _instance = new Status();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    public void configure(String status_file_location) {
        this.status_file_location = status_file_location;
        this.isEnabled = this.status_file_location != null;
        this.instanceStats = new HashMap();
        this._clearStats();
    }

    private void _clearStats() {
        this.instanceStats.put(INITIALIZED_CHECKS, new HashMap());
    }

    public void addInstanceStats(String checkName, String instance, int metricCount, String message, String status) {
        this.addStats(checkName, instance, metricCount, message, status, INITIALIZED_CHECKS);
    }

    private void addStats(String checkName, String instance, int metricCount, String message, String status, String key) {
        LinkedList checkStats;
        HashMap initializedChecks = (HashMap)this.instanceStats.get(key);
        if (initializedChecks == null) {
            initializedChecks = new HashMap();
        }
        if ((checkStats = (LinkedList)initializedChecks.get(checkName)) == null) {
            checkStats = new LinkedList();
        }
        HashMap<String, Object> instStats = new HashMap<String, Object>();
        if (instance != null) {
            instStats.put("instance_name", instance);
        }
        if (metricCount != -1) {
            instStats.put("metric_count", metricCount);
        }
        instStats.put("message", message);
        instStats.put("status", status);
        checkStats.add(instStats);
        initializedChecks.put(checkName, checkStats);
        this.instanceStats.put(key, initializedChecks);
    }

    public void addInitFailedCheck(String checkName, String message, String status) {
        this.addStats(checkName, null, -1, message, status, FAILED_CHECKS);
    }

    private String _generateYaml() {
        Yaml yaml = new Yaml();
        HashMap<String, Serializable> status = new HashMap<String, Serializable>();
        status.put("timestamp", Long.valueOf(System.currentTimeMillis()));
        status.put("checks", this.instanceStats);
        return yaml.dump(status);
    }

    public void deleteStatus() {
        if (this.isEnabled) {
            try {
                File f = new File(this.status_file_location);
                LOGGER.info("Deleting status file");
                if (f.delete()) {
                    LOGGER.info("Status file properly deleted");
                } else {
                    LOGGER.warn("Couldn't delete status file");
                }
            }
            catch (Exception e) {
                LOGGER.warn("Couldn't delete status file", e);
            }
        }
    }

    public void flush() {
        if (this.isEnabled) {
            String yaml = this._generateYaml();
            try {
                File f = new File(this.status_file_location);
                LOGGER.debug("Writing status to temp yaml file: " + f.getAbsolutePath());
                FileUtils.writeStringToFile(f, yaml);
            }
            catch (Exception e) {
                LOGGER.warn("Cannot write status to temp file: " + e.getMessage());
            }
            this._clearStats();
        }
    }
}

