/* VClamp.h --- 
 * 
 * Filename: VClamp.h
 * Description: 
 * Author: 
 * Maintainer: 
 * Created: Fri Feb  1 19:22:19 2013 (+0530)
 * Version: 
 * Last-Updated: Wed Feb  6 17:20:48 2013 (+0530)
 *           By: subha
 *     Update #: 55
 * URL: 
 * Keywords: 
 * Compatibility: 
 * 
 */

/* Commentary: 
 * 
 * Class for implementing voltage clamp
 * 
 */

/* Change log:
 * 
 * 
 */

/* This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 3, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */

/* Code: */

#ifndef _VCLAMP_H
#define _VCLAMP_H
namespace moose
{
    class VClamp
    {
        static const unsigned DERIVATIVE_ON_PV;
        static const unsigned PROPORTIONAL_ON_PV;
  public:
        VClamp();
        ~VClamp();
        void setCommand(double v);
        double getCommand() const;
        void setVin(double v);
        double getVin() const;
        double getCurrent() const;
        void setMode(unsigned int mode);
        unsigned int getMode() const;
        void setTi(double value);
        double getTi() const;
        void setTd(double value);
        double getTd() const;
        void setTau(double value);
        double getTau() const;
        void setGain(double value);
        double getGain() const;
        void process(const Eref& e, ProcPtr p);
        void reinit(const Eref& e, ProcPtr p);
        
        static const Cinfo* initCinfo();

        // finfo used to send out injection current to compartment
        static SrcFinfo1< double >* currentOut();
        
  protected:
        double vIn_; // membrane potential read from the compartment
        double command_; // command potential
        double current_; // current generated by the clamp circuit
        unsigned int mode_; // 0 - use normal PID
        // 1 - base derivative on PV
        // 2 - base proportional & derivative on PV
        double ti_; // integral time
        double td_; // derivative time
        double Kp_; // proportional gain - set to Cm/dt
        double tau_; // time constant for low pass filter on command voltage
        double tdByDt_; // internal variable for performance
        double dtByTi_; // internal variable for performance
        double tauByDt_;//  internal variable for performance
        double e_; // error[n] (current step)
        double e1_; // error[n-1]
        double e2_; // error[n-2]
        double v1_; // internal variable used only when error term is replaced by process variable
        double cmdIn_; // older value of command potential
        double oldCmdIn_;
        double expt_;
        
    };
}

#endif // _VCLAMP_H
/* VClamp.h ends here */
