IF (NOT MPI_FOUND)
set(CMAKE_FIND_LIBRARY_SUFFIXES ".so.1" ".so.0" ".so" ".a")
FIND_PATH(MPI_INCLUDE_DIR mpi.h
  /usr/lib/openmpi/include
  /usr/local/lib/openmpi/include
  r:/usr/lib/openmpi/include
  c:/usr/lib/openmpi/include
  ${DISTR_PREFIX}/lib/openmpi/include
  DOC "Directory containing openmpi headers"
)

SET(LIBSEARCHPATHS 
	/usr/lib/openmpi/lib
	/usr/lib/openmpi/lib/openmpi
	/usr/local/lib/openmpi/lib
	R:/usr/lib/openmpi/lib
	${DISTR_PREFIX}/lib/openmpi/lib
) 


FIND_LIBRARY(MPI_LIBRARY
	NAMES
		mpi
	PATHS 	${LIBSEARCHPATHS} 
) 

FIND_LIBRARY(MPI_CXX_LIBRARY
	NAMES
		mpi_cxx
	PATHS 	${LIBSEARCHPATHS} 
) 

FIND_LIBRARY(MPI_F77_LIBRARY
	NAMES
		mpi_f77
	PATHS 	${LIBSEARCHPATHS} 
) 

FIND_LIBRARY(MPI_F90_LIBRARY
	NAMES
		mpi_f90
	PATHS 	${LIBSEARCHPATHS} 
) 

FIND_LIBRARY(MPI_OPEN_LIBRARY
	NAMES 	
		open-pal
		open-rte
	PATHS 	${LIBSEARCHPATHS}
) 

FIND_LIBRARY(MPI_MCA_LIBRARY
	NAMES 	
		mca_common_sm
	PATHS 	${LIBSEARCHPATHS}
) 

FIND_LIBRARY(MPI_OMPITV_LIBRARY
	NAMES 	
		ompitv
	PATHS 	${LIBSEARCHPATHS}
) 


set(MPI_LIBRARY_D ${MPI_LIBRARY})
set(MPI_CXX_LIBRARY_D ${MPI_CXX_LIBRARY})
set(MPI_F77_LIBRARY_D ${MPI_F77_LIBRARY})
set(MPI_F90_LIBRARY_D ${MPI_F90_LIBRARY})
set(MPI_OPEN_LIBRARY_D ${MPI_OPEN_LIBRARY})
set(MPI_MCA_LIBRARY_D ${MPI_MCA_LIBRARY})
set(MPI_OMPITV_LIBRARY_D ${MPI_OMPITV_LIBRARY})

IF (MPI_INCLUDE_DIR AND MPI_LIBRARY_D AND MPI_LIBRARY AND MPI_CXX_LIBRARY_D AND MPI_CXX_LIBRARY AND MPI_F77_LIBRARY_D AND MPI_F77_LIBRARY AND MPI_F90_LIBRARY_D AND MPI_F90_LIBRARY AND MPI_OPEN_LIBRARY_D AND MPI_OPEN_LIBRARY AND MPI_MCA_LIBRARY_D AND MPI_MCA_LIBRARY AND MPI_OMPITV_LIBRARY_D AND MPI_OMPITV_LIBRARY)
	SET(MPI_FOUND TRUE) 
ENDIF (MPI_INCLUDE_DIR AND MPI_LIBRARY_D AND MPI_LIBRARY AND MPI_CXX_LIBRARY_D AND MPI_CXX_LIBRARY AND MPI_F77_LIBRARY_D AND MPI_F77_LIBRARY AND MPI_F90_LIBRARY_D AND MPI_F90_LIBRARY AND MPI_OPEN_LIBRARY_D AND MPI_OPEN_LIBRARY AND MPI_MCA_LIBRARY_D AND MPI_MCA_LIBRARY AND MPI_OMPITV_LIBRARY_D AND MPI_OMPITV_LIBRARY)

IF (MPI_FOUND)
	IF (NOT Mpi_FIND_QUIETLY) 
		MESSAGE(STATUS "Found MPI: ${MPI_LIBRARY}") 
	ENDIF (NOT Mpi_FIND_QUIETLY) 
ELSE (MPI_FOUND)
	 IF (Mpi_FIND_REQUIRED) 
		MESSAGE(FATAL_ERROR "Could not find Mpi") 
	ENDIF (Mpi_FIND_REQUIRED) 
ENDIF (MPI_FOUND)

ENDIF (NOT MPI_FOUND)

