import boto

import logging

import logging
log = logging.getLogger('motorboto.aws')

use_test_credentials = False

class AWS(object):
    def __init__(self, aws_id=None, aws_key=None):
        """Universal connection through which all services are accessed.
        
        This is a lazy object and doesn't make connections until it needs to, 
        so that fact this returns is no guarantee that your credentials are valid.

        >>> import motorboto
        >>> motorboto.AWS()
        <motorboto.aws.AWS object at ...
        """
    
        import motorboto
        if not use_test_credentials:
            self.id = aws_id
            self.key = aws_key
            
            if self.id or self.key:
                log.info('using supplied credentials') 
            else:
                log.info('using credentials from boto config file') 
        else:
            log.info('using test credentials')
            import os.path
            import ConfigParser
            config = ConfigParser.ConfigParser()
            config.read(os.path.expanduser('~/.boto.motorboto-test'))
            self.id = config.get('Credentials', 'aws_access_key_id')
            self.key = config.get('Credentials', 'aws_secret_access_key')
        
        
        
    @property
    def s3(self):
        """S3 Connection
        
        >>> import motorboto
        >>> motorboto.AWS().s3
        <motorboto.s3.Connection object at ...
        """
        import s3
        return s3.Connection(self)
    
    @property
    def cloudfront(self):
        import cloudfront
        return cloudfront.Connection(self)

    @property
    def ec2(self):
        import ec2
        return ec2.Connection(self)

    def get_copy(self):
        return AWS(self.id, self.key)
        
    @property
    def _auth_params(self):
        if self.id and self.key:
            return {'aws_access_key_id': self.id,
                    'aws_secret_access_key': self.key }
        return {}

class Connection(object):
    def __init__(self, aws):
        self.aws = aws
        
