import boto

import aws

from util import property_lazy

class Connection(aws.Connection):
    """
    Cloudfront.
    
    >>> import motorboto
    >>> cf = motorboto.AWS().cloudfront
    >>> cf
    <motorboto.cloudfront.Connection object at ...>
    """
    
    @property_lazy
    def boto(self):
        return boto.connect_cloudfront(**self.aws._auth_params)

    @property
    def distributions(self):
        return self.boto.get_all_distributions()
        
    @property
    def distributions(self):
        return { ds.domain_name: Distribution(self, ds.domain_name) for ds in self.boto.get_all_distributions() }
    
    def create_distribution(self, origin, s3=False):
        if s3:
            from boto.cloudfront.origin import S3Origin
            o_boto = S3Origin(origin, origin_protocol_policy='match-viewer')
        else:
            from boto.cloudfront.origin import CustomOrigin
            o_boto = CustomOrigin(origin, origin_protocol_policy='match-viewer')
            
        d_boto = self.boto.create_distribution(origin=o_boto, enabled=True)
        d = Distribution(self, origin)
        d.boto = d_boto
        return d
        
    def refresh(self):
        try:
            del self.boto
        except AttributeError:
            pass

class Distribution(object):
    def __init__(self, connection, domain_name):
        self.name = domain_name
        self.connection = connection
    
    @property_lazy
    def boto(self):
        return self.connection.distributions[self.name].get_distribution()

    def refresh(self):
        try:
            del self.boto
        except AttributeError:
            pass


