# -*- encoding: UTF-8 -*-
# 
# This a project generated by Pyjama with default layout
# 
# Copyright (C) 2012  maemo
# 
# This program is free software: you can redistribute
# it and/or modify it under the terms of the GNU
# General Public License as published by the Free
# Software Foundation, either version 3 of the License,
# or (at your option) any later version.
# 
# This program is distributed in the hope that it will
# be useful, but WITHOUT ANY WARRANTY; without even the
# implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE. See the GNU General Public
# License for more details.
# 
# You should have received a copy of the GNU General
# Public License along with this program. If not, see
# <http://www.gnu.org/licenses/>
# 
'''
Created on Mar 5, 2012

@author: maemo
'''
import sqlite3

from threading import RLock
import os
import os.path
import logging


from mougeon.core.utils import *
from mougeon.common import version 

version.getInstance().submitRevision("$Revision: 11 $")

    

DATABASE_URL = None

def checkStorage():
    """
    Test if the databse existe if not create a new one
    """
    if not os.path.isfile(DATABASE_URL):
        initStorage(DATABASE_URL)

def initStorage(dburl):
    """
    This function should be used to ensure the backend storage is available 
    """
    conn = sqlite3.connect(DATABASE_URL)
    conn.row_factory = sqlite3.Row
    c = conn.cursor()
    c.executescript("""
        %s;        
        """ % (TrackedCellTower.create_sql(),)
         )
    conn.commit()
    c.close()
    
def getConnection():
    conn = sqlite3.connect(DATABASE_URL)
    conn.row_factory = sqlite3.Row
    return conn

def releaseConnection(cnx):    
    cnx.close()

    
def with_transaction_required(commit):
    """
    Decorator to handle local transaction.
    If none cnx arguments keywork is passed to the decorated function
    then this decorator create a new connexion.
    if the commit decorator argument is True, then if a local transaction where created
    then commit the local transaction.
    A the end, release the local connextion if any.
    """
    def wrap(f):
        
        def wrapped(*args, **kwargs):
            if kwargs['cnx'] is None:
                cnx  = getConnection()
                kwargs['cnx'] = cnx
                local = True
            else:
                local = False
            try:
                return f(*args, **kwargs)
            finally:
                if local : 
                    if commit :
                        cnx.commit()
                        releaseConnection(cnx)    
        return wrapped     
        
    return wrap

class ICrud():
    '''
    CRUD interface
    '''
    def select(self):
        raise NotImplementedError
    
    def update(self):
        raise NotImplementedError
    
    def create(self):
        raise NotImplementedError
    
    def delete(selfself):
        raise NotImplementedError    
    
    
    

class TrackedCellTower(ICrud):
    '''
    A cell tower where the device has been registered
    '''
    
    cellId = None
    opId = None
    country = None
    timestamp = None
    
    TABLE_NAME = "track_cell_tower"
    
    @classmethod
    def create_sql(cls):
        return """
            create table %s
                (cellId text,
                 opId text,
                 country text,
                 datetime text)
            """ % (TrackedCellTower.TABLE_NAME,)

        
    def select(self):
        pass
    
    def update(self):
        pass
    
    @with_transaction_required(True)
    def create(self, cnx=None):    
        cursor = cnx.cursor()
        cursor.execute("insert into %s values(?,?,?,?)" % self.TABLE_NAME, (self.cellId, self.opId, self.country, self.timestamp))
        cursor.close()
    
    @with_transaction_required(True)    
    def delete(self,cnx=None):
        pass
    
    @classmethod
    @with_transaction_required(True)
    def clear(self, cnx=None):
        cursor = cnx.cursor()
        cursor.execute("DELETE FROM %s " % self.TABLE_NAME)
        cursor.close()
    
    @classmethod
    @with_transaction_required(False)
    def free_mobile_record(self, cnx=None):
        resu = 0    
        cursor = cnx.cursor()
        for free_op_code in FREE_MOBILE_OP_CODE:
            cursor.execute("select count() from %s where opId=? and country=?" % self.TABLE_NAME, (free_op_code, FREE_MOBILE_COUNTRY[0]))
            for count in cursor:           
                logging.info("found Free Mobile record %s" % count[0])      
                resu = resu + int(count[0])   
        cursor.close()                     
        return resu
        
    @classmethod
    @with_transaction_required(False)
    def orange_record(self, cnx=None):
        resu = 0    
        cursor = cnx.cursor()
        for orange_op_code in ORANGE_OP_CODE:
            cursor.execute("select count() from %s where opId=? and country=?" % self.TABLE_NAME, (orange_op_code, ORANGE_COUNTRY[0]))
            for count in cursor:   
                logging.info("Found Orange record %s" % count[0])              
                resu = resu + int(count[0])                
        cursor.close()      
        return resu
    
    @classmethod
    @with_transaction_required(False)
    def total_record(self, cnx=None):
        resu = 0        
        cursor = cnx.cursor()    
        cursor.execute("select count() from %s " % self.TABLE_NAME)
        for count in cursor:
                logging.info("Found Total record %s" % count[0])
                resu = resu + int(count[0])                
        cursor.close() 
        return resu
        