# -*- encoding: UTF-8 -*-
# 
# This a project generated by Pyjama with default layout
# 
# Copyright (C) 2012  maemo
# 
# This program is free software: you can redistribute
# it and/or modify it under the terms of the GNU
# General Public License as published by the Free
# Software Foundation, either version 3 of the License,
# or (at your option) any later version.
# 
# This program is distributed in the hope that it will
# be useful, but WITHOUT ANY WARRANTY; without even the
# implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE. See the GNU General Public
# License for more details.
# 
# You should have received a copy of the GNU General
# Public License along with this program. If not, see
# <http://www.gnu.org/licenses/>
# 


'''
Created on 01 March 2012 04:19:29

@author: maemo
'''

import gtk
import hildon
import logging
import os.path
import logging
import time
import datetime
import pango

import urllib



from mougeon.gui.gtk.widget import  *
from mougeon.gui.hildon.widget import *
from mougeon.gui.gtk.utils import fill_widget_with_logo, LOGO_PIXBUF, ORAGNE_PIXBUF, FREE_PIXBUF
from mougeon.gui.hildon.utils import show_about_dialog, call_handled_method, not_yet_implemented, \
                                    MougeonStackableWindow, ASYNC_EXCEPTION_HANDLER_INSTANCE, AsyncTask, \
                                    StopSignalException, show_banner_information, show_note_information
from mougeon.core import facade
from mougeon.core.model import ITrackerListener

from mougeon.common import version

version.getInstance().submitRevision("$Revision: 48 $")

from mougeon.gui.hildon.portrait import FremantleRotation


gtk.gdk.threads_init()


def show_new_window(window):
    program = hildon.Program.get_instance()
    program.add_window(window)
    window.show_all()


def _show_current_operator_view(facade):
        window = CurrentOperatorView(facade)
        show_new_window(window)
        
def show_current_operator_view(facade):
    call_handled_method(_show_current_operator_view,facade)


def _show_ratio_operator_view(facade):
        window = RatioView(facade)
        show_new_window(window)
        
def show_ratio_operator_view(facade):
    call_handled_method(_show_ratio_operator_view,facade)



class mougeonGui(object):
    '''
    This is the GUI of mougeon
    '''

    _last_folder = None

    def __init__(self):
        '''
        Create a new application GUI
        '''
        self.program = hildon.Program.get_instance()     
        self.facade = facade.mougeon()       
        ASYNC_EXCEPTION_HANDLER_INSTANCE.start_async_exception_handler()
        self.facade.start_tracker_record()
        self.init_main_view()   




    def init_main_view(self):
        '''
        create a new window for the main view of the application
        '''
       
        # display a spashscreen
        window = SplashScreenView(self.facade)
        window.connect("destroy", self.quit_application, None)
        show_new_window(window)
        
        # autorotayion !!!
        FremantleRotation("mougeon",main_window=window)       

        # TODO do some stuff here               
        show_current_operator_view(self.facade)

    def quit_application(self, widget, data):
        self.facade.stop_tracker_record()
        ASYNC_EXCEPTION_HANDLER_INSTANCE.stop_async_exception_handler()        
        gtk.main_quit()
        

        
      
        
    def run(self):
        # the splash screen  is displayed,now show the home screen in a fancy tansition               
        gtk.main()


      

    
class SplashScreenView(MougeonStackableWindow):
    '''
    This is the first view of the application e.g. the main view.  
    '''

    def __init__(self, facade):
        self.facade = facade
        MougeonStackableWindow.__init__(self)

    def init_center_view(self, centerview):
        fill_widget_with_logo(centerview)

    
    def _show_current_op_view(self, widget, data):
         call_handled_method(show_current_operator_view, data)
         
    def _show_ratio_op_view(self, widget, data):
         call_handled_method(show_ratio_operator_view, data)         

    def _reset_data(self, widget, data):
        call_handled_method(self.reset_data, data)
        
    def reset_data(self, facade):
        # open confirm dialog box
        message = "This will remove all tracked cell tower. Are you sure?"
        parent = hildon.WindowStack.get_default().peek()
        note = hildon.hildon_note_new_confirmation(parent, message)
   
        response = gtk.Dialog.run(note)   
        note.destroy()
        
        if response == gtk.RESPONSE_OK:
                # if confirm
                facade.reset_data()
                show_banner_information("data cleared")


    def init_menu(self, menu):
        # add specific application menu here
        currentOpMenuBtn = hildon.GtkButton(gtk.HILDON_SIZE_AUTO);
        currentOpMenuBtn.set_label("Current");
        currentOpMenuBtn.connect("clicked", self._show_current_op_view, self.facade)
        menu.append(currentOpMenuBtn)
        
        ratioOpMenuBtn = hildon.GtkButton(gtk.HILDON_SIZE_AUTO);
        ratioOpMenuBtn.set_label("Ratio");
        ratioOpMenuBtn.connect("clicked", self._show_ratio_op_view, self.facade)
        menu.append(ratioOpMenuBtn)
        
        
        resetMenuBtn = hildon.GtkButton(gtk.HILDON_SIZE_AUTO);
        resetMenuBtn.set_label("Reset...");
        resetMenuBtn.connect("clicked", self._reset_data, self.facade)
        menu.append(resetMenuBtn)
                                                                                                                                                          

class CurrentOperatorView(MougeonStackableWindow, ITrackerListener):
    '''
    This view simply show the current used operator
    '''
    def __init__(self, facade):
         self.facade = facade
         MougeonStackableWindow.__init__(self, "Current Operator")
         
         self.facade.register_tracker_listener(self)
         self.connect("destroy", self._on_destroy_window_event,  None)
    

    def _on_destroy_window_event(self, widget, data):
        self.facade.unregister_tracker_listener(self)        
        
        
    def record_operator(self, tracker, tct):
         gtk.gdk.threads_enter()
         call_handled_method(self.refresh_view)
         gtk.gdk.threads_leave()
         logging.debug("Current operator view updated")
         
    def init_menu(self, menu):
        
        refreshMenuBtn = hildon.GtkButton(gtk.HILDON_SIZE_AUTO);
        refreshMenuBtn.set_label("Refresh");
        refreshMenuBtn.connect("clicked", self._refresh_view, None)
        menu.append(refreshMenuBtn)

    def _refresh_view(self, widget, data):        
        call_handled_method(self.refresh_view)    
        
        
    def refresh_view(self):       
        for child in self.centerview.get_children():
                logging.debug("removing children from cenetrview...")
                self.centerview.remove(child)           
        self.init_center_view(self.centerview)  
        self.centerview.show_all()      
        
    def init_center_view(self, centerview):
                 
         if self.facade.is_using_freemobile():
            fill_widget_with_logo(centerview, FREE_PIXBUF )
            hildon.hildon_play_system_sound ("mouton.wav")
         else:
            fill_widget_with_logo(centerview, ORAGNE_PIXBUF )
            hildon.hildon_play_system_sound ("pigeon.wav")
         
        
                 
    
class RatioView(MougeonStackableWindow, ITrackerListener):
    '''
    This view show side by side Free and Orange cell tower usage
    '''
     
    def __init__(self, facade):
        self.facade = facade
        MougeonStackableWindow.__init__(self, "Ratio")
        
        self.facade.register_tracker_listener(self)
        self.connect("destroy", self._on_destroy_window_event,  None)



    def _on_destroy_window_event(self, widget, data):
        self.facade.unregister_tracker_listener(self)
        
        
    def record_operator(self, tracker, tct):
         gtk.gdk.threads_enter()
         call_handled_method(self.refresh_view)
         gtk.gdk.threads_leave()
         logging.debug("Ratio view updated")

    def init_menu(self, menu):
        
        refreshMenuBtn = hildon.GtkButton(gtk.HILDON_SIZE_AUTO);
        refreshMenuBtn.set_label("Refresh");
        refreshMenuBtn.connect("clicked", self._refresh_view, None)
        menu.append(refreshMenuBtn)

    def _refresh_view(self, widget, data):
        call_handled_method(self.refresh_view)    

    def refresh_view(self):
        for child in self.centerview.get_children():
                logging.debug("removing children from centerview...")
                self.centerview.remove(child)     
        self.init_center_view(self.centerview)
        self.centerview.show_all()
        

        
    def init_center_view(self, centerview):
        
        
         centerview.pack_start(self.justifyLeft(gtk.Label("Cell Tower ratio:")), expand=False)
         
         hbox = gtk.HBox()
         hbox.add(FreeThumbnail(self.facade))
         hbox.add(OrangeThumbnail(self.facade))
         centerview.pack_start(hbox)
         
         message = "You are mainly using %s" % self.facade.get_mainly_used_operator().name 
         centerview.pack_start(gtk.Label(message))
        
                 
         
                    
    