# -*- encoding: UTF-8 -*-
# 
# This a project generated by Pyjama with default layout
# 
# Copyright (C) 2012  maemo
# 
# This program is free software: you can redistribute
# it and/or modify it under the terms of the GNU
# General Public License as published by the Free
# Software Foundation, either version 3 of the License,
# or (at your option) any later version.
# 
# This program is distributed in the hope that it will
# be useful, but WITHOUT ANY WARRANTY; without even the
# implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE. See the GNU General Public
# License for more details.
# 
# You should have received a copy of the GNU General
# Public License along with this program. If not, see
# <http://www.gnu.org/licenses/>
# 

'''
Created on 01 March 2012 04:19:29

@author: maemo
'''

import gtk
import hildon

from mougeon.common import version
from mougeon.core import model

version.getInstance().submitRevision("$Revision: 4 $")


from  mougeon.gui.gtk.utils import FREE_PIXBUF, ORAGNE_PIXBUF


class OperatorThumbnail(gtk.VBox):
    def __init__(self):
         gtk.VBox.__init__(self)
         
         
    def add_picture(self, miniature):        
        image = gtk.Image()
        image.set_from_pixbuf(miniature)
        self.pack_start(image, False, False, 0)
        

    def add_button(self, op_name, usage_percent, miniature):
        self.button = hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        self.button.set_title(op_name)
        self.button.set_value(str(usage_percent))
        image = gtk.Image()
        image.set_from_pixbuf(miniature)
        self.button.set_image(image)
        self.pack_start(self.button, False, False, 0)   
        
    def connect_action(self, *argv, **kwarg):
         self.button.connect("clicked", *argv, **kwarg)     

class FreeThumbnail(OperatorThumbnail):
    
    def __init__(self, facade):
         OperatorThumbnail.__init__(self)
                         
         #self.add_picture(FREE_PIXBUF)         
         self.add_button(model.FREE_OPERATOR.name, facade.freemobile_percent(), FREE_PIXBUF)

class OrangeThumbnail(OperatorThumbnail):
    
    def __init__(self, facade):
         OperatorThumbnail.__init__(self)
                         
         #self.add_picture(ORAGNE_PIXBUF)         
         self.add_button(model.ORANGE_OPERATOR.name, facade.orange_percent(), ORAGNE_PIXBUF)



         
