"""
This file is meant to make it easy to load the main features of MoviePy
by simply typing:

>>> from moviepy.editor import *

In particular it will load many effects from the video.fx and audio.fx
folders and turn them into VideoClip methods, so that instead of
>>> clip.fx( vfx.resize, 2 ) # or equivalently vfx.resize(clip, 2)
we can write
>>> clip.resize(2)

It also starts a PyGame session (if PyGame is installed) and enables
clip.preview().
"""

# Note that these imports could have been performed in the __init__.py
# file, but this would make the loading of moviepy slower.

# Clips

from .video.io.VideoFileClip import VideoFileClip
from .video.VideoClip import VideoClip, ImageClip, ColorClip, TextClip
from .video.compositing.CompositeVideoClip import CompositeVideoClip
from .video.compositing.concatenate import concatenate

from .audio.AudioClip import AudioClip, CompositeAudioClip
from .audio.io.AudioFileClip import AudioFileClip

# FX

import moviepy.video.fx as vfx
import moviepy.audio.fx as afx
import moviepy.video.compositing.transitions as transfx

# Tools

import moviepy.video.tools as videotools
import moviepy.video.io.ffmpeg_tools as ffmpeg_tools
from .tools import cvsecs

try:
    from .video.io.sliders import sliders
except ImportError:
    pass

# The next loop transforms many effects into VideoClip methods so that
# they can be walled with myclip.resize(width=500) instead of 
# myclip.fx( vfx.resize, width= 500)
for method in ["vfx.crop",
               "vfx.resize",
               "vfx.margin",
               "vfx.fadein",
               "vfx.fadeout",
               "vfx.speedx",
               "afx.volumex",
               "afx.audio_fadein",
               "afx.audio_fadeout",
               "transfx.crossfadein",
               "transfx.crossfadeout"]:
    exec("VideoClip.%s = %s"%( method.split('.')[1], method))


for method in ["afx.audio_fadein",
               "afx.audio_fadeout"]:
    exec("AudioClip.%s = %s"%( method.split('.')[1], method))


#-----------------------------------------------------------------
# Previews: try to import pygame


# Add methods preview and show (only if pygame installed)
try:
    from moviepy.video.io.preview import show, preview
except ImportError:
    def preview(self, *args, **kwargs):
        """ NOT AVAILABLE : clip.preview requires Pygame installed  """
        raise ImportError("clip.preview requires Pygame installed")
    def show(self, *args, **kwargs):
        """ NOT AVAILABLE : clip.show requires Pygame installed  """
        raise ImportError("clip.show requires Pygame installed")


VideoClip.preview = preview
VideoClip.show = show

try:
    from moviepy.audio.io.preview import preview
except ImportError:
    def preview(self, *args, **kwargs):
        """ NOT AVAILABLE : clip.preview requires Pygame installed  """
        raise ImportError("clip.preview requires Pygame installed")

AudioClip.preview = preview

        

