property_table = {   'angle': {   'comment': 'select angle',
                 'get': True,
                 'max': None,
                 'min': 0.0,
                 'name': 'angle',
                 'set': True,
                 'step': True,
                 'type': 'int'},
    'aspect': {   'comment': '',
                  'get': True,
                  'max': None,
                  'min': None,
                  'name': 'aspect',
                  'set': False,
                  'step': False,
                  'type': 'float'},
    'audio_bitrate': {   'comment': '',
                         'get': True,
                         'max': None,
                         'min': None,
                         'name': 'audio_bitrate',
                         'set': False,
                         'step': False,
                         'type': 'int'},
    'audio_codec': {   'comment': '',
                       'get': True,
                       'max': None,
                       'min': None,
                       'name': 'audio_codec',
                       'set': False,
                       'step': False,
                       'type': 'string'},
    'audio_delay': {   'comment': '',
                       'get': True,
                       'max': 100.0,
                       'min': -100.0,
                       'name': 'audio_delay',
                       'set': True,
                       'step': True,
                       'type': 'float'},
    'audio_format': {   'comment': '',
                        'get': True,
                        'max': None,
                        'min': None,
                        'name': 'audio_format',
                        'set': False,
                        'step': False,
                        'type': 'int'},
    'balance': {   'comment': 'change audio balance',
                   'get': True,
                   'max': 1.0,
                   'min': -1.0,
                   'name': 'balance',
                   'set': True,
                   'step': True,
                   'type': 'float'},
    'border': {   'comment': '',
                  'get': True,
                  'max': 1.0,
                  'min': 0.0,
                  'name': 'border',
                  'set': True,
                  'step': True,
                  'type': 'flag'},
    'brightness': {   'comment': '',
                      'get': True,
                      'max': 100.0,
                      'min': -100.0,
                      'name': 'brightness',
                      'set': True,
                      'step': True,
                      'type': 'int'},
    'channels': {   'comment': '',
                    'get': True,
                    'max': None,
                    'min': None,
                    'name': 'channels',
                    'set': False,
                    'step': False,
                    'type': 'int'},
    'chapter': {   'comment': 'select chapter',
                   'get': True,
                   'max': None,
                   'min': 0.0,
                   'name': 'chapter',
                   'set': True,
                   'step': True,
                   'type': 'int'},
    'contrast': {   'comment': '',
                    'get': True,
                    'max': 100.0,
                    'min': -100.0,
                    'name': 'contrast',
                    'set': True,
                    'step': True,
                    'type': 'int'},
    'deinterlace': {   'comment': '',
                       'get': True,
                       'max': 1.0,
                       'min': 0.0,
                       'name': 'deinterlace',
                       'set': True,
                       'step': True,
                       'type': 'flag'},
    'demuxer': {   'comment': 'demuxer used',
                   'get': True,
                   'max': None,
                   'min': None,
                   'name': 'demuxer',
                   'set': False,
                   'step': False,
                   'type': 'string'},
    'filename': {   'comment': 'file playing wo path',
                    'get': True,
                    'max': None,
                    'min': None,
                    'name': 'filename',
                    'set': False,
                    'step': False,
                    'type': 'string'},
    'fps': {   'comment': '',
               'get': True,
               'max': None,
               'min': None,
               'name': 'fps',
               'set': False,
               'step': False,
               'type': 'float'},
    'framedropping': {   'comment': '1 = soft, 2 = hard',
                         'get': True,
                         'max': 2.0,
                         'min': 0.0,
                         'name': 'framedropping',
                         'set': True,
                         'step': True,
                         'type': 'int'},
    'fullscreen': {   'comment': '',
                      'get': True,
                      'max': 1.0,
                      'min': 0.0,
                      'name': 'fullscreen',
                      'set': True,
                      'step': True,
                      'type': 'flag'},
    'gamma': {   'comment': '',
                 'get': True,
                 'max': 100.0,
                 'min': -100.0,
                 'name': 'gamma',
                 'set': True,
                 'step': True,
                 'type': 'int'},
    'height': {   'comment': '"display" height',
                  'get': True,
                  'max': None,
                  'min': None,
                  'name': 'height',
                  'set': False,
                  'step': False,
                  'type': 'int'},
    'hue': {   'comment': '',
               'get': True,
               'max': 100.0,
               'min': -100.0,
               'name': 'hue',
               'set': True,
               'step': True,
               'type': 'int'},
    'length': {   'comment': 'length of file in seconds',
                  'get': True,
                  'max': None,
                  'min': None,
                  'name': 'length',
                  'set': False,
                  'step': False,
                  'type': 'time'},
    'loop': {   'comment': 'as -loop',
                'get': True,
                'max': None,
                'min': -1.0,
                'name': 'loop',
                'set': True,
                'step': True,
                'type': 'int'},
    'metadata': {   'comment': 'list of metadata key/value',
                    'get': True,
                    'max': None,
                    'min': None,
                    'name': 'metadata',
                    'set': False,
                    'step': False,
                    'type': 'str list'},
    'mute': {   'comment': '',
                'get': True,
                'max': 1.0,
                'min': 0.0,
                'name': 'mute',
                'set': True,
                'step': True,
                'type': 'flag'},
    'ontop': {   'comment': '',
                 'get': True,
                 'max': 1.0,
                 'min': 0.0,
                 'name': 'ontop',
                 'set': True,
                 'step': True,
                 'type': 'flag'},
    'osdlevel': {   'comment': 'as -osdlevel',
                    'get': True,
                    'max': 3.0,
                    'min': 0.0,
                    'name': 'osdlevel',
                    'set': True,
                    'step': True,
                    'type': 'int'},
    'panscan': {   'comment': '',
                   'get': True,
                   'max': 1.0,
                   'min': 0.0,
                   'name': 'panscan',
                   'set': True,
                   'step': True,
                   'type': 'float'},
    'path': {   'comment': 'file playing',
                'get': True,
                'max': None,
                'min': None,
                'name': 'path',
                'set': False,
                'step': False,
                'type': 'string'},
    'percent_pos': {   'comment': 'position in percent',
                       'get': True,
                       'max': 100.0,
                       'min': 0.0,
                       'name': 'percent_pos',
                       'set': True,
                       'step': True,
                       'type': 'int'},
    'rootwin': {   'comment': '',
                   'get': True,
                   'max': 1.0,
                   'min': 0.0,
                   'name': 'rootwin',
                   'set': True,
                   'step': True,
                   'type': 'flag'},
    'samplerate': {   'comment': '',
                      'get': True,
                      'max': None,
                      'min': None,
                      'name': 'samplerate',
                      'set': False,
                      'step': False,
                      'type': 'int'},
    'saturation': {   'comment': '',
                      'get': True,
                      'max': 100.0,
                      'min': -100.0,
                      'name': 'saturation',
                      'set': True,
                      'step': True,
                      'type': 'int'},
    'speed': {   'comment': 'as -speed',
                 'get': True,
                 'max': 100.0,
                 'min': 0.01,
                 'name': 'speed',
                 'set': True,
                 'step': True,
                 'type': 'float'},
    'stream_end': {   'comment': 'end pos in stream',
                      'get': True,
                      'max': None,
                      'min': 0.0,
                      'name': 'stream_end',
                      'set': False,
                      'step': False,
                      'type': 'pos'},
    'stream_length': {   'comment': '(end - start)',
                         'get': True,
                         'max': None,
                         'min': 0.0,
                         'name': 'stream_length',
                         'set': False,
                         'step': False,
                         'type': 'pos'},
    'stream_pos': {   'comment': 'position in stream',
                      'get': True,
                      'max': None,
                      'min': 0.0,
                      'name': 'stream_pos',
                      'set': True,
                      'step': False,
                      'type': 'pos'},
    'stream_start': {   'comment': 'start pos in stream',
                        'get': True,
                        'max': None,
                        'min': 0.0,
                        'name': 'stream_start',
                        'set': False,
                        'step': False,
                        'type': 'pos'},
    'sub': {   'comment': 'select subtitle stream',
               'get': True,
               'max': None,
               'min': -1.0,
               'name': 'sub',
               'set': True,
               'step': True,
               'type': 'int'},
    'sub_alignment': {   'comment': 'subtitle alignment',
                         'get': True,
                         'max': 2.0,
                         'min': 0.0,
                         'name': 'sub_alignment',
                         'set': True,
                         'step': True,
                         'type': 'int'},
    'sub_delay': {   'comment': '',
                     'get': True,
                     'max': None,
                     'min': None,
                     'name': 'sub_delay',
                     'set': True,
                     'step': True,
                     'type': 'float'},
    'sub_demux': {   'comment': 'select subs from demux',
                     'get': True,
                     'max': None,
                     'min': -1.0,
                     'name': 'sub_demux',
                     'set': True,
                     'step': True,
                     'type': 'int'},
    'sub_file': {   'comment': 'select file subtitles',
                    'get': True,
                    'max': None,
                    'min': -1.0,
                    'name': 'sub_file',
                    'set': True,
                    'step': True,
                    'type': 'int'},
    'sub_forced_only': {   'comment': '',
                           'get': True,
                           'max': 1.0,
                           'min': 0.0,
                           'name': 'sub_forced_only',
                           'set': True,
                           'step': True,
                           'type': 'flag'},
    'sub_pos': {   'comment': 'subtitle position',
                   'get': True,
                   'max': 100.0,
                   'min': 0.0,
                   'name': 'sub_pos',
                   'set': True,
                   'step': True,
                   'type': 'int'},
    'sub_scale': {   'comment': 'subtitles font size',
                     'get': True,
                     'max': 100.0,
                     'min': 0.0,
                     'name': 'sub_scale',
                     'set': True,
                     'step': True,
                     'type': 'float'},
    'sub_source': {   'comment': 'select subtitle source',
                      'get': True,
                      'max': 2.0,
                      'min': -1.0,
                      'name': 'sub_source',
                      'set': True,
                      'step': True,
                      'type': 'int'},
    'sub_visibility': {   'comment': 'show/hide subtitles',
                          'get': True,
                          'max': 1.0,
                          'min': 0.0,
                          'name': 'sub_visibility',
                          'set': True,
                          'step': True,
                          'type': 'flag'},
    'sub_vob': {   'comment': 'select vobsubs',
                   'get': True,
                   'max': None,
                   'min': -1.0,
                   'name': 'sub_vob',
                   'set': True,
                   'step': True,
                   'type': 'int'},
    'switch_angle': {   'comment': 'select DVD angle',
                        'get': True,
                        'max': 255.0,
                        'min': -2.0,
                        'name': 'switch_angle',
                        'set': True,
                        'step': True,
                        'type': 'int'},
    'switch_audio': {   'comment': 'select audio stream',
                        'get': True,
                        'max': 255.0,
                        'min': -2.0,
                        'name': 'switch_audio',
                        'set': True,
                        'step': True,
                        'type': 'int'},
    'switch_program': {   'comment': '(see TAB default keybind)',
                          'get': True,
                          'max': 65535.0,
                          'min': -1.0,
                          'name': 'switch_program',
                          'set': True,
                          'step': True,
                          'type': 'int'},
    'switch_title': {   'comment': 'select DVD title',
                        'get': True,
                        'max': 255.0,
                        'min': -2.0,
                        'name': 'switch_title',
                        'set': True,
                        'step': True,
                        'type': 'int'},
    'switch_video': {   'comment': 'select video stream',
                        'get': True,
                        'max': 255.0,
                        'min': -2.0,
                        'name': 'switch_video',
                        'set': True,
                        'step': True,
                        'type': 'int'},
    'teletext_format': {   'comment': '0 - opaque,\n1 - transparent,\n2 - opaque inverted,\n3 - transp. inv.',
                           'get': True,
                           'max': 3.0,
                           'min': 0.0,
                           'name': 'teletext_format',
                           'set': True,
                           'step': True,
                           'type': 'int'},
    'teletext_half_page': {   'comment': '0 - off, 1 - top half,\n2- bottom half',
                              'get': True,
                              'max': 2.0,
                              'min': 0.0,
                              'name': 'teletext_half_page',
                              'set': True,
                              'step': True,
                              'type': 'int'},
    'teletext_mode': {   'comment': '0 - off, 1 - on',
                         'get': True,
                         'max': 1.0,
                         'min': 0.0,
                         'name': 'teletext_mode',
                         'set': True,
                         'step': True,
                         'type': 'flag'},
    'teletext_page': {   'comment': '',
                         'get': True,
                         'max': 799.0,
                         'min': 0.0,
                         'name': 'teletext_page',
                         'set': True,
                         'step': True,
                         'type': 'int'},
    'teletext_subpage': {   'comment': '',
                            'get': True,
                            'max': 64.0,
                            'min': 0.0,
                            'name': 'teletext_subpage',
                            'set': True,
                            'step': True,
                            'type': 'int'},
    'time_pos': {   'comment': 'position in seconds',
                    'get': True,
                    'max': None,
                    'min': 0.0,
                    'name': 'time_pos',
                    'set': True,
                    'step': True,
                    'type': 'time'},
    'tv_brightness': {   'comment': '',
                         'get': True,
                         'max': 100.0,
                         'min': -100.0,
                         'name': 'tv_brightness',
                         'set': True,
                         'step': True,
                         'type': 'int'},
    'tv_contrast': {   'comment': '',
                       'get': True,
                       'max': 100.0,
                       'min': -100.0,
                       'name': 'tv_contrast',
                       'set': True,
                       'step': True,
                       'type': 'int'},
    'tv_hue': {   'comment': '',
                  'get': True,
                  'max': 100.0,
                  'min': -100.0,
                  'name': 'tv_hue',
                  'set': True,
                  'step': True,
                  'type': 'int'},
    'tv_saturation': {   'comment': '',
                         'get': True,
                         'max': 100.0,
                         'min': -100.0,
                         'name': 'tv_saturation',
                         'set': True,
                         'step': True,
                         'type': 'int'},
    'video_bitrate': {   'comment': '',
                         'get': True,
                         'max': None,
                         'min': None,
                         'name': 'video_bitrate',
                         'set': False,
                         'step': False,
                         'type': 'int'},
    'video_codec': {   'comment': '',
                       'get': True,
                       'max': None,
                       'min': None,
                       'name': 'video_codec',
                       'set': False,
                       'step': False,
                       'type': 'string'},
    'video_format': {   'comment': '',
                        'get': True,
                        'max': None,
                        'min': None,
                        'name': 'video_format',
                        'set': False,
                        'step': False,
                        'type': 'int'},
    'volume': {   'comment': 'change volume',
                  'get': True,
                  'max': 100.0,
                  'min': 0.0,
                  'name': 'volume',
                  'set': True,
                  'step': True,
                  'type': 'float'},
    'vsync': {   'comment': '',
                 'get': True,
                 'max': 1.0,
                 'min': 0.0,
                 'name': 'vsync',
                 'set': True,
                 'step': True,
                 'type': 'flag'},
    'width': {   'comment': '"display" width',
                 'get': True,
                 'max': None,
                 'min': None,
                 'name': 'width',
                 'set': False,
                 'step': False,
                 'type': 'int'}}