#!/usr/bin/env python

from os.path import basename

from .core import Multipart, Field


def encode(fields):
    field_list = []

    for name, value in fields.iteritems():
        if hasattr(value, 'read'):
            # Quacks like a file
            field_list.append(
                Field(name, fileobj=value, filename=basename(value.name))
            )

        else:
            field_list.append(Field(name, value))

    return Multipart(field_list)
