def exclusive_overlap(haystack, needle):
    '''
    Returns how many bytes of needle that haystack ends with. You might say
    that it returns how many bytes that "overlap" between the two.

    For example, ``exclusive_overlap("hellofoo", "foobar")`` would return 3.

    Although, if the haystack ends with needle in its entirety, it doesn't
    count as an overlap, so the function will return 0.
    '''

    haystack_length, needle_length = len(haystack), len(needle)
    haystack_index, needle_index = haystack_length, needle_length

    # If the needle is longer than the haystack, we'll just need to check the
    # inital bytes of the needle.
    if haystack_length < needle_length:
        needle_index = haystack_length

    overlap_length = 0

    # Go through the haystack and needle in reverse.
    while needle_index > 0 and haystack_index > 0:
        if needle[needle_index - 1] == haystack[haystack_index - 1]:
            # Needle and haystack seems to match so far, check the next bytes.
            overlap_length += 1
            haystack_index -= 1

        else:
            # If the needle doesn't match anymore; bail out.
            if overlap_length:
                overlap_length = 0
                break

        needle_index -= 1

    # Worst case scenario, haystack ended with needle
    if overlap_length == needle_length:
        overlap_length = 0

    return overlap_length
