#!/bin/sh

DOC=$(dirname $0)
ROOT=${DOC}/..
FILES=${ROOT}/src/model.py

rm -f 	${DOC}/*.html \
	${DOC}/*.css \
	${DOC}/*.js \
	${DOC}/*.txt \
	${DOC}/*.png \
	${DOC}/*.gif

epydoc	-o ${DOC} \
	-v --html \
	--show-imports \
	-n multiVAC \
	--graph=all \
	${FILES}

sed -i 's/\(Generated by Epydoc\).*/\1/g' ${DOC}/*.html
