#!/usr/bin/env python2.7
'Static site generation'

# Copyright (C) 2013 Kaashif Hymabaccus
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from muon.post import Post
from jinja2 import Environment, FileSystemLoader
from pkg_resources import resource_filename
import ConfigParser, os, shutil

NAME = 'default blog'
STYLE = ''
POSTDIR=''
POSTS = []
PAGES = {}
SITEDIR = '_site'
env = None

def init_config():
	'''Initialises config etc'''
	global NAME, STYLE, POSTS, POSTDIR, PAGES, SITEDIR, env
	config = ConfigParser.ConfigParser()
	config.read('config.ini')
	tempdir = config.get('templates', 'dir')
	env = Environment(loader=FileSystemLoader(tempdir))
	css_file = config.get('blog', 'style')
	NAME = config.get('blog', 'name')
	POSTDIR = config.get('post', 'dir')
	STYLE = ''.join(open(css_file, 'r').readlines())
	POSTS = Post.get_all(STYLE, NAME, POSTDIR, env)
	PAGES = dict.fromkeys(config.get('blog', 'pages').split(' '), '')
	SITEDIR = config.get('blog', 'dir')

def init_pages():
	'''Fills pages with rendered content'''
	recent_posts = Post.show_recent(STYLE, NAME, POSTDIR, env)
	for page_name in PAGES.keys():
		template = env.get_template('%s.html' % page_name)
		PAGES[page_name] = template.render(
				all_posts=Post.get_all(STYLE, NAME, POSTDIR, env),
				recent_posts=recent_posts,
				style=STYLE,
				title='%s: %s' % (NAME, page_name.title()),
				latex=False)

def init():
	'''Inits everything'''
	init_config()
	init_pages()

def show_post(post_id):
	'''Renders HTML of post from markdown'''
	if (post_id < len(POSTS)):
		return POSTS[post_id].show_content()
	else:
		template = env.get_template('error.html')
		return template.render(
				style=STYLE,
				title='%s: Error' % NAME,
				latex=False)

def generate():
	'''Generates the static site'''
	try:
		shutil.rmtree('_site')
	except OSError:
		pass
	os.mkdir('_site')
	shutil.copytree('static', '_site/static')
	post_txts = []
	for post_id in xrange(0, len(POSTS)):
		post_txts.append(show_post(post_id))
	os.chdir('_site')
	open('index.html', 'w').write(PAGES['home'])
	for page,content in PAGES.items():
		os.mkdir(page)
		os.chdir(page)
		open('index.html', 'w').write(content)
		os.chdir('..')
	os.mkdir('post')
	os.chdir('post')
	post_id = -1
	for post_txt in post_txts:
		post_id += 1
		os.mkdir(str(post_id))
		os.chdir(str(post_id))
		open('index.html', 'w').write(post_txt)
		os.chdir('..')
	os.chdir('../..')

def create_blog():
	'''Creates blog directory'''
	postdir = resource_filename(__name__, 'def/_posts')
	styledir = resource_filename(__name__, 'def/_style')
	templatedir = resource_filename(__name__, 'def/_templates')
	def_config = resource_filename(__name__, 'def/config.ini')
	os.mkdir('static')
	shutil.copyfile(def_config, 'config.ini')
	shutil.copytree(postdir, '_posts')
	shutil.copytree(styledir, '_style')
	shutil.copytree(templatedir, '_templates')

if __name__ == "__main__":
	init()
	generate()

