import muon.static
import sys, os
import SimpleHTTPServer, SocketServer
from ConfigParser import ConfigParser
from subprocess import call

def generate():
	'''Calls static generate'''
	muon.static.init()
	muon.static.generate()

def serve():
	'''Serves site up'''
	generate()
	os.chdir(muon.static.SITEDIR)
	try:
		port = 8000
		Handler = SimpleHTTPServer.SimpleHTTPRequestHandler
		httpd = SocketServer.TCPServer(("", port), Handler)
		print('Serving at http://127.0.0.1:%d' % port)
		httpd.serve_forever()
	except KeyboardInterrupt:
		print('Shutting down ...')
		sys.exit(0)

def upload():
	'''Uploads site to server'''
	generate()
	config = ConfigParser()
	config.read('config.ini')
	user = config.get('remote', 'user')
	server = config.get('remote', 'server')
	remote_dir = config.get('remote', 'dir')
	sitedir = config.get('blog', 'dir')
	uri = '%s@%s:%s' % (user, server, remote_dir)
	call(['rsync', '-a', '--delete', sitedir, uri])

def create():
	'''Creates default blog'''
	muon.static.create_blog()

