#!/usr/bin/env python2.7
'All post-related functions and objects'

# Copyright (C) 2013 Kaashif Hymabaccus
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from flask import render_template
from markdown import markdownFromFile
from glob import glob

class Post(object):
	'''A blog post, content and how to get to it'''
	def __init__(self, post_id, style, sitename, postdir, env):
		self.pid = post_id
		raw_posts = glob('%s/*.markdown' % postdir)
		raw_posts.sort()
		self.md_file = raw_posts[self.pid]
		self.md_content = open(self.md_file, 'r').readlines()
		self.html_file = self.md_file.replace('.markdown', '.html')
		markdownFromFile(self.md_file, self.html_file)
		self.html_content = open(self.html_file, 'r').readlines()
		self.style = style
		self.sitename = sitename
		self.env = env
		self.page_title = '%s: %s' % (self.sitename, self.get_title())

	def show_content(self):
		'''Renders post template with content inserted'''
		template = self.env.get_template('post.html')
		return template.render(
				post_content=''.join(self.html_content),
				style=self.style,
				title=self.page_title,
				latex=False)

	def get_title(self):
		'''Returns title string of post'''
		title_raw = self.md_content[0]
		return title_raw.replace('#', '')

	def get_date(self):
		'''Returns date post was written'''
		date_raw = self.md_content[1]
		return date_raw.replace('##', '')

	def get_desc(self):
		'''Gets short post description'''
		desc_raw = self.md_content[2]
		return desc_raw.replace('<!---', '').replace('-->', '')

	def get_url(self):
		'''Returns URL leading to post'''
		return '/post/' + str(self.pid)

	def show_excerpt(self):
		'''Returns first 20 lines of HTML'''
		exc = self.html_content
		exc = ''.join(exc[:20])
		exc.replace('h2', 'h3')
		exc.replace('h1', 'h2')
		exc += '</code></ul></p><a href=' + self.get_url() + '>Read more...</a>'
		exc += '<hr/><br/><br/>'
		return exc

	@classmethod
	def get_all(cls, style, name, postdir, env):
		'''Creates list of all possible post objects'''
		raw_posts = glob('%s/*.markdown' % postdir)
		posts = []
		for post_id in xrange(0, len(raw_posts)):
			posts.append(Post(post_id, style, name, postdir, env))
		return posts

	@classmethod
	def show_recent(cls, style, name, postdir, env):
		'''Constructs page with last 5 recent post excerpts'''
		recent_html = []
		all_posts = cls.get_all(style, name, postdir, env)
		if len(all_posts) < 5:
			for post in reversed(all_posts):
				recent_html.append(post.show_excerpt())
		else:
			for post in reversed(all_posts[5:]):
				recent_html.append(post.show_excerpt())
		recent_html.append('<p>See <a href="/archive">the archive</a> for more posts.</p>')
		return ''.join(recent_html)

