#!/usr/bin/env python2.7
'Static site generation'

from muon.post import Post
from muon.config import Config
from pkg_resources import resource_filename
import os, shutil

c = Config()

def init():
	'''Fills pages with rendered content'''
	recent_posts = Post.show_recent(c)
	for page_name in c.pages.keys():
		template = c.env.get_template('%s.html' % page_name)
		c.pages[page_name] = template.render(
				c=c,
				all_posts=Post.get_all(c),
				recent_posts=recent_posts,
				style=c.style,
				title='%s: %s' % (c.sitename, page_name.title()),
				latex=False)

def show_post(post_id):
	'''Renders HTML of post from markdown'''
	if (post_id < len(c.posts)):
		return c.posts[post_id].show_content()
	else:
		template = c.env.get_template('error.html')
		return template.render(
				c=c,
				style=c.style,
				title='%s: Error' % c.sitename,
				latex=False)

def generate():
	'''Generates the static site'''
	try:
		shutil.rmtree('_site')
	except OSError:
		pass
	os.mkdir('_site')
	shutil.copytree('static', '_site/static')
	post_txts = []
	for post_id in xrange(0, len(c.posts)):
		post_txts.append(show_post(post_id))
	os.chdir('_site')
	open('index.html', 'w').write(c.pages['home'])
	for page,content in c.pages.items():
		os.mkdir(page)
		os.chdir(page)
		open('index.html', 'w').write(content)
		os.chdir('..')
	os.mkdir('post')
	os.chdir('post')
	post_id = -1
	for post_txt in post_txts:
		post_id += 1
		os.mkdir(str(post_id))
		os.chdir(str(post_id))
		open('index.html', 'w').write(post_txt)
		os.chdir('..')
	os.chdir('../..')

def create_blog():
	'''Creates blog directory'''
	postdir = resource_filename(__name__, 'def/_posts')
	styledir = resource_filename(__name__, 'def/_style')
	templatedir = resource_filename(__name__, 'def/_templates')
	def_config = resource_filename(__name__, 'def/config.ini')
	os.mkdir('static')
	shutil.copyfile(def_config, 'config.ini')
	shutil.copytree(postdir, '_posts')
	shutil.copytree(styledir, '_style')
	shutil.copytree(templatedir, '_templates')

if __name__ == "__main__":
	init()
	generate()

