import muon.static
import sys, os
import SimpleHTTPServer, SocketServer
from ConfigParser import ConfigParser
from subprocess import call, CalledProcessError

def generate():
	'''Calls static generate'''
	muon.static.init()
	muon.static.generate()

def serve():
	'''Serves site up'''
	generate()
	try:
		os.chdir(muon.static.c.sitedir)
	except OSError:
		print('Could not change to site directory %s!' % muon.static.c.sitedir)
	try:
		port = 8000
		SocketServer.TCPServer.allow_reuse_address = True
		Handler = SimpleHTTPServer.SimpleHTTPRequestHandler
		httpd = SocketServer.TCPServer(("", port), Handler)
		print('Serving at http://127.0.0.1:%d' % port)
		httpd.serve_forever()
	except KeyboardInterrupt:
		print('Shutting down ...')
		httpd.shutdown()
		sys.exit(0)

def upload():
	'''Uploads site to server'''
	generate()
	config = ConfigParser()
	config.read('config.ini')
	user = config.get('remote', 'user')
	server = config.get('remote', 'server')
	remote_dir = config.get('remote', 'dir')
	sitedir = config.get('blog', 'dir')
	uri = '%s@%s:%s' % (user, server, remote_dir)
	try:
		call(['rsync', '-a', '--delete', sitedir, uri])
	except CalledProcessError:
		print('Could not rsync to server. Make sure configuration is correct and you have rsync installed.')

def create():
	'''Creates default blog'''
	muon.static.create_blog()

