from jinja2 import Environment, FileSystemLoader
from muon.post import Post
import ConfigParser, os

class Config(object):
	def __init__(self):
		tempdir = '_templates'
		css_file = '_style/style.css'
		self.env = None
		self.sitename = 'Example blog'
		self.postdir = '_posts'
		self.style = ''
		self.pages = {'home':'', 'about':'', 'contact':'', 'archive':''}
		self.sitedir = '_site'
		self.posts = []
		self.tagline = 'Something witty and funny'
	def read(self):
		config = ConfigParser.ConfigParser()
		config.read('config.ini')
		tempdir = config.get('templates', 'dir')
		css_file = config.get('blog', 'style')
		self.env = Environment(loader=FileSystemLoader(tempdir))
		self.sitename = config.get('blog', 'name')
		self.postdir = config.get('post', 'dir')
		self.style = ''.join(open(css_file, 'r').readlines())
		self.pages = dict.fromkeys(config.get('blog', 'pages').split(' '), '')
		self.sitedir = config.get('blog', 'dir')
		self.posts = Post.get_all(self)
		self.tagline = config.get('blog', 'tagline')


