#!/usr/bin/python
#
# captchaimage uses distutils.
# captchaimage requires the library Freetype 2. http://freetype.org
# To build: ./setup build
# To build and install: ./setup install
#
# 2008 Fredrik Portstrom
#
# I, the copyright holder of this file, hereby release it into the
# public domain. This applies worldwide. In case this is not legally
# possible: I grant anyone the right to use this work for any
# purpose, without any conditions, unless such conditions are
# required by law.

from setuptools import setup, find_packages,Extension

setup(
    name = "mycaptcha",
    version = "1.9",
    author = "zsp",
    author_email = "zsp007@gmail.com",
    description = "Create captcha image data",
    long_description = "captchaimage is a fast and easy to use Python "
    "extension for creating images with distorted text that are easy for "
    "humans and difficult for computers to read. Glyphs are loaded as bezier "
    "curves using Freetype, rotated and scaled randomly, and then distorted by "
    "adding Perlin noise to each point of the curve before rendering into a "
    "bitmap.",
    license = "Public Domain",
    include_package_data=True,
    zip_safe = False,
    classifiers = [
        "License :: Public Domain",
        "Programming Language :: C"],
    packages=find_packages(),
    ext_modules = [Extension(
            "captchaimage",
            include_dirs = ["/usr/include/freetype2"],
            sources = ["captchaimage.c"],
            libraries = ["freetype"])])
